/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.logging;

import com.ibm.es.nuvo.util.RobustRenameFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class FileHandler
extends StreamHandler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private RobustRenameFile[] files = null;
    private String pattern = null;
    private long limit = -1L;
    private int count = 2;
    private boolean append = true;
    private File currentLockFile = null;
    private FileOutputStream currentLockFileStream = null;
    private TrackedOutputStream currentTrackedOS = null;
    private Object rotationNotifier = null;

    public FileHandler(String pattern, long limit, int count, boolean append) throws IOException {
        this.pattern = pattern;
        this.limit = limit;
        if (count > 0) {
            this.count = count;
        }
        this.append = append;
        this.files = new RobustRenameFile[this.count];
        this.createFiles();
    }

    public synchronized void publish(LogRecord record) {
        if (!super.isLoggable(record)) {
            return;
        }
        super.publish(record);
        super.flush();
        if (this.limit > 0L && this.currentTrackedOS.currentSize >= this.limit) {
            this.rotateFile();
        }
    }

    public synchronized void close() {
        super.close();
        if (null != this.currentLockFileStream) {
            try {
                this.currentLockFileStream.close();
                this.currentLockFileStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (null != this.currentLockFile) {
            this.currentLockFile.delete();
            this.currentLockFile = null;
        }
    }

    public synchronized Object getLogRotationNotifier() {
        return this.rotationNotifier;
    }

    public synchronized void setLogRotationNotifier(Object objectToNotify) {
        this.rotationNotifier = objectToNotify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void rotateFile() {
        this.close();
        boolean renameFailed = false;
        for (int i = this.count - 2; i >= 0; --i) {
            RobustRenameFile f1 = this.files[i];
            RobustRenameFile f2 = this.files[i + 1];
            if (!f1.exists()) continue;
            if (f2.exists()) {
                f2.delete();
            }
            if (((File)f1).renameTo(f2)) continue;
            renameFailed = true;
        }
        try {
            boolean appendToUse = false;
            if (renameFailed) {
                appendToUse = this.append;
            }
            this.open(this.files[0], appendToUse);
        }
        catch (IOException ix) {
            this.reportError(null, ix, 4);
        }
        if (null != this.rotationNotifier) {
            Object object = this.rotationNotifier;
            synchronized (object) {
                this.rotationNotifier.notifyAll();
            }
        }
    }

    private synchronized void open(File file, boolean toAppend) throws IOException {
        long fileSize = 0L;
        this.lockFile(file);
        if (toAppend) {
            fileSize = file.length();
        }
        FileOutputStream fout = new FileOutputStream(file, toAppend);
        BufferedOutputStream bos = new BufferedOutputStream(fout);
        this.currentTrackedOS = new TrackedOutputStream(bos, fileSize);
        super.setOutputStream(this.currentTrackedOS);
    }

    private synchronized void lockFile(File file) throws IOException {
        String lockFileName = file.getAbsolutePath() + ".lck";
        this.currentLockFile = new File(lockFileName);
        if (!this.currentLockFile.exists()) {
            this.currentLockFile.createNewFile();
            this.currentLockFile.deleteOnExit();
        }
        this.currentLockFileStream = new FileOutputStream(this.currentLockFile);
        this.currentLockFileStream.getChannel().lock();
    }

    private synchronized void createFiles() throws IOException {
        File patternFile = new File(this.pattern);
        String msgFormatPatern = patternFile.getName();
        msgFormatPatern = msgFormatPatern.replaceAll("%g", "{0}");
        for (int i = 0; i < this.count; ++i) {
            String fileName = MessageFormat.format(msgFormatPatern, String.valueOf(i));
            this.files[i] = new RobustRenameFile(patternFile.getParentFile(), fileName);
        }
        this.open(this.files[0], this.append);
    }

    private static final class TrackedOutputStream
    extends OutputStream {
        OutputStream os = null;
        long currentSize = 0L;

        TrackedOutputStream(OutputStream os, long initialSize) {
            this.os = os;
            this.currentSize = initialSize;
        }

        public void write(int b) throws IOException {
            this.os.write(b);
            ++this.currentSize;
        }

        public void write(byte[] b) throws IOException {
            this.os.write(b);
            this.currentSize += (long)b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
            this.currentSize += (long)len;
        }

        public void flush() throws IOException {
            this.os.flush();
        }

        public void close() throws IOException {
            this.os.close();
        }
    }
}

