/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.logging;

import com.ibm.es.nuvo.logging.CompactLogRecordFormatter;
import com.ibm.es.nuvo.logging.DynamicFileHandlerException;
import com.ibm.es.nuvo.logging.FileHandler;
import java.io.File;
import java.io.FilenameFilter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class DynamicFileHandler
extends Handler
implements FilenameFilter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String LOG_FILE_POSTFIX_PATTERN = ".%g.log";
    private static final String LOG_FILE_POSTFIX_REGEX_PATTERN = "\\.[0-9]+\\.log";
    public static final String DEFAULT_DIRECTORY = "%h";
    public static final String DEFAULT_PREFIX = "nuvo";
    public static final int DEFAULT_LIMIT = 0x800000;
    public static final int DEFAULT_COUNT = 5;
    public static final String LOG_FILE_ENCODING = "UTF-8";
    private FileHandler fileHandler = null;
    private File directory = null;
    private String prefix = null;
    private int limit = 0;
    private int count = 0;

    public DynamicFileHandler(String directory, String prefix) {
        if (null == directory) {
            directory = System.getProperty("user.home");
        }
        this.directory = new File(directory);
        if (!this.directory.isDirectory()) {
            this.directory.mkdirs();
        }
        this.prefix = prefix;
    }

    public void setLimits(int limit, int count) throws DynamicFileHandlerException {
        if (limit == this.limit && count == this.count) {
            return;
        }
        String absoluteDirPath = this.directory.getAbsolutePath();
        StringBuffer prefixBuffer = new StringBuffer(absoluteDirPath);
        if (!absoluteDirPath.endsWith(File.separator)) {
            prefixBuffer.append(File.separatorChar);
        }
        prefixBuffer.append(this.prefix);
        prefixBuffer.append(LOG_FILE_POSTFIX_PATTERN);
        this.setLimitsSync(limit, count, prefixBuffer);
    }

    private synchronized void setLimitsSync(int limit, int count, StringBuffer prefixBuffer) throws DynamicFileHandlerException {
        try {
            Formatter formatter = null;
            Object objectToNotify = null;
            if (null != this.fileHandler) {
                this.fileHandler.flush();
                this.fileHandler.close();
                formatter = this.fileHandler.getFormatter();
                objectToNotify = this.fileHandler.getLogRotationNotifier();
                this.fileHandler = null;
            }
            if (null == formatter) {
                formatter = new CompactLogRecordFormatter();
            }
            String prefixBufferToString = prefixBuffer.toString();
            this.fileHandler = new FileHandler(prefixBufferToString, limit, count, true);
            this.fileHandler.setFormatter(formatter);
            this.fileHandler.setEncoding(LOG_FILE_ENCODING);
            this.fileHandler.setLogRotationNotifier(objectToNotify);
            this.limit = limit;
            this.count = count;
        }
        catch (Throwable t) {
            DynamicFileHandlerException dfhe = new DynamicFileHandlerException(t);
            throw dfhe;
        }
    }

    public synchronized void publish(LogRecord record) {
        if (null != this.fileHandler) {
            this.fileHandler.publish(record);
        }
    }

    public synchronized void flush() {
        if (null != this.fileHandler) {
            this.fileHandler.flush();
        }
    }

    public synchronized void close() throws SecurityException {
        if (null != this.fileHandler) {
            this.fileHandler.close();
            this.fileHandler = null;
        }
    }

    public synchronized void setFormatter(Formatter newFormatter) throws SecurityException {
        if (null != this.fileHandler) {
            this.fileHandler.setFormatter(newFormatter);
        }
    }

    public synchronized Formatter getFormatter() {
        if (null != this.fileHandler) {
            return this.fileHandler.getFormatter();
        }
        return null;
    }

    public synchronized void setLogRotationNotifier(Object objectToNotify) {
        if (null != this.fileHandler) {
            this.fileHandler.setLogRotationNotifier(objectToNotify);
        }
    }

    public boolean accept(File dir, String name) {
        return name.startsWith(this.prefix) && name.substring(this.prefix.length()).matches(LOG_FILE_POSTFIX_REGEX_PATTERN);
    }

    public String[] getLogFileNames() {
        return this.directory.list(this);
    }

    public File[] getLogFiles() {
        return this.directory.listFiles(this);
    }

    public int getCount() {
        return this.count;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getPrefix() {
        return this.prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(Level newLevel) {
        super.setLevel(newLevel);
        DynamicFileHandler dynamicFileHandler = this;
        synchronized (dynamicFileHandler) {
            if (null != this.fileHandler) {
                this.fileHandler.setLevel(newLevel);
            }
        }
    }

    public static void main(String[] args) {
    }
}

