/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.logging;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.logging.CompactLogRecordFormatter;
import com.ibm.es.nuvo.logging.LogWalker;
import com.ibm.es.nuvo.logging.LogWalkerFilter;
import com.ibm.es.nuvo.util.BufferedRandomAcessFileReader;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactLogRecordWalker
implements LogWalker<Object> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private BufferedRandomAcessFileReader fileToRead = null;
    private ByteArrayOutputStream nextRecordBuffer = null;
    private ByteArrayOutputStream prevRecordBuffer = null;
    private long curFileOffset = 0L;
    private ExtendedException lastError = null;
    private int lastReadByte = 0;
    private InputStream inputStream = null;
    private long markedPosition = 0L;
    private Stack<ExtendedException> extendedExceptionStack = new Stack();

    public CompactLogRecordWalker(File logFile) throws FileNotFoundException, IOException {
        this(logFile, StartPosition.StartAtBegining);
    }

    public CompactLogRecordWalker(File logFile, StartPosition position) throws FileNotFoundException, IOException {
        this.fileToRead = new BufferedRandomAcessFileReader(logFile, 1024);
        this.nextRecordBuffer = new ByteArrayOutputStream(10240);
        this.prevRecordBuffer = new ByteArrayOutputStream(10240);
        if (position == StartPosition.StartAtEnd) {
            this.curFileOffset = this.fileToRead.length();
            this.fileToRead.seek(this.curFileOffset);
        } else {
            this.curFileOffset = 0L;
        }
    }

    public void close() {
        try {
            this.fileToRead.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.prevRecordBuffer.reset();
        this.nextRecordBuffer.reset();
        this.extendedExceptionStack.clear();
    }

    public ExtendedException getLastError() {
        return this.lastError;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.internalHasNext();
    }

    private boolean internalHasNext() throws IOException {
        if (this.prevRecordBuffer.size() > 0) {
            this.prevRecordBuffer.reset();
            this.fileToRead.seek(this.curFileOffset);
        }
        if (this.nextRecordBuffer.size() > 0) {
            return true;
        }
        this.curFileOffset = this.fileToRead.getFilePointer();
        boolean foundStart = false;
        boolean foundEnd = false;
        int readByte = this.fileToRead.read();
        while (readByte != -1 && !foundEnd) {
            if (!foundStart) {
                if (60 == readByte) {
                    foundStart = true;
                    this.nextRecordBuffer.write(readByte);
                }
            } else {
                this.nextRecordBuffer.write(readByte);
                if (62 == readByte) {
                    foundEnd = true;
                }
            }
            readByte = this.fileToRead.read();
        }
        if (!foundEnd) {
            this.nextRecordBuffer.reset();
        }
        return foundEnd;
    }

    @Override
    public LogRecord next() throws IOException {
        if (this.nextRecordBuffer.size() <= 0 && !this.internalHasNext()) {
            return null;
        }
        return this.parseOneRecord(this.nextRecordBuffer);
    }

    @Override
    public boolean moveForwardPastNext() throws IOException {
        if (this.nextRecordBuffer.size() == 0 && !this.internalHasNext()) {
            return false;
        }
        this.curFileOffset += (long)this.nextRecordBuffer.size();
        this.fileToRead.seek(this.curFileOffset);
        this.nextRecordBuffer.reset();
        return true;
    }

    @Override
    public void skipToEnd() throws IOException {
        this.prevRecordBuffer.reset();
        this.nextRecordBuffer.reset();
        this.curFileOffset = this.fileToRead.length();
        this.fileToRead.seek(this.curFileOffset);
    }

    @Override
    public boolean hasPrevious() throws IOException {
        return this.internalHasPrevious();
    }

    private boolean internalHasPrevious() throws IOException {
        if (this.nextRecordBuffer.size() > 0) {
            this.nextRecordBuffer.reset();
            this.fileToRead.seek(this.curFileOffset);
        }
        if (this.prevRecordBuffer.size() > 0) {
            return true;
        }
        this.prevRecordBuffer.reset();
        this.curFileOffset = this.fileToRead.getFilePointer();
        boolean foundRecord = false;
        int SeekChunk = 1024;
        int numTries = 1;
        long totalBytesToCheck = numTries * SeekChunk;
        if (totalBytesToCheck >= this.curFileOffset) {
            totalBytesToCheck = this.curFileOffset;
        }
        long testStartOffset = this.curFileOffset - totalBytesToCheck;
        while (totalBytesToCheck > 0L && !foundRecord && numTries < 1000) {
            this.fileToRead.seek(testStartOffset);
            foundRecord = this.getSavePreviousBufferBytes(totalBytesToCheck);
            if (foundRecord) continue;
            if (0L == testStartOffset) {
                totalBytesToCheck = 0L;
                continue;
            }
            if ((totalBytesToCheck = (long)(++numTries * SeekChunk)) >= this.curFileOffset) {
                totalBytesToCheck = this.curFileOffset;
            }
            testStartOffset = this.curFileOffset - totalBytesToCheck;
        }
        if (!foundRecord) {
            this.prevRecordBuffer.reset();
            this.fileToRead.seek(this.curFileOffset);
        }
        return foundRecord;
    }

    @Override
    public LogRecord previous() throws IOException {
        if (this.prevRecordBuffer.size() == 0 && !this.internalHasPrevious()) {
            return null;
        }
        this.curFileOffset -= (long)this.prevRecordBuffer.size();
        this.fileToRead.seek(this.curFileOffset);
        return this.parseOneRecord(this.prevRecordBuffer);
    }

    @Override
    public boolean moveBackwardPastPrevious() throws IOException {
        if (this.prevRecordBuffer.size() == 0 && !this.internalHasPrevious()) {
            return false;
        }
        this.curFileOffset -= (long)this.prevRecordBuffer.size();
        this.fileToRead.seek(this.curFileOffset);
        this.prevRecordBuffer.reset();
        return true;
    }

    @Override
    public void skipToStart() throws IOException {
        this.prevRecordBuffer.reset();
        this.nextRecordBuffer.reset();
        this.curFileOffset = 0L;
        this.fileToRead.seek(this.curFileOffset);
    }

    public void mark() throws IOException {
        this.markedPosition = this.fileToRead.getFilePointer();
    }

    public void moveToLastMark() throws IOException {
        this.prevRecordBuffer.reset();
        this.nextRecordBuffer.reset();
        this.curFileOffset = this.markedPosition;
        this.fileToRead.seek(this.curFileOffset);
    }

    private boolean getSavePreviousBufferBytes(long totalBytesToCheck) throws IOException {
        long bytesLeft = totalBytesToCheck;
        long lastSkippedBytesLeft = 0L;
        byte[] savedBytes = null;
        while (bytesLeft > 0L) {
            lastSkippedBytesLeft = bytesLeft;
            bytesLeft = this.consumeNextRecordBytes(bytesLeft);
            if (this.prevRecordBuffer.size() <= 0) continue;
            if (bytesLeft == 0L) {
                return true;
            }
            savedBytes = this.prevRecordBuffer.toByteArray();
        }
        this.prevRecordBuffer.reset();
        if (null != savedBytes) {
            this.prevRecordBuffer.write(savedBytes);
            while (lastSkippedBytesLeft > 0L) {
                --lastSkippedBytesLeft;
                this.prevRecordBuffer.write(32);
            }
        }
        return savedBytes != null;
    }

    private long consumeNextRecordBytes(long totalBytesToCheck) throws IOException {
        long bytesRead;
        boolean foundStart = false;
        boolean foundEnd = false;
        this.prevRecordBuffer.reset();
        for (bytesRead = 0L; !foundEnd && bytesRead <= totalBytesToCheck; ++bytesRead) {
            int readByte = this.fileToRead.read();
            if (!foundStart) {
                if (readByte != 60) continue;
                foundStart = true;
                this.prevRecordBuffer.write(readByte);
                continue;
            }
            this.prevRecordBuffer.write(readByte);
            if (foundEnd || readByte != 62) continue;
            foundEnd = true;
        }
        if (!foundEnd) {
            this.prevRecordBuffer.reset();
        }
        return totalBytesToCheck - bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogRecord parseOneRecord(ByteArrayOutputStream buffer) {
        LogRecord retRecord = null;
        this.inputStream = new ByteArrayInputStream(buffer.toByteArray());
        try {
            do {
                LogRecord logRecord;
                String millisStr;
                block39: {
                    this.lastError = null;
                    try {
                        this.lastReadByte = this.inputStream.read();
                        if (this.lastReadByte != 60) continue;
                        this.lastReadByte = this.inputStream.read();
                        if (this.lastReadByte != 32) continue;
                        millisStr = this.getNextElementFromStream();
                        if (this.lastReadByte != -1) break block39;
                        LogRecord logRecord2 = null;
                        return logRecord2;
                    }
                    catch (Throwable t) {
                        Message msg = new Message("G0004E.XML_PARSE_FAILED", "CompactLogRecordWalker");
                        this.lastError = new ExtendedException(msg, t);
                        LogRecord logRecord3 = this.lastError.toLogRecord();
                        return logRecord3;
                    }
                }
                long logMillis = Long.parseLong(millisStr);
                String logMessage = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    LogRecord logRecord4 = null;
                    return logRecord4;
                }
                if (!Message.isValid(logMessage)) continue;
                String paramCountStr = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    LogRecord logRecord5 = null;
                    return logRecord5;
                }
                int logParamCount = Integer.parseInt(paramCountStr);
                Object[] logParams = new Object[logParamCount];
                for (int i = 0; i < logParams.length; ++i) {
                    logParams[i] = this.getNextParamFromStream();
                }
                String levelStr = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    LogRecord logRecord6 = null;
                    return logRecord6;
                }
                Level logLevel = Level.parse(levelStr);
                String loggerName = this.getNextElementFromStream();
                if (null != loggerName) {
                    try {
                        loggerName = URLDecoder.decode(loggerName, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                }
                if (this.lastReadByte == -1) {
                    LogRecord e = null;
                    return e;
                }
                String seqNumberStr = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    LogRecord logRecord7 = null;
                    return logRecord7;
                }
                long logSeqNumber = Long.parseLong(seqNumberStr);
                String logSourceClassName = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    LogRecord logRecord8 = null;
                    return logRecord8;
                }
                String logSourceMethodName = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    LogRecord logRecord9 = null;
                    return logRecord9;
                }
                String threadIDStr = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    LogRecord logRecord10 = null;
                    return logRecord10;
                }
                int logThreadID = Integer.parseInt(threadIDStr);
                retRecord = new LogRecord(logLevel, logMessage);
                retRecord.setParameters(logParams);
                retRecord.setLoggerName(loggerName);
                retRecord.setMillis(logMillis);
                retRecord.setSequenceNumber(logSeqNumber);
                retRecord.setSourceClassName(logSourceClassName);
                retRecord.setSourceMethodName(logSourceMethodName);
                retRecord.setThreadID(logThreadID);
                this.extendedExceptionStack.clear();
                this.lastReadByte = this.inputStream.read();
                while (this.lastReadByte != -1 && this.lastReadByte != 62) {
                    int firstByte = this.lastReadByte;
                    String eeMsgKey = this.getNextElementFromStream();
                    if (this.lastReadByte == -1) {
                        logRecord = null;
                        return logRecord;
                    }
                    if (null == eeMsgKey) continue;
                    Message eeMsg = new Message((char)firstByte + eeMsgKey);
                    String eeParamCountStr = this.getNextElementFromStream();
                    if (this.lastReadByte == -1) {
                        LogRecord logRecord11 = null;
                        return logRecord11;
                    }
                    int eeParamCount = Integer.parseInt(eeParamCountStr);
                    for (int i = 0; i < eeParamCount; ++i) {
                        eeMsg.addArgument(this.getNextParamFromStream());
                    }
                    String eeSTECountStr = this.getNextElementFromStream();
                    if (this.lastReadByte == -1) {
                        LogRecord logRecord12 = null;
                        return logRecord12;
                    }
                    int eeSTECount = Integer.parseInt(eeSTECountStr);
                    StackTraceElement[] eeSTEs = new StackTraceElement[eeSTECount];
                    for (int i = 0; i < eeSTEs.length; ++i) {
                        String steClassName = this.getNextElementFromStream();
                        String steMethodName = this.getNextElementFromStream();
                        String steFileName = this.getNextElementFromStream();
                        String steLineNumberStr = this.getNextElementFromStream();
                        int steLineNumber = Integer.parseInt(steLineNumberStr);
                        eeSTEs[i] = new StackTraceElement(steClassName, steMethodName, steFileName, steLineNumber);
                    }
                    ExtendedException ee = new ExtendedException(eeMsg);
                    ee.setStackTrace(eeSTEs);
                    this.extendedExceptionStack.push(ee);
                    this.lastReadByte = this.inputStream.read();
                }
                Throwable thrown = null;
                Throwable previousThrown = null;
                while (this.extendedExceptionStack.size() > 0) {
                    previousThrown = thrown;
                    thrown = this.extendedExceptionStack.pop();
                    if (null == previousThrown) continue;
                    thrown.initCause(previousThrown);
                }
                retRecord.setThrown(thrown);
                logRecord = retRecord;
                return logRecord;
            } while (this.lastReadByte != -1);
        }
        finally {
            this.inputStream = null;
            this.lastReadByte = -1;
            buffer.reset();
        }
        return null;
    }

    private String getNextElementFromStream() throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        this.lastReadByte = this.inputStream.read();
        while (this.lastReadByte != -1 && this.lastReadByte != 32) {
            byteBuffer.write(this.lastReadByte);
            this.lastReadByte = this.inputStream.read();
        }
        if (this.lastReadByte == -1) {
            return null;
        }
        String retString = byteBuffer.toString("UTF-8");
        if (retString.equals(CompactLogRecordFormatter.NULL_REPLACEMENT_STRING)) {
            retString = null;
        }
        return retString;
    }

    private Object getNextParamFromStream() throws IOException {
        Object retParam = null;
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        this.lastReadByte = this.inputStream.read();
        if (this.lastReadByte != 34) {
            while (this.lastReadByte != -1 && this.lastReadByte != 32) {
                byteBuffer.write(this.lastReadByte);
                this.lastReadByte = this.inputStream.read();
            }
            String numericString = byteBuffer.toString("UTF-8");
            char lastChar = numericString.charAt(numericString.length() - 1);
            try {
                if (lastChar == 'D') {
                    retParam = new Double(numericString.substring(0, numericString.length() - 1));
                }
                retParam = new Long(numericString.substring(0, numericString.length() - 1));
            }
            catch (Throwable t) {
                Message msg = new Message("G0004E.XML_PARSE_FAILED", "CompactLogRecordWalker");
                this.lastError = new ExtendedException(msg, t);
                return this.lastError.toLogRecord();
            }
        } else {
            this.lastReadByte = this.inputStream.read();
            while (this.lastReadByte != -1 && this.lastReadByte != 34) {
                byteBuffer.write(this.lastReadByte);
                this.lastReadByte = this.inputStream.read();
            }
            if (this.lastReadByte != 34) {
                return null;
            }
            this.lastReadByte = this.inputStream.read();
            if (this.lastReadByte != 32) {
                return null;
            }
            String strParam = byteBuffer.toString("UTF-8");
            retParam = (strParam = XMLTagger.unescapeXMLValue(strParam)).length() == 1 && strParam.charAt(0) == '\u0000' ? null : strParam;
        }
        return retParam;
    }

    @Override
    public void setFilter(LogWalkerFilter<Object> filter) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StartPosition {
        StartAtBegining,
        StartAtEnd;

    }
}

