/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.logging;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.logging.CompactLogRecordFormatter;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactLogRecordIterator
implements Iterator<LogRecord> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String INPUTSTREAM_ENCODING = "UTF-8";
    LogRecord nextRecord = null;
    InputStream inputStream = null;
    private int lastReadByte = 0;
    private ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(100);
    private Stack<ExtendedException> extendedExceptionStack = new Stack();
    ExtendedException lastError = null;

    public CompactLogRecordIterator(InputStream utf8Stream) {
        this.inputStream = utf8Stream;
    }

    @Override
    public boolean hasNext() {
        if (this.nextRecord != null) {
            return true;
        }
        this.nextRecord = this.parseOneRecord(this.inputStream);
        return this.nextRecord != null || this.lastError != null;
    }

    @Override
    public LogRecord next() {
        if (null == this.nextRecord && this.lastError == null) {
            throw new NoSuchElementException();
        }
        LogRecord retRecord = this.nextRecord;
        this.nextRecord = null;
        return retRecord;
    }

    @Override
    public void remove() {
    }

    public ExtendedException getLastError() {
        return this.lastError;
    }

    private LogRecord parseOneRecord(InputStream in) {
        LogRecord retRecord = null;
        do {
            this.lastError = null;
            try {
                this.lastReadByte = in.read();
                if (this.lastReadByte != 60) continue;
                this.lastReadByte = in.read();
                if (this.lastReadByte != 32) continue;
                String millisStr = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    return null;
                }
                long logMillis = Long.parseLong(millisStr);
                String logMessage = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    return null;
                }
                if (!Message.isValid(logMessage)) continue;
                String paramCountStr = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    return null;
                }
                int logParamCount = Integer.parseInt(paramCountStr);
                Object[] logParams = new Object[logParamCount];
                for (int i = 0; i < logParams.length; ++i) {
                    logParams[i] = this.getNextParamFromStream();
                }
                String levelStr = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    return null;
                }
                Level logLevel = Level.parse(levelStr);
                String loggerName = this.getNextElementFromStream();
                if (null != loggerName) {
                    try {
                        loggerName = URLDecoder.decode(loggerName, INPUTSTREAM_ENCODING);
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                }
                if (this.lastReadByte == -1) {
                    return null;
                }
                String seqNumberStr = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    return null;
                }
                long logSeqNumber = Long.parseLong(seqNumberStr);
                String logSourceClassName = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    return null;
                }
                String logSourceMethodName = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    return null;
                }
                String threadIDStr = this.getNextElementFromStream();
                if (this.lastReadByte == -1) {
                    return null;
                }
                int logThreadID = Integer.parseInt(threadIDStr);
                retRecord = new LogRecord(logLevel, logMessage);
                retRecord.setParameters(logParams);
                retRecord.setLoggerName(loggerName);
                retRecord.setMillis(logMillis);
                retRecord.setSequenceNumber(logSeqNumber);
                retRecord.setSourceClassName(logSourceClassName);
                retRecord.setSourceMethodName(logSourceMethodName);
                retRecord.setThreadID(logThreadID);
                this.extendedExceptionStack.clear();
                this.lastReadByte = this.inputStream.read();
                while (this.lastReadByte != -1 && this.lastReadByte != 62) {
                    int firstByte = this.lastReadByte;
                    String eeMsgKey = this.getNextElementFromStream();
                    if (this.lastReadByte == -1) {
                        return null;
                    }
                    if (null == eeMsgKey) continue;
                    Message eeMsg = new Message((char)firstByte + eeMsgKey);
                    String eeParamCountStr = this.getNextElementFromStream();
                    if (this.lastReadByte == -1) {
                        return null;
                    }
                    int eeParamCount = Integer.parseInt(eeParamCountStr);
                    for (int i = 0; i < eeParamCount; ++i) {
                        eeMsg.addArgument(this.getNextParamFromStream());
                    }
                    String eeSTECountStr = this.getNextElementFromStream();
                    if (this.lastReadByte == -1) {
                        return null;
                    }
                    int eeSTECount = Integer.parseInt(eeSTECountStr);
                    StackTraceElement[] eeSTEs = new StackTraceElement[eeSTECount];
                    for (int i = 0; i < eeSTEs.length; ++i) {
                        String steClassName = this.getNextElementFromStream();
                        String steMethodName = this.getNextElementFromStream();
                        String steFileName = this.getNextElementFromStream();
                        String steLineNumberStr = this.getNextElementFromStream();
                        int steLineNumber = Integer.parseInt(steLineNumberStr);
                        eeSTEs[i] = new StackTraceElement(steClassName, steMethodName, steFileName, steLineNumber);
                    }
                    ExtendedException ee = new ExtendedException(eeMsg);
                    ee.setStackTrace(eeSTEs);
                    this.extendedExceptionStack.push(ee);
                    this.lastReadByte = this.inputStream.read();
                }
                Throwable thrown = null;
                Throwable previousThrown = null;
                while (this.extendedExceptionStack.size() > 0) {
                    previousThrown = thrown;
                    thrown = this.extendedExceptionStack.pop();
                    if (null == previousThrown) continue;
                    thrown.initCause(previousThrown);
                }
                retRecord.setThrown(thrown);
                return retRecord;
            }
            catch (Throwable t) {
                Message msg = new Message("G0004E.XML_PARSE_FAILED", "CompactLogRecordWalker");
                this.lastError = new ExtendedException(msg, t);
                return this.lastError.toLogRecord();
            }
        } while (this.lastReadByte != -1);
        return null;
    }

    private String getNextElementFromStream() throws IOException {
        this.byteBuffer.reset();
        this.lastReadByte = this.inputStream.read();
        while (this.lastReadByte != -1 && this.lastReadByte != 32) {
            this.byteBuffer.write(this.lastReadByte);
            this.lastReadByte = this.inputStream.read();
        }
        if (this.lastReadByte == -1) {
            return null;
        }
        String retString = this.byteBuffer.toString(INPUTSTREAM_ENCODING);
        if (retString.equals(CompactLogRecordFormatter.NULL_REPLACEMENT_STRING)) {
            retString = null;
        }
        return retString;
    }

    private Object getNextParamFromStream() throws IOException {
        Object retParam = null;
        this.byteBuffer.reset();
        this.lastReadByte = this.inputStream.read();
        if (this.lastReadByte != 34) {
            while (this.lastReadByte != -1 && this.lastReadByte != 32) {
                this.byteBuffer.write(this.lastReadByte);
                this.lastReadByte = this.inputStream.read();
            }
            String numericString = this.byteBuffer.toString(INPUTSTREAM_ENCODING);
            char lastChar = numericString.charAt(numericString.length() - 1);
            try {
                if (lastChar == 'D') {
                    retParam = new Double(numericString.substring(0, numericString.length() - 1));
                }
                retParam = new Long(numericString.substring(0, numericString.length() - 1));
            }
            catch (Throwable t) {
                Message msg = new Message("G0004E.XML_PARSE_FAILED", "CompactLogRecordWalker");
                this.lastError = new ExtendedException(msg, t);
                return this.lastError.toLogRecord();
            }
        } else {
            this.lastReadByte = this.inputStream.read();
            while (this.lastReadByte != -1 && this.lastReadByte != 34) {
                this.byteBuffer.write(this.lastReadByte);
                this.lastReadByte = this.inputStream.read();
            }
            if (this.lastReadByte != 34) {
                return null;
            }
            this.lastReadByte = this.inputStream.read();
            if (this.lastReadByte != 32) {
                return null;
            }
            String strParam = this.byteBuffer.toString(INPUTSTREAM_ENCODING);
            retParam = (strParam = XMLTagger.unescapeXMLValue(strParam)).length() == 1 && strParam.charAt(0) == '\u0000' ? null : strParam;
        }
        return retParam;
    }
}

