/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.logging;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class CompactLogRecordFormatter
extends Formatter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String STRING_URL_ENCODING = "UTF-8";
    public static final char LOG_RECORD_START = '<';
    public static final char LOG_RECORD_END = '>';
    public static final char SEPARATOR = ' ';
    public static final String SEPARATOR_FALLBACK_REPLACEMENT = "_";
    public static final char QUOTE = '\"';
    public static final char NULL_REPLACMENT_CHAR = '*';
    public static final String NULL_REPLACEMENT_STRING = Character.toString('*');
    public static final char PARAM_LONG = 'L';
    public static final char PARAM_DOUBLE = 'D';
    private StringBuffer stringBuffer = new StringBuffer(1024);
    private boolean isPrintingStackTrace = true;

    public void setPrintingStackTrace(boolean value) {
        this.isPrintingStackTrace = value;
    }

    public boolean isPrintingStackTrace() {
        return this.isPrintingStackTrace;
    }

    public String format(LogRecord record) {
        this.stringBuffer.setLength(0);
        this.stringBuffer.append('<');
        this.stringBuffer.append(' ');
        this.append(record.getMillis());
        this.appendMessage(record.getMessage(), record.getParameters(), record.getLevel());
        this.append(record.getLevel().getName());
        this.append(record.getLoggerName());
        this.append(record.getSequenceNumber());
        this.append(record.getSourceClassName());
        this.append(record.getSourceMethodName());
        this.append(record.getThreadID());
        for (Throwable thrown = record.getThrown(); thrown != null; thrown = thrown.getCause()) {
            if (!(thrown instanceof ExtendedException)) {
                ExtendedException ee = new ExtendedException(thrown.toString(), thrown.getCause());
                ee.setStackTrace(thrown.getStackTrace());
                thrown = ee;
            }
            this.apppendExtendedException((ExtendedException)thrown);
        }
        this.stringBuffer.append('>');
        this.stringBuffer.append('\n');
        return this.stringBuffer.toString();
    }

    private void append(long numeric) {
        this.stringBuffer.append(numeric);
        this.stringBuffer.append(' ');
    }

    private void append(String string) {
        if (null == string || 0 == string.trim().length()) {
            string = NULL_REPLACEMENT_STRING;
        }
        try {
            this.stringBuffer.append(URLEncoder.encode(string, STRING_URL_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            this.stringBuffer.append(string.replaceAll(Character.toString(' '), SEPARATOR_FALLBACK_REPLACEMENT));
        }
        this.stringBuffer.append(' ');
    }

    private void appendMessage(String key, Object[] parameters, Level level) {
        String keyToUse = key;
        if (null == keyToUse || !Message.isValid(keyToUse)) {
            keyToUse = level == Level.SEVERE ? "G0020E.EXTERNAL_ERROR_MESSAGE" : "G0019I.EXTERNAL_INFO_MESSAGE";
            this.append(keyToUse);
            this.append(1L);
            StringBuffer paramBuffer = new StringBuffer(null != key ? key : "");
            paramBuffer.append(' ');
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    Object curParam = parameters[i];
                    paramBuffer.append('[');
                    if (null == curParam) {
                        paramBuffer.append('\u0000');
                    } else {
                        paramBuffer.append(curParam.toString());
                    }
                    paramBuffer.append(']');
                }
            }
            this.appendParam(paramBuffer.toString());
        } else {
            this.append(keyToUse);
            int count = 0;
            if (null != parameters) {
                count = parameters.length;
            }
            this.append(count);
            Object curParam = null;
            for (int i = 0; i < count; ++i) {
                curParam = parameters[i];
                if (null == curParam) {
                    this.appendParam(null);
                    continue;
                }
                if (curParam instanceof String) {
                    this.appendParam((String)curParam);
                    continue;
                }
                if (curParam instanceof Double) {
                    this.appendParam((Double)curParam);
                    continue;
                }
                if (curParam instanceof Long) {
                    this.appendParam((Long)curParam);
                    continue;
                }
                this.appendParam(curParam.toString());
            }
        }
    }

    private void appendParam(String string) {
        if (null == string) {
            string = "";
        }
        this.stringBuffer.append('\"');
        this.stringBuffer.append(XMLTagger.escapeXMLValue(string));
        this.stringBuffer.append('\"');
        this.stringBuffer.append(' ');
    }

    private void appendParam(long numeric) {
        this.stringBuffer.append(numeric);
        this.stringBuffer.append('L');
        this.stringBuffer.append(' ');
    }

    private void appendParam(double numeric) {
        this.stringBuffer.append(numeric);
        this.stringBuffer.append('D');
        this.stringBuffer.append(' ');
    }

    private void apppendExtendedException(ExtendedException ee) {
        Message msg = ee.getNonLocalizedMessage();
        this.appendMessage(msg.getKey(), msg.getArguments(), Level.SEVERE);
        if (this.isPrintingStackTrace) {
            StackTraceElement[] elements = ee.getStackTrace();
            int count = 0;
            if (null != elements) {
                count = elements.length;
            }
            this.append(count);
            StackTraceElement curElement = null;
            for (int i = 0; i < count; ++i) {
                curElement = elements[i];
                if (null == curElement) continue;
                this.append(curElement.getClassName());
                this.append(curElement.getMethodName());
                this.append(curElement.getFileName());
                this.append(curElement.getLineNumber());
            }
        } else {
            this.append(0L);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                GlobalConfiguration.initialize(args[0]);
            }
            CompactLogRecordFormatter formatter = new CompactLogRecordFormatter();
            Message msg = new Message("G0004E.XML_PARSE_FAILED");
            String strArg = "Some XML stream with weird chars <>&\"' and a chinese char \u8449";
            msg.addArgument(strArg);
            Message eemsg = new Message("G0005E.CREATE_OBJECT_FAILED");
            eemsg.addArgument("XMLParsing");
            ExtendedException ee = new ExtendedException(eemsg);
            LogRecord logRecord = new LogRecord(Level.SEVERE, msg.getKey());
            System.out.println(formatter.format(logRecord));
            logRecord.setParameters(msg.getArguments());
            System.out.println(formatter.format(logRecord));
            logRecord.setThrown(ee);
            logRecord.setLoggerName("com.ibm.es.nuvo");
            logRecord.setParameters(msg.getArguments());
            logRecord.setSourceClassName("LogRecordFormatter.java");
            logRecord.setSourceMethodName("main");
            System.out.println(formatter.format(logRecord));
            Loggers.getWrappedLogger().initialize();
            Loggers.logger.log(logRecord);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

