/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.lock;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.lock.LockException;
import com.ibm.es.nuvo.lock.LockObject;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public class RemoteLockManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static RemoteLockManager instance = null;
    private Hashtable<LockId, LockObject> locks = new Hashtable();

    public static RemoteLockManager getInstance() {
        if (instance == null) {
            instance = new RemoteLockManager();
        }
        return instance;
    }

    private RemoteLockManager() {
    }

    public void initialize() throws ExtendedException, IOException {
        boolean createOk;
        LockId[] values = LockId.values();
        String lockDir = GlobalConfiguration.getConfiguration().getLockDirectory() + File.separator;
        File fLockDir = new File(lockDir);
        if (!fLockDir.exists() && !(createOk = fLockDir.mkdirs())) {
            Message msg = new Message("G0149E.COULD_NOT_CREATE_DIRECTORY", fLockDir.getAbsolutePath());
            throw new ExtendedException(msg);
        }
        for (int i = 0; i < values.length; ++i) {
            boolean createOk2;
            File f = new File(lockDir, values[i].getFileName());
            if (!f.exists() && !(createOk2 = f.createNewFile())) {
                Message msg = new Message("G0172E.COULD_NOT_CREATE_FILE", f.getAbsolutePath());
                throw new ExtendedException(msg);
            }
            this.locks.put(values[i], new LockObject(values[i].getFullyQualifiedFileName()));
        }
    }

    public void lock(LockId lockId) throws LockException {
        LockObject lockObj = this.locks.get((Object)lockId);
        try {
            lockObj.lock();
        }
        catch (IOException e) {
            e.printStackTrace();
            Message msg = new Message("G0173E.COULD_NOT_LOCK_FILE", lockId.getFullyQualifiedFileName());
            throw new LockException(msg, (Throwable)e);
        }
    }

    public void unlock(LockId lockId) throws IOException {
        LockObject lockObj = this.locks.get((Object)lockId);
        lockObj.unlock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockId {
        ConfigurationLock("configuration.lock"),
        FileIOLock("fileio.lock");

        private String fileName = null;

        private LockId(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFullyQualifiedFileName() {
            String lockDir = GlobalConfiguration.getConfiguration().getLockDirectory() + File.separator;
            return lockDir + this.fileName;
        }
    }
}

