/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.lock;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.locks.ReentrantLock;

public class LockObject {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String fileName = null;
    private ReentrantLock lock = null;
    private RandomAccessFile raFile = null;
    private FileChannel fileChannel = null;
    private FileLock fileLock = null;

    public LockObject(String fileName) {
        this.fileName = fileName;
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws IOException {
        boolean lockOk = false;
        try {
            this.lock.lock();
            if (this.raFile == null) {
                this.raFile = new RandomAccessFile(this.fileName, "rw");
                this.fileChannel = this.raFile.getChannel();
                this.fileLock = this.fileChannel.lock();
                if (this.fileLock == null) {
                    throw new RuntimeException("Unexpected null fileLock returned");
                }
            }
            lockOk = true;
        }
        finally {
            if (!lockOk) {
                this.closeFile(false);
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() throws IOException {
        try {
            if (this.lock.isHeldByCurrentThread() && this.lock.getHoldCount() == 1) {
                this.closeFile(true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    private void closeFile(boolean throwException) throws IOException {
        IOException error = null;
        if (this.fileLock != null) {
            block10: {
                try {
                    this.fileLock.release();
                }
                catch (IOException e) {
                    if (error != null) break block10;
                    error = e;
                }
            }
            this.fileLock = null;
        }
        if (this.fileChannel != null) {
            block11: {
                try {
                    this.fileChannel.close();
                }
                catch (IOException e) {
                    if (error != null) break block11;
                    error = e;
                }
            }
            this.fileChannel = null;
        }
        if (this.raFile != null) {
            block12: {
                try {
                    this.raFile.close();
                }
                catch (IOException e) {
                    if (error != null) break block12;
                    error = e;
                }
            }
            this.raFile = null;
        }
        if (throwException && error != null) {
            throw error;
        }
    }
}

