/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.launcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class LauncherFrame
extends JFrame {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = -8992786408885958195L;
    private final int NUM_BUBBLES = 10;
    private JLabel[] dotProgress;
    private JLabel windowTitle;
    private JLabel statusLabel;
    private JPanel progressPanel;
    private JPanel contentPanel;
    private JPanel centerPanel;
    private JPanel southPanel;
    private JPanel northPanel;
    private JButton okButton;
    private String imageDirectory;
    int totalSteps = 100;
    int currentStep = 0;
    int bubbleIndex = 0;

    public void initializeUI() {
        this.setLayout(new BorderLayout());
        Locale systemLocale = Locale.getDefault();
        String filename = this.imageDirectory + File.separator + "loading-bg_" + systemLocale.getLanguage() + "_" + systemLocale.getCountry() + ".gif";
        File imageFile = new File(filename);
        if (!imageFile.exists() && !(imageFile = new File(filename = this.imageDirectory + File.separator + "loading-bg_" + systemLocale.getLanguage() + ".gif")).exists()) {
            filename = this.imageDirectory + File.separator + "loading-bg_en.gif";
        }
        ImageIcon image = new ImageIcon(filename);
        JLabel background = new JLabel(image);
        background.setBounds(0, 0, image.getIconWidth(), image.getIconHeight());
        this.getLayeredPane().setOpaque(false);
        this.getLayeredPane().add((Component)background, new Integer(Integer.MIN_VALUE));
        this.setSize(image.getIconWidth(), image.getIconHeight());
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Point p = new Point();
        p.x = d.width / 2 - image.getIconWidth() / 2;
        p.y = d.height / 2 - image.getIconHeight() / 2;
        this.setLocation(p);
        this.setUndecorated(true);
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        mainPanel.setSize(this.getSize());
        mainPanel.setLayout(new BorderLayout());
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setOpaque(false);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(null);
        this.centerPanel.setOpaque(false);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new FlowLayout());
        this.progressPanel.setOpaque(false);
        ImageIcon dotImage = new ImageIcon(this.imageDirectory + File.separator + "loading-bubble-empty.gif");
        this.windowTitle = new JLabel(" ");
        this.northPanel = new JPanel();
        this.northPanel.add(this.windowTitle);
        this.northPanel.setOpaque(false);
        this.contentPanel.add((Component)this.northPanel, "North");
        this.dotProgress = new JLabel[this.NUM_BUBBLES];
        for (int i = 0; i < this.NUM_BUBBLES; ++i) {
            this.dotProgress[i] = new JLabel(dotImage);
            this.progressPanel.add((Component)this.dotProgress[i], i);
        }
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setFont(new Font("dialog", 0, 11));
        this.southPanel = new JPanel();
        this.southPanel.add(this.statusLabel);
        this.southPanel.setOpaque(false);
        this.contentPanel.add((Component)this.southPanel, "South");
        this.contentPanel.add((Component)this.centerPanel, "Center");
        this.contentPanel.doLayout();
        this.progressPanel.setSize(dotImage.getIconWidth() * (this.NUM_BUBBLES + 3), dotImage.getIconHeight());
        this.centerPanel.add(this.progressPanel);
        mainPanel.add((Component)this.contentPanel, "Center");
        this.setContentPane(mainPanel);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setVisible(true);
        this.progressPanel.setLocation(258, 78);
        this.validate();
    }

    public void setTotalSteps(int totalSteps) {
        this.totalSteps = totalSteps;
    }

    public void setProgress(int stepNum) {
        double percentChange = 100.0 * (double)(stepNum - this.currentStep) / (double)this.totalSteps;
        ImageIcon filledDotImage = new ImageIcon(this.imageDirectory + File.separator + "loading-bubble-filled.gif");
        while (percentChange >= (double)(100 / this.NUM_BUBBLES)) {
            this.dotProgress[this.bubbleIndex] = new JLabel(filledDotImage);
            this.progressPanel.remove(this.bubbleIndex);
            this.progressPanel.add((Component)this.dotProgress[this.bubbleIndex], this.bubbleIndex);
            this.progressPanel.validate();
            this.validate();
            percentChange -= (double)(100 / this.NUM_BUBBLES);
            ++this.bubbleIndex;
            this.currentStep = stepNum;
        }
        if (stepNum == this.totalSteps) {
            while (this.bubbleIndex < this.NUM_BUBBLES) {
                this.dotProgress[this.bubbleIndex] = new JLabel(filledDotImage);
                this.progressPanel.remove(this.bubbleIndex);
                this.progressPanel.add((Component)this.dotProgress[this.bubbleIndex], this.bubbleIndex);
                this.progressPanel.validate();
                this.validate();
                ++this.bubbleIndex;
                this.currentStep = stepNum;
            }
        }
    }

    public void setComplete() {
        this.setProgress(this.totalSteps);
    }

    public void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }

    public void showInformational(String string) {
        JOptionPane.showMessageDialog(this, string, "", 1);
    }

    public void setLabel(String text) {
        this.windowTitle.setText(text);
        this.validate();
    }

    public void setStatusLabel(String status) {
        this.statusLabel.setText(status);
        this.validate();
    }

    public void showOKButton() {
        this.southPanel.removeAll();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ButtonHandler());
        this.okButton.setVisible(true);
        this.southPanel.add(this.okButton);
        this.validate();
    }

    public String getImageDirectory() {
        return this.imageDirectory;
    }

    public void setImageDirectory(String imageDirectory) {
        this.imageDirectory = imageDirectory;
    }

    class ButtonHandler
    implements ActionListener {
        ButtonHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }
}

