/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.launcher;

import com.ibm.es.nuvo.Startup;
import com.ibm.es.nuvo.StartupArgument;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.JettyConfiguration;
import com.ibm.es.nuvo.launcher.LauncherFrame;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Launcher {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String STARTUP_CLASS = "com.ibm.es.nuvo.Startup";
    private static final int RETURN_CODE_SUCCESS = 0;
    private static final int RETURN_CODE_RUNNING = 0;
    private static final int RETURN_CODE_FAILURE = 1;
    private LauncherFrame launcherFrame;
    private List<String> messages;
    private GlobalConfiguration config;
    private Writer stackTrace;
    private PrintWriter printWriter;
    private String os = System.getProperty("os.name").toUpperCase();
    private boolean consoleMode = false;
    private String javaArgs = "";
    private String whitneyArgs = "";
    private String command = "";
    private Message productName;
    private String libJars = "";
    private String errorLog = "startupErrors.html";

    public String getErrorLog() {
        return this.errorLog;
    }

    public void setErrorLog(String errorLog) {
        this.errorLog = errorLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int retCode = 1;
        Launcher launcher = new Launcher();
        if (!launcher.parseArguments(args)) {
            launcher.printUsage();
            System.exit(retCode);
        }
        try {
            retCode = launcher.launchStartup();
            if (retCode != 1) {
                if (!launcher.isConsoleMode()) {
                    launcher.launchAdmin();
                }
            } else {
                launcher.dumpLog();
            }
        }
        catch (RuntimeException e) {
            try {
                launcher.logMessage(e.getMessage());
                launcher.dumpLog();
            }
            catch (RuntimeException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            launcher.killGUI();
        }
        System.exit(retCode);
    }

    public Launcher() {
    }

    public Launcher(String globalConfigPath) {
        try {
            GlobalConfiguration.initialize(globalConfigPath);
            this.config = GlobalConfiguration.getConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean parseArguments(String[] args) {
        int argIndex = 1;
        boolean whitneyArg = false;
        if (args.length == 0) {
            return false;
        }
        try {
            GlobalConfiguration.initialize(args[0]);
            ReleaseInfo.initialize(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.config = GlobalConfiguration.getConfiguration();
        this.productName = new Message(ReleaseInfo.getReleaseInfo().getValue("System", "ProductName"));
        StartupArgument[] validArgs = StartupArgument.getArguments();
        for (int i = argIndex; i < args.length; ++i) {
            whitneyArg = false;
            for (int j = 0; j < validArgs.length; ++j) {
                if (!validArgs[j].getName().toLowerCase().equals(args[i].toLowerCase())) continue;
                this.whitneyArgs = this.whitneyArgs + args[i] + " ";
                whitneyArg = true;
                break;
            }
            if (whitneyArg) continue;
            if (args[i].toLowerCase().equals("-console")) {
                this.setConsoleMode(true);
                continue;
            }
            if (args[i].startsWith("-")) {
                this.javaArgs = this.javaArgs + args[i] + " ";
                continue;
            }
            this.whitneyArgs = this.whitneyArgs + args[i] + " ";
        }
        return true;
    }

    public void printUsage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int launchStartup() {
        int returnCode = 1;
        Runtime runtime = Runtime.getRuntime();
        Process whitneyProcess = null;
        BufferedReader output = null;
        BufferedReader errorOutput = null;
        String configFile = this.config.getConfigPath() + File.separator + "config.xml";
        if (this.isRunning()) {
            returnCode = 0;
        }
        try {
            if (!ReleaseInfo.getReleaseInfo().getValueAsBoolean("System", "ShowStartupUI", true)) {
                this.setConsoleMode(true);
            }
        }
        catch (ExtendedException e) {
            // empty catch block
        }
        if (!this.isConsoleMode()) {
            try {
                this.launcherFrame = new LauncherFrame();
            }
            catch (Exception noDisplay) {
                this.consoleMode = true;
            }
        }
        if (returnCode != 0 || this.isConsoleMode()) {
            Message message;
            String classPath;
            String javaPath;
            String line;
            if (!this.isConsoleMode()) {
                this.launcherFrame.setImageDirectory(this.config.getResourcePath() + File.separator + "images");
                this.launcherFrame.initializeUI();
                Message message2 = new Message("G0121E.SYSTEM_STARTING", this.productName.getFormattedText());
                this.launcherFrame.setStatusLabel(message2.getFormattedText());
            }
            File libDir = new File(this.config.getInstallPath() + File.separator + "lib");
            this.findJarFiles(libDir);
            this.libJars = this.libJars + this.config.getResourcePath() + File.separator + "bundles" + File.pathSeparator;
            File externalJarsFile = new File(libDir, "_extJars.txt");
            if (externalJarsFile.exists()) {
                try {
                    BufferedReader in = new BufferedReader(new FileReader(externalJarsFile));
                    try {
                        while ((line = in.readLine()) != null) {
                            if (line.trim().length() == 0 || line.startsWith("//")) continue;
                            if (line.startsWith("*")) {
                                line = System.getenv(line.substring(1));
                            }
                            if (line == null || !new File(line).exists()) continue;
                            this.libJars = this.libJars + line + File.pathSeparator;
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.os.contains("WINDOW")) {
                javaPath = "\"" + System.getProperty("java.home") + "/bin/java.exe\" ";
                classPath = " -cp \"" + this.libJars + "\"";
                configFile = "\"" + configFile + "\"";
            } else {
                if (System.getenv("LD_ASSUME_KERNEL") != null && System.getenv("LD_ASSUME_KERNEL").length() != 0) {
                    message = new Message("G0128E.LD_ASSUME_KERNEL", this.productName.getFormattedText());
                    if (this.consoleMode) {
                        System.out.println(message.getFormattedText());
                    } else {
                        this.launcherFrame.showInformational(message.getFormattedText());
                    }
                }
                javaPath = System.getProperty("java.home") + "/bin/java ";
                classPath = " -cp " + this.libJars;
            }
            this.javaArgs = this.javaArgs + "-Dfile.encoding=utf-8 ";
            this.javaArgs = this.javaArgs + "-Dconsole.encoding=utf-8 ";
            this.command = javaPath;
            this.command = this.command + classPath;
            this.command = this.command + " " + this.javaArgs;
            this.command = this.command + " com.ibm.es.nuvo.Startup";
            this.command = this.command + " " + configFile;
            this.command = this.command + " " + this.whitneyArgs;
            this.command = this.command + " -status";
            Integer totalSteps = null;
            try {
                whitneyProcess = runtime.exec(this.command);
                if (whitneyProcess == null) {
                    message = new Message("G0122E.SYSTEM_START_FAILED_COMMAND", this.command);
                    this.logMessage(message.getFormattedTextWithDisplayKey());
                    int n = 1;
                    return n;
                }
                output = new BufferedReader(new InputStreamReader(whitneyProcess.getInputStream(), "UTF-8"));
                errorOutput = new BufferedReader(new InputStreamReader(whitneyProcess.getErrorStream(), "UTF-8"));
                do {
                    Integer step;
                    int substringEnd;
                    if ((line = output.readLine()) == null) {
                        line = errorOutput.readLine();
                    }
                    if (this.consoleMode && line != null) {
                        if (line.startsWith("StatusNumSteps_")) {
                            totalSteps = new Integer(line.substring(15).trim());
                            continue;
                        }
                        if (line.startsWith("Status_")) {
                            substringEnd = line.indexOf(" ");
                            if (substringEnd == -1) {
                                substringEnd = line.length();
                            }
                            if ((step = new Integer(line.substring(7, substringEnd).trim())).compareTo(totalSteps) != 0) continue;
                            returnCode = 0;
                            if (!output.ready()) {
                                Thread.sleep(1000L);
                            }
                            if (!output.ready()) continue;
                            this.logMessage(output.readLine());
                            continue;
                        }
                        this.logMessage(line);
                        continue;
                    }
                    if (line == null || line.trim().length() == 0) continue;
                    if ((line = line.trim()).startsWith("StatusNumSteps_")) {
                        totalSteps = new Integer(line.substring(15).trim());
                        this.launcherFrame.setTotalSteps(totalSteps);
                        continue;
                    }
                    if (line.startsWith("Status_")) {
                        substringEnd = line.indexOf(" ");
                        if (substringEnd == -1) {
                            substringEnd = line.length();
                        }
                        step = new Integer(line.substring(7, substringEnd).trim());
                        this.launcherFrame.setProgress(step);
                        if (step.compareTo(totalSteps) != 0) continue;
                        returnCode = 0;
                        continue;
                    }
                    this.logMessage(line);
                } while (line != null && returnCode != 0);
                if (this.consoleMode || returnCode != 0) return returnCode;
                this.launcherFrame.setComplete();
                return returnCode;
            }
            catch (Exception e) {
                this.stackTrace = new StringWriter();
                this.printWriter = new PrintWriter(this.stackTrace);
                e.printStackTrace(this.printWriter);
                this.logMessage(this.stackTrace.toString());
                int n = returnCode;
                return n;
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                    if (errorOutput != null) {
                        errorOutput.close();
                    }
                }
                catch (Exception e) {
                    this.stackTrace = new StringWriter();
                    this.printWriter = new PrintWriter(this.stackTrace);
                    e.printStackTrace(this.printWriter);
                    this.logMessage(this.stackTrace.toString());
                }
            }
        }
        this.launcherFrame = null;
        return returnCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void findJarFiles(File libDir) {
        if (libDir.isDirectory()) {
            String[] children = libDir.list();
            for (int i = 0; i < children.length; ++i) {
                this.findJarFiles(new File(libDir, children[i]));
            }
            return;
        } else {
            try {
                String path = libDir.getCanonicalPath();
                if (!path.endsWith(".jar")) return;
                this.libJars = this.libJars + path + File.pathSeparator;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void launchAdmin() {
        Message message;
        String adminURL = "http://localhost";
        String adminContext = "/admin";
        int adminPort = 0;
        if (this.launcherFrame != null) {
            message = new Message("G0123E.LAUNCHING_ADMIN");
            this.launcherFrame.setStatusLabel(message.getFormattedText());
        }
        try {
            JettyConfiguration jc = new JettyConfiguration(this.config);
            adminURL = jc.getAdminAppURL();
            adminPort = jc.getAdminHttpPort();
            if (adminPort == 0) {
                adminPort = jc.getAdminHttpsPort();
            }
            adminContext = jc.getAdminContext();
        }
        catch (Exception e) {
            this.stackTrace = new StringWriter();
            this.printWriter = new PrintWriter(this.stackTrace);
            e.printStackTrace(this.printWriter);
            this.logMessage(this.stackTrace.toString());
            this.dumpLog();
            return;
        }
        if (adminContext != null) {
            adminURL = adminURL + adminContext;
        }
        if (!this.launchWebBrowser(adminURL)) {
            if (this.launcherFrame == null) {
                this.launcherFrame = new LauncherFrame();
            }
            message = new Message("G0124E.SYSTEM_RUNNING", adminPort);
            this.launcherFrame.showInformational(message.getFormattedTextWithDisplayKey());
        } else {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void logMessage(String message) {
        if (!this.isConsoleMode()) {
            if (this.messages == null) {
                this.messages = new ArrayList<String>();
            }
            this.messages.add(message + "<br/>");
        } else {
            System.out.println(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        FileLock lock = null;
        AbstractInterruptibleChannel channel = null;
        RandomAccessFile configFile = null;
        boolean returnCode = true;
        File configLock = new File(this.config.getConfigPath() + File.separator + "config.xml" + Startup.globalConfigFileLockExtension);
        if (!configLock.exists()) {
            return false;
        }
        try {
            configFile = new RandomAccessFile(configLock, "rw");
            channel = configFile.getChannel();
            lock = ((FileChannel)channel).tryLock();
            if (lock != null) {
                returnCode = false;
                lock.release();
            }
        }
        catch (FileNotFoundException e1) {
            returnCode = false;
        }
        catch (Exception e2) {
            returnCode = true;
        }
        finally {
            try {
                if (channel != null) {
                    channel.close();
                }
                if (configFile != null) {
                    configFile.close();
                }
            }
            catch (Exception e3) {}
        }
        return returnCode;
    }

    public void killGUI() {
        if (this.launcherFrame != null) {
            this.launcherFrame.dispose();
        }
    }

    public void dumpLog() {
        String logPath = null;
        File logFile = null;
        if (!this.consoleMode) {
            PrintWriter out;
            if (this.messages == null || this.messages.isEmpty()) {
                Message message = new Message("G0122E.SYSTEM_START_FAILED_COMMAND", this.command);
                this.logMessage(message.getFormattedTextWithDisplayKey());
            }
            try {
                File logDir = new File(this.config.getLogPath());
                if (!logDir.exists()) {
                    logDir.mkdir();
                }
                logPath = this.config.getLogPath() + File.separator + this.errorLog;
                logFile = new File(logPath);
                logFile.createNewFile();
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(logFile)), "UTF-8"));
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return;
            }
            this.buildPageHeader(out);
            Iterator<String> iterator = this.messages.iterator();
            try {
                while (iterator.hasNext()) {
                    String line = iterator.next();
                    if (!line.contains("IQQ") && !line.contains("Cause")) {
                        line = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + line;
                    }
                    out.println(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.buildPageTrailer(out);
            out.close();
            String path = "file://" + logPath;
            boolean success = this.launchWebBrowser(path);
            if (!success && this.launcherFrame != null) {
                try {
                    Message message = new Message("G0125E.SYSTEM_START_FAILED_LOG", logPath);
                    this.launcherFrame.showError(message.getFormattedTextWithDisplayKey());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private boolean launchWebBrowser(String location) {
        String linuxBrowser = null;
        String[] linuxBrowsers = new String[]{"firefox", "konqueror", "epiphany", "mozilla", "netscape", "opera"};
        if (this.os.contains("WINDOW")) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + location);
            }
            catch (Exception e) {
                return false;
            }
        }
        try {
            for (int i = 0; i < linuxBrowsers.length && linuxBrowser == null; ++i) {
                if (Runtime.getRuntime().exec(new String[]{"which", linuxBrowsers[i]}).waitFor() != 0) continue;
                linuxBrowser = linuxBrowsers[i];
            }
            if (linuxBrowser == null) {
                return false;
            }
            Runtime.getRuntime().exec(new String[]{linuxBrowser, location});
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPageHeader(PrintWriter out) {
        File headerTemplate = new File(this.config.getResourcePath() + File.separator + "images" + File.separator + "template_header.html");
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new FileReader(headerTemplate));
            while ((line = input.readLine()) != null) {
                out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPageTrailer(PrintWriter out) {
        File trailerTemplate = new File(this.config.getResourcePath() + File.separator + "images" + File.separator + "template_trailer.html");
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new FileReader(trailerTemplate));
            while ((line = input.readLine()) != null) {
                out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public LauncherFrame getLauncherFrame() {
        return this.launcherFrame;
    }

    public void setLauncherFrame(LauncherFrame launcherFrame) {
        this.launcherFrame = launcherFrame;
    }

    public boolean isConsoleMode() {
        return this.consoleMode;
    }

    public void setConsoleMode(boolean consoleMode) {
        this.consoleMode = consoleMode;
    }

    public GlobalConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(GlobalConfiguration config) {
        this.config = config;
    }
}

