/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.jvm;

import com.ibm.es.nuvo.jvm.JvmSupportInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;

public class IBMJvmSupport
implements JvmSupportInterface {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String CipherProvider = "IBMJCEFIPS";
    private static final String RandomAlgorithm = "IBMSecureRandom";
    private volatile boolean providerInserted = false;

    private synchronized void initializeEncryptionProvider() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (!this.providerInserted) {
            Class<?> providerClass = Class.forName("com.ibm.crypto.fips.provider.IBMJCEFIPS");
            Provider provider = (Provider)providerClass.newInstance();
            Security.insertProviderAt(provider, 1);
            this.providerInserted = true;
        }
    }

    public Cipher getCipherFor(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.initializeEncryptionProvider();
        Cipher cipher = Cipher.getInstance(algorithm, CipherProvider);
        return cipher;
    }

    public KeyGenerator getKeyGeneratorFor(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.initializeEncryptionProvider();
        KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm, CipherProvider);
        return keyGenerator;
    }

    public SecureRandom getSecureRandom() throws NoSuchAlgorithmException, NoSuchProviderException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        this.initializeEncryptionProvider();
        SecureRandom secureRandom = SecureRandom.getInstance(RandomAlgorithm, CipherProvider);
        return secureRandom;
    }

    public void takeHeapDump() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        System.gc();
        Method heapDump = null;
        Class<?> dumpClass = Class.forName("com.ibm.jvm.Dump");
        Class<?>[] classArgs = null;
        heapDump = dumpClass.getMethod("HeapDump", classArgs);
        Object[] args = null;
        heapDump.invoke(null, args);
    }
}

