/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.jaas;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.jaas.JaasConfiguration;
import com.ibm.es.nuvo.jaas.JaasConfigurationReader;
import com.ibm.es.nuvo.util.StringUtils;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyLoginModule
implements LoginModule {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String PROXY_APP_ENTRY = "com.ibm.es.nuvo.jaas.proxy.app.entry";
    public static final String PROXY_CONFIG_FILE = "com.ibm.es.nuvo.jaas.proxy.config.file";
    protected LoginModule module = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String appEntryName = (String)options.get(PROXY_APP_ENTRY);
        if (appEntryName == null) {
            throw new IllegalStateException("No JAAS application entry has been specified.  Please specify a JAAS aplication entry at key 'com.ibm.es.nuvo.jaas.proxy.app.entry.");
        }
        String configFileName = (String)options.get(PROXY_CONFIG_FILE);
        if (configFileName == null) {
            throw new IllegalStateException("No JAAS configuration file has been specified.  Please specify a JAAS configuration file at key 'com.ibm.es.nuvo.jaas.proxy.config.file.");
        }
        configFileName = StringUtils.replaceWhitneyHome(configFileName);
        JaasConfiguration config = null;
        try {
            config = JaasConfigurationReader.read(configFileName);
        }
        catch (ExtendedException ee) {
            throw new IllegalStateException("Unable to read specified JAAS configuration file.  Exception: " + ee);
        }
        AppConfigurationEntry[] appEntries = config.getAppConfigurationEntry(appEntryName);
        if (appEntries == null) {
            throw new IllegalStateException("Unable to locate JAAS application entry: " + appEntryName);
        }
        AppConfigurationEntry appEntry = appEntries[0];
        String className = appEntry.getLoginModuleName();
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Unable to find login module class " + className + ".  Exception: " + cnfe);
        }
        try {
            this.module = (LoginModule)clazz.newInstance();
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException("Unable to instantiate login module " + className + ".  Exception: " + ie);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException("Unable to access login module " + className + ".  Exception: " + iae);
        }
        this.module.initialize(subject, callbackHandler, sharedState, appEntry.getOptions());
    }

    @Override
    public boolean login() throws LoginException {
        return this.module.login();
    }

    @Override
    public boolean commit() throws LoginException {
        return this.module.commit();
    }

    @Override
    public boolean abort() throws LoginException {
        return this.module.abort();
    }

    @Override
    public boolean logout() throws LoginException {
        return this.module.logout();
    }
}

