/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.jaas;

import com.ibm.es.nuvo.authentication.AuthenticationManager;
import com.ibm.es.nuvo.authentication.AuthenticationModule;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.jaas.JaasConfiguration;
import com.ibm.es.nuvo.jaas.JaasPrincipal;
import com.ibm.es.nuvo.jaas.JaasRole;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.mortbay.jaas.callback.RequestParameterCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFileLoginModule
implements LoginModule {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String USER_REGISTRY_KEY = "userRegistry";
    public static final String DEFAULT_USER_REGISTRY = System.getProperty("whitney.home") + File.separator + "users.properties";
    protected String propertyFile;
    protected CallbackHandler callbackHandler;
    protected Subject subject;
    protected Map<String, ?> sharedState;
    protected Map<String, ?> options;
    protected Properties users;
    protected boolean authenticated;
    protected boolean committed;
    protected User currentUser;
    protected AuthenticationModule adminModule;

    @Override
    public void initialize(Subject subjectIn, CallbackHandler callbackHandlerIn, Map<String, ?> sharedStateIn, Map<String, ?> optionsIn) {
        this.subject = subjectIn;
        this.callbackHandler = callbackHandlerIn;
        this.sharedState = sharedStateIn;
        this.options = optionsIn;
        this.adminModule = AuthenticationManager.getInstance().getAdminModule();
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Unable to login the user because callback handler is null.");
        }
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Enter username: "), new PasswordCallback("Enter password: ", false)};
            this.callbackHandler.handle(callbacks);
            String givenUsername = ((NameCallback)callbacks[0]).getName();
            char[] givenPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (givenUsername == null || givenUsername.length() == 0) {
                throw new LoginException("Username may not be null.");
            }
            if (givenPassword == null || givenPassword.length == 0) {
                throw new LoginException("Password may not be null.");
            }
            String pwdStr = new String(givenPassword);
            try {
                this.authenticated = this.adminModule.validate(givenUsername, pwdStr);
            }
            catch (ExtendedException e) {
                this.saveValidationError(e);
                this.authenticated = false;
            }
            if (this.authenticated) {
                this.currentUser = new User(givenUsername, pwdStr);
            }
            return this.authenticated;
        }
        catch (Exception e) {
            LoginException toThrow = new LoginException(e.toString());
            Loggers.logger.log(new ExtendedException(e));
            throw toThrow;
        }
    }

    private void saveValidationError(ExtendedException e) throws IOException, UnsupportedCallbackException {
        Callback[] callbacks = new Callback[1];
        RequestParameterCallback requestCallB = new RequestParameterCallback();
        requestCallB.setParameterName("nuvo.j_session_id");
        callbacks[0] = requestCallB;
        this.callbackHandler.handle(callbacks);
        List sessionValues = requestCallB.getParameterValues();
        if (sessionValues.size() > 0) {
            String sessionId = sessionValues.get(0).toString();
            AuthenticationManager.getInstance().insertLastError(sessionId, e);
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.authenticated) {
            this.currentUser = null;
            this.committed = false;
            return false;
        }
        this.committed = true;
        this.subject.getPrincipals().add(this.currentUser.getJaasPrincipal());
        this.subject.getPrincipals().addAll(this.currentUser.getJaasRoles());
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.currentUser = null;
        this.adminModule = null;
        return this.authenticated && this.committed;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.currentUser.getJaasPrincipal());
        this.subject.getPrivateCredentials().remove(this.currentUser.getPassword());
        this.subject.getPrincipals().removeAll(this.currentUser.getJaasRoles());
        return true;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: <Username> <Password> <Properties file>");
        }
        String username = args[0];
        String password = args[1];
        String propertiesFile = args[2];
        UsernamePasswordHandler handler = new UsernamePasswordHandler(username, password);
        try {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put(USER_REGISTRY_KEY, propertiesFile);
            options.put("debug", Boolean.TRUE);
            AppConfigurationEntry propFileModule = new AppConfigurationEntry("com.ibm.es.nuvo.jaas.PropertyFileLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
            JaasConfiguration jaasConfig = new JaasConfiguration();
            jaasConfig.setAppConfigurationEntry("test", propFileModule);
            Configuration.setConfiguration(jaasConfig);
            LoginContext lc = new LoginContext("test", handler);
            lc.login();
            System.out.println("authentication successful");
            Subject subject = lc.getSubject();
            System.out.println("authenticated subject: " + subject);
            lc.logout();
        }
        catch (LoginException e) {
            System.out.println("authentication unsuccessful: " + e);
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class User {
        private String username;
        private JaasPrincipal jaasPrincipal;
        private String password;
        private List<String> roles;
        private List<JaasRole> jaasRoles;

        public User(String username, String password) {
            this(username, password, new ArrayList<String>());
        }

        public User(String username, String password, List<String> roles) {
            this.username = username;
            this.jaasPrincipal = new JaasPrincipal(this.username);
            this.password = password;
            this.roles = roles;
            this.jaasRoles = new ArrayList<JaasRole>();
            for (int i = 0; i < this.roles.size(); ++i) {
                this.jaasRoles.add(new JaasRole(this.roles.get(i)));
            }
        }

        public String getUsername() {
            return this.username;
        }

        public JaasPrincipal getJaasPrincipal() {
            return this.jaasPrincipal;
        }

        public String getPassword() {
            return this.password;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public List<JaasRole> getJaasRoles() {
            return this.jaasRoles;
        }
    }

    public static class UsernamePasswordHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        public UsernamePasswordHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public void handle(Callback[] callbacks) {
            ((NameCallback)callbacks[0]).setName(this.username);
            ((PasswordCallback)callbacks[1]).setPassword(this.password.toCharArray());
        }
    }
}

