/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.jaas;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.jaas.JaasApplicationEntry;
import com.ibm.es.nuvo.jaas.JaasConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaasConfigurationReader {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected StreamTokenizer st = null;
    protected int lookahead;
    protected int linenum;
    protected Map<String, List<AppConfigurationEntry>> configuration = null;

    public JaasConfigurationReader(String filename) throws ExtendedException {
        try {
            this.parse(new FileInputStream(new File(filename)));
        }
        catch (FileNotFoundException fnfe) {
            Message msg = new Message("todo");
            throw new ExtendedException(msg, (Throwable)fnfe);
        }
    }

    public JaasConfigurationReader(InputStream is) throws ExtendedException {
        this.parse(is);
    }

    public JaasConfiguration getConfiguration() {
        return new JaasConfiguration(this.configuration);
    }

    protected void parse(InputStream is) throws ExtendedException {
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        this.st = new StreamTokenizer(r);
        this.st.quoteChar(34);
        this.st.wordChars(36, 36);
        this.st.wordChars(95, 95);
        this.st.wordChars(45, 45);
        this.st.lowerCaseMode(false);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.eolIsSignificant(true);
        HashMap<String, List<AppConfigurationEntry>> hashmap = new HashMap<String, List<AppConfigurationEntry>>();
        try {
            this.lookahead = this.nextToken();
            while (this.lookahead != -1) {
                this.parseLoginEntry(hashmap);
            }
        }
        catch (IOException ioe) {
            Message msg = new Message("todo");
            throw new ExtendedException(msg, (Throwable)ioe);
        }
        this.configuration = hashmap;
    }

    protected void parseLoginEntry(Map<String, List<AppConfigurationEntry>> hashmap) throws IOException {
        LinkedList<JaasApplicationEntry> linkedlist = new LinkedList<JaasApplicationEntry>();
        String s = this.st.sval;
        this.lookahead = this.nextToken();
        this.match("{");
        while (!this.peek("}")) {
            AppConfigurationEntry.LoginModuleControlFlag loginmodulecontrolflag;
            String s1 = this.match("module class name");
            String s2 = this.match("controlFlag");
            if (s2.equalsIgnoreCase("REQUIRED")) {
                loginmodulecontrolflag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if (s2.equalsIgnoreCase("REQUISITE")) {
                loginmodulecontrolflag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if (s2.equalsIgnoreCase("SUFFICIENT")) {
                loginmodulecontrolflag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if (s2.equalsIgnoreCase("OPTIONAL")) {
                loginmodulecontrolflag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            } else {
                throw new IOException("Configuration Error:\n\tInvalid control flag");
            }
            HashMap<String, String> hashmap1 = new HashMap<String, String>();
            while (!this.peek(";")) {
                String s3 = this.match("option key");
                this.match("=");
                String s5 = this.match("option value");
                hashmap1.put(s3, s5);
            }
            this.lookahead = this.nextToken();
            JaasApplicationEntry appEntry = new JaasApplicationEntry(s1, loginmodulecontrolflag, hashmap1);
            linkedlist.add(appEntry);
        }
        this.match("}");
        this.match(";");
        if (hashmap.containsKey(s)) {
            throw new IOException("Configuration Error:\n\tCan not specify multiple entries for appName");
        }
        hashmap.put(s, linkedlist);
    }

    protected String match(String s) throws IOException {
        String s1 = null;
        switch (this.lookahead) {
            case -1: {
                throw new IOException("Configuration Error:\n\texpected [expect], read [end of file]");
            }
            case -3: 
            case 34: {
                if (s.equalsIgnoreCase("module class name") || s.equalsIgnoreCase("controlFlag") || s.equalsIgnoreCase("option key") || s.equalsIgnoreCase("option value")) {
                    s1 = this.st.sval;
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException("Configuration Error:\n\tLine line: expected [expect], found [value]");
            }
            case 123: {
                if (s.equalsIgnoreCase("{")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException("Configuration Error:\n\tLine line: expected [expect], found [value]");
            }
            case 59: {
                if (s.equalsIgnoreCase(";")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException("Configuration Error:\n\tLine line: expected [expect], found [value]");
            }
            case 125: {
                if (s.equalsIgnoreCase("}")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException("Configuration Error:\n\tLine line: expected [expect], found [value]");
            }
            case 61: {
                if (s.equalsIgnoreCase("=")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException("Configuration Error:\n\tLine line: expected [expect], found [value]");
            }
            default: {
                throw new IOException("Configuration Error:\n\tLine line: expected [expect], found [value]");
            }
        }
        return s1;
    }

    protected boolean peek(String s) {
        boolean flag = false;
        switch (this.lookahead) {
            default: {
                break;
            }
            case 44: {
                if (!s.equalsIgnoreCase(",")) break;
                flag = true;
                break;
            }
            case 59: {
                if (!s.equalsIgnoreCase(";")) break;
                flag = true;
                break;
            }
            case 123: {
                if (!s.equalsIgnoreCase("{")) break;
                flag = true;
                break;
            }
            case 125: {
                if (!s.equalsIgnoreCase("}")) break;
                flag = true;
            }
        }
        return flag;
    }

    protected int nextToken() throws IOException {
        int i;
        while ((i = this.st.nextToken()) == 10) {
            ++this.linenum;
        }
        return i;
    }

    public static JaasConfiguration read(String filename) throws ExtendedException {
        JaasConfigurationReader reader = new JaasConfigurationReader(filename);
        return reader.getConfiguration();
    }

    public static JaasConfiguration read(InputStream is) throws ExtendedException {
        JaasConfigurationReader reader = new JaasConfigurationReader(is);
        return reader.getConfiguration();
    }

    public static void main(String[] args) {
        String filename = args[0];
        try {
            JaasConfiguration config = JaasConfigurationReader.read(filename);
            System.out.println(config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

