/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.jaas;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaasConfiguration
extends Configuration {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String APP_ENTRY = "com.ibm.es.nuvo.jaas.app.entry";
    protected Map<String, List<AppConfigurationEntry>> configuration = new HashMap<String, List<AppConfigurationEntry>>();

    public JaasConfiguration() {
    }

    public JaasConfiguration(Map<String, List<AppConfigurationEntry>> configuration) {
        this.configuration.putAll(configuration);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
        List<AppConfigurationEntry> entries = this.configuration.get(applicationName);
        return entries.toArray(new AppConfigurationEntry[entries.size()]);
    }

    public void setAppConfigurationEntry(String applicationName, AppConfigurationEntry entry) {
        AppConfigurationEntry[] entries = new AppConfigurationEntry[]{entry};
        this.configuration.put(applicationName, Arrays.asList(entries));
    }

    public void setAppConfigurationEntries(String applicationName, AppConfigurationEntry[] entries) {
        this.configuration.put(applicationName, Arrays.asList(entries));
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, List<AppConfigurationEntry>> entry : this.configuration.entrySet()) {
            String appName = entry.getKey();
            sb.append("Application Name: ");
            sb.append(appName);
            sb.append("\n");
            List<AppConfigurationEntry> value = entry.getValue();
            for (int i = 0; i < value.size(); ++i) {
                sb.append("\tLogin module ");
                sb.append(i);
                sb.append(": ");
                sb.append(value.get(i));
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

