/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.jaas;

import com.ibm.es.nuvo.authentication.AuthenticationManager;
import com.ibm.es.nuvo.authentication.AuthenticationModule;
import com.ibm.es.nuvo.jaas.JaasPrincipal;
import com.ibm.es.nuvo.jaas.JaasRole;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiAuthMgrLoginModule
implements LoginModule {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String USER_REGISTRY_KEY = "userRegistry";
    public static final String DEFAULT_USER_REGISTRY = System.getProperty("whitney.home") + File.separator + "users.properties";
    protected String propertyFile;
    protected CallbackHandler callbackHandler;
    protected Subject subject;
    protected Map<String, ?> sharedState;
    protected Map<String, ?> options;
    protected Properties users;
    protected boolean authenticated;
    protected boolean committed;
    protected User currentUser;
    protected AuthenticationModule apiModule = null;

    @Override
    public void initialize(Subject subjectIn, CallbackHandler callbackHandlerIn, Map<String, ?> sharedStateIn, Map<String, ?> optionsIn) {
        this.subject = subjectIn;
        this.callbackHandler = callbackHandlerIn;
        this.sharedState = sharedStateIn;
        this.options = optionsIn;
        this.apiModule = AuthenticationManager.getInstance().getApiModule();
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Unable to login the user because callback handler is null.");
        }
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Enter username: "), new PasswordCallback("Enter password: ", false)};
            this.callbackHandler.handle(callbacks);
            String givenUsername = this.apiModule.getDefaultUserId();
            char[] givenPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (givenUsername == null || givenUsername.length() == 0) {
                throw new LoginException("Username may not be null.");
            }
            if (givenPassword == null || givenPassword.length == 0) {
                throw new LoginException("Password may not be null.");
            }
            String pwdStr = new String(givenPassword);
            this.authenticated = this.apiModule.validate(givenUsername, pwdStr);
            if (!this.authenticated) {
                givenUsername = ((NameCallback)callbacks[0]).getName();
                AuthenticationModule adminModule = AuthenticationManager.getInstance().getAdminModule();
                this.authenticated = adminModule.validate(givenUsername, pwdStr);
            }
            if (this.authenticated) {
                this.currentUser = new User(givenUsername, pwdStr);
            }
            return this.authenticated;
        }
        catch (Exception e) {
            throw new LoginException("Unable to login the user.  Exception: " + e);
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.authenticated) {
            this.currentUser = null;
            this.committed = false;
            return false;
        }
        this.committed = true;
        this.subject.getPrincipals().add(this.currentUser.getJaasPrincipal());
        this.subject.getPrincipals().addAll(this.currentUser.getJaasRoles());
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.currentUser = null;
        this.apiModule = null;
        return this.authenticated && this.committed;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.currentUser.getJaasPrincipal());
        this.subject.getPrivateCredentials().remove(this.currentUser.getPassword());
        this.subject.getPrincipals().removeAll(this.currentUser.getJaasRoles());
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class User {
        private String username;
        private JaasPrincipal jaasPrincipal;
        private String password;
        private List<String> roles;
        private List<JaasRole> jaasRoles;

        public User(String username, String password) {
            this(username, password, new ArrayList<String>());
        }

        public User(String username, String password, List<String> roles) {
            this.username = username;
            this.jaasPrincipal = new JaasPrincipal(this.username);
            this.password = password;
            this.roles = roles;
            this.jaasRoles = new ArrayList<JaasRole>();
            for (int i = 0; i < this.roles.size(); ++i) {
                this.jaasRoles.add(new JaasRole(this.roles.get(i)));
            }
        }

        public String getUsername() {
            return this.username;
        }

        public JaasPrincipal getJaasPrincipal() {
            return this.jaasPrincipal;
        }

        public String getPassword() {
            return this.password;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public List<JaasRole> getJaasRoles() {
            return this.jaasRoles;
        }
    }

    public static class UsernamePasswordHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        public UsernamePasswordHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public void handle(Callback[] callbacks) {
            ((NameCallback)callbacks[0]).setName(this.username);
            ((PasswordCallback)callbacks[1]).setPassword(this.password.toCharArray());
        }
    }
}

