/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.util;

import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoTracer;

public class StatusStructure {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = StatusStructure.class.getName();
    private StatusCode status;
    private InyoException ex;
    private String message;

    public StatusStructure(StatusCode code) {
        InyoTracer.entering(sourceClass, "StatusStructure");
        this.status = code;
        InyoTracer.exiting(sourceClass, "StatusStructure");
    }

    public StatusStructure(StatusCode code, String message) {
        InyoTracer.entering(sourceClass, "StatusStructure");
        this.status = code;
        this.message = message;
        InyoTracer.exiting(sourceClass, "StatusStructure");
    }

    public int getStatus() {
        InyoTracer.entering(sourceClass, "getStatus");
        if (this.status == StatusCode.DONE) {
            return 1;
        }
        if (this.status == StatusCode.WORKING) {
            return 5;
        }
        if (this.status == StatusCode.DONEWITHMESSAGE) {
            return 7;
        }
        if (this.status == StatusCode.TRACEON) {
            return 2;
        }
        if (this.status == StatusCode.TRACEOFF) {
            return 3;
        }
        return 6;
    }

    public String getStatusMessage() {
        InyoTracer.entering(sourceClass, "getStatusMessage");
        return this.message;
    }

    public void setError(InyoException e) {
        InyoTracer.entering(sourceClass, "setError");
        this.ex = e;
    }

    public InyoException getError() {
        InyoTracer.entering(sourceClass, "getError");
        return this.ex;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusCode {
        DONE,
        WORKING,
        FAILED,
        DONEWITHMESSAGE,
        TRACEON,
        TRACEOFF;

    }
}

