/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.util;

import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import java.io.File;
import java.util.Locale;

public class InyoUtil {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = InyoUtil.class.getName();

    public static String getCollectionConfigPath(String colID) {
        InyoTracer.entering(sourceClass, "getCollectionConfigPath");
        String pathName = GlobalConfiguration.getConfiguration().getCollectionPath();
        if (!pathName.endsWith(File.separator)) {
            pathName = pathName + File.separator;
        }
        pathName = pathName + colID;
        InyoTracer.exiting(sourceClass, "getCollectionConfigPath");
        return pathName;
    }

    public static String getCollectionDataDirPath(String colID) {
        InyoTracer.entering(sourceClass, "getCollectionDataDirPath");
        String pathName = GlobalConfiguration.getConfiguration().getCollectionPath();
        if (!pathName.endsWith(File.separator)) {
            pathName = pathName + File.separator;
        }
        pathName = pathName + colID + File.separator + "data";
        InyoTracer.exiting(sourceClass, "getCollectionDataDirPath");
        return pathName;
    }

    public static String getCollectionVersionInfoFile(String colID) {
        InyoTracer.entering(sourceClass, "getCollectionVersionInfoFile");
        String pathName = InyoUtil.getCollectionDataDirPath(colID);
        if (!pathName.endsWith(File.separator)) {
            pathName = pathName + File.separator;
        }
        pathName = pathName + "version.info";
        InyoTracer.exiting(sourceClass, "getCollectionVersionInfoFile");
        return pathName;
    }

    public static String getCollectionBackupStateFile(String colID) {
        InyoTracer.entering(sourceClass, "getCollectionBackupStateFile");
        String pathName = InyoUtil.getCollectionDataDirPath(colID);
        if (!pathName.endsWith(File.separator)) {
            pathName = pathName + File.separator;
        }
        pathName = pathName + "backup.list";
        InyoTracer.exiting(sourceClass, "getCollectionBackupStateFile");
        return pathName;
    }

    public static String getCollectionIndexDirPath(String colID) {
        InyoTracer.entering(sourceClass, "getCollectionIndexDirPath");
        return InyoUtil.getCollectionDataDirPath(colID) + File.separator + File.separator + "text";
    }

    public static String getCollectionSynonymDirPath(String colID) {
        InyoTracer.entering(sourceClass, "getCollectionSynonymDirPath");
        return InyoUtil.getCollectionDataDirPath(colID) + File.separator + File.separator + "synonym";
    }

    public static Locale getLocale(String localeString) {
        InyoTracer.entering(sourceClass, "getLocale");
        String lang = localeString.substring(0, 2);
        String country = localeString.substring(3, 5);
        InyoTracer.exiting(sourceClass, "getLocale");
        return new Locale(lang, country);
    }

    public static boolean checkDebugOn() {
        InyoTracer.entering(sourceClass, "checkDebugOn");
        String val = null;
        boolean retVal = false;
        val = System.getProperty("debug");
        if (val != null && val.equalsIgnoreCase("true")) {
            retVal = true;
        }
        InyoTracer.exiting(sourceClass, "checkDebugOn");
        return retVal;
    }

    public static boolean checkProfileOn() {
        InyoTracer.entering(sourceClass, "checkProfileOn");
        String val = null;
        boolean retVal = false;
        val = System.getProperty("profile");
        if (val != null && val.equalsIgnoreCase("true")) {
            retVal = true;
        }
        InyoTracer.exiting(sourceClass, "checkProfileOn");
        return retVal;
    }
}

