/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.util;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.documentqueue.DocumentImpl;
import com.ibm.es.nuvo.indexer.IndexFactoryImpl;
import com.ibm.es.nuvo.inyo.util.InyoConstants;
import com.ibm.es.nuvo.inyo.util.InyoDocument;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.util.Base64;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.index.IndexFactory;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class InyoStreamUtil
implements InyoConstants {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = InyoStreamUtil.class.getName();
    private static IndexFactory indexFactory = new IndexFactoryImpl();
    protected static final int FLAG_HAS_ATTRIBUTES = Integer.MIN_VALUE;
    protected static final String PARAM_DATA = "data";
    protected static final int VALUE_TYPE_NUMBER = 0;
    protected static final int VALUE_TYPE_STRING = 1;
    protected static final int VALUE_TYPE_BINARY = 2;

    public static InyoDocument getDocument(DataInputStream din) throws InyoException {
        InyoTracer.entering(sourceClass, "getDocument");
        try {
            String documentURI = null;
            Object documentType = null;
            String uriPayload = null;
            Metadata metadata = new Metadata();
            ByteArrayInputStream documentInputStream = null;
            Hashtable<String, String> documentProperties = new Hashtable<String, String>();
            int header = din.readInt();
            int recordLength = din.readInt();
            if (recordLength <= 0) {
                return null;
            }
            int curLength = 0;
            while (curLength < recordLength) {
                int curRead;
                int curRead2;
                int keyspec = din.readInt();
                boolean hasAttributes = (keyspec & Integer.MIN_VALUE) == Integer.MIN_VALUE;
                int keylen = keyspec & 0x3FFFFFFF;
                curLength += 4;
                if (keylen < 0) {
                    throw new InyoException(new IOException("Invalid keylen in deserialize(): " + keylen));
                }
                byte[] keybytes = new byte[keylen];
                int offset = 0;
                int bytesToRead = keylen;
                while ((curRead2 = din.read(keybytes, offset, bytesToRead)) >= 0) {
                    offset += curRead2;
                    if ((bytesToRead -= curRead2) > 0) continue;
                }
                if (bytesToRead > 0) {
                    throw new InyoException(new IOException("Incomplete read in deserialize()"));
                }
                curLength += keylen;
                String key = new String(keybytes);
                int valspec = din.readInt();
                int valtype = valspec >> 30 & 3;
                int vallen = valspec & 0x3FFFFFFF;
                curLength += 4;
                if (vallen < 0) {
                    throw new InyoException(new IOException("Invalid vallen in deserialize(): " + vallen));
                }
                byte[] valbytes = new byte[vallen];
                int offset2 = 0;
                int bytesToRead2 = vallen;
                while ((curRead = din.read(valbytes, offset2, bytesToRead2)) >= 0) {
                    offset2 += curRead;
                    if ((bytesToRead2 -= curRead) > 0) continue;
                }
                if (bytesToRead2 > 0) {
                    throw new InyoException(new IOException("Incomplete read in deserialize()"));
                }
                curLength += vallen;
                int attributes = 0;
                if (hasAttributes) {
                    attributes = din.readInt();
                    curLength += 4;
                }
                if (key.equals("docId")) {
                    documentURI = new String(valbytes);
                    continue;
                }
                if (key.equals("rowId")) {
                    uriPayload = Base64.encode(valbytes);
                    continue;
                }
                if (key.equals(PARAM_DATA)) {
                    documentInputStream = new ByteArrayInputStream(valbytes);
                    continue;
                }
                documentProperties.put(key, new String(valbytes));
            }
            DocumentImpl doc = (DocumentImpl)indexFactory.createDocument(documentURI, documentInputStream, "", "");
            Enumeration docKeys = documentProperties.keys();
            while (docKeys.hasMoreElements()) {
                String docKey = (String)docKeys.nextElement();
                metadata.add(docKey, (String)documentProperties.get(docKey));
            }
            metadata.set("_binary_key", uriPayload);
            doc.setMetadata(metadata);
            doc.setCaching(false);
            InyoDocument myDoc = new InyoDocument(doc);
            InyoTracer.exiting(sourceClass, "getDocument");
            return myDoc;
        }
        catch (IOException ioe) {
            throw new InyoException(ioe);
        }
        catch (SiapiException se) {
            throw new InyoException(se);
        }
        catch (Exception e) {
            System.err.println("Other exception occurred!");
            e.printStackTrace();
            throw new InyoException(e);
        }
    }
}

