/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.util;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.inyo.util.DocParseResult;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoResult;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.inyo.util.StatusStructure;
import com.ibm.es.nuvo.search.ResultImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InyoSocketUtil {
    private static final String sourceClass = InyoSocketUtil.class.getName();
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static int MAX_HEADER_LEN = 65536;
    private static final short BASE_RECORD_LENGTH;
    private static final short PARSE_RECORD_LENGTH_NO_MESG;
    private static final short PARSE_RECORD_LENGTH_WITH_MESG;
    private static final String KEY_MSGID;
    private static final String KEY_MSGTEXT;
    private static final String KEY_DOCUMENT_ID;

    /*
     * Exception decompiling
     */
    public static int getHeaders(DataInputStream in, Hashtable<String, String> params) throws InyoException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 5[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void blockRead(InputStream in, byte[] b, int len) throws IOException {
        InyoTracer.entering(sourceClass, "blockRead");
        int j = len;
        for (int i = 0; i < len; i += in.read(b, i, j)) {
            j = len - i;
        }
        InyoTracer.exiting(sourceClass, "blockRead");
    }

    public static void dump(byte[] b) {
        InyoTracer.entering(sourceClass, "dump");
        try {
            System.err.println(new String(b, "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InyoTracer.exiting(sourceClass, "dump");
    }

    public static void sendResponse(int status, DataOutputStream dout) throws InyoException {
        InyoTracer.entering(sourceClass, "sendResponse");
        try {
            dout.writeShort(status);
            dout.flush();
        }
        catch (IOException e) {
            throw new InyoException(e);
        }
        InyoTracer.exiting(sourceClass, "sendResponse");
    }

    public static void sendResponse(DataOutputStream dout) throws InyoException {
        InyoTracer.entering(sourceClass, "sendResponse");
        try {
            int status = 1;
            dout.writeShort(status);
            dout.flush();
        }
        catch (IOException e) {
            throw new InyoException(new Message("D0028E.UNSUPORTED_ACTION"), (Throwable)e);
        }
        InyoTracer.exiting(sourceClass, "sendResponse");
    }

    public static void sendResponse(DataOutputStream dout, StatusStructure stats) throws InyoException {
        InyoTracer.entering(sourceClass, "sendResponse");
        int status = stats.getStatus();
        try {
            dout.writeShort(status);
            if (status == 6) {
                InyoException ex = stats.getError();
                if (ex != null) {
                    String key = ex.getNonLocalizedMessage().getDisplayKey();
                    String val = ex.getFormattedText(ex.getLocale());
                    short envLen = (short)(BASE_RECORD_LENGTH + key.length() + val.length());
                    dout.writeShort(envLen);
                    InyoSocketUtil.writeString(dout, KEY_MSGID);
                    InyoSocketUtil.writeString(dout, key);
                    InyoSocketUtil.writeString(dout, KEY_MSGTEXT);
                    InyoSocketUtil.writeString(dout, val);
                }
            } else if (status == 7) {
                InyoSocketUtil.writeString(dout, stats.getStatusMessage());
            }
            dout.flush();
        }
        catch (IOException e) {
            throw new InyoException(new Message("D0028E.UNSUPORTED_ACTION"), (Throwable)e);
        }
        InyoTracer.exiting(sourceClass, "sendResponse");
    }

    public static void sendResponse(DataOutputStream dout, InyoException ex) throws InyoException {
        InyoTracer.entering(sourceClass, "sendResponse");
        int status = 6;
        try {
            dout.writeShort(status);
            String key = ex.getNonLocalizedMessage().getDisplayKey();
            String val = ex.getFormattedText(ex.getLocale());
            short envLen = (short)(BASE_RECORD_LENGTH + key.length() + val.length());
            dout.writeShort(envLen);
            InyoSocketUtil.writeString(dout, KEY_MSGID);
            InyoSocketUtil.writeString(dout, key);
            InyoSocketUtil.writeString(dout, KEY_MSGTEXT);
            InyoSocketUtil.writeString(dout, val);
            dout.flush();
        }
        catch (IOException e) {
            throw new InyoException(new Message("D0028E.UNSUPORTED_ACTION"), (Throwable)e);
        }
        InyoTracer.exiting(sourceClass, "sendResponse");
    }

    private static void writeString(DataOutputStream dout, String s) throws IOException {
        InyoTracer.entering(sourceClass, "writeString");
        try {
            byte[] buf = s.getBytes("UTF-8");
            dout.writeShort(buf.length);
            dout.write(buf);
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException();
        }
        InyoTracer.exiting(sourceClass, "writeString");
    }

    private static int sendErrParseResponse(DataOutputStream dout, DocParseResult pr) throws InyoException {
        InyoTracer.entering(sourceClass, "sendErrParseResponse");
        int wrote = 0;
        int status = 6;
        try {
            dout.writeShort(status);
            wrote += 2;
            String doc = pr.getDocID();
            String key = pr.getMessageID();
            String val = pr.getMessageText();
            short envLen = (short)(PARSE_RECORD_LENGTH_WITH_MESG + doc.length() + key.length() + val.length());
            dout.writeShort(envLen);
            wrote += 2;
            InyoSocketUtil.writeString(dout, KEY_DOCUMENT_ID);
            InyoSocketUtil.writeString(dout, doc);
            InyoSocketUtil.writeString(dout, KEY_MSGID);
            InyoSocketUtil.writeString(dout, key);
            InyoSocketUtil.writeString(dout, KEY_MSGTEXT);
            InyoSocketUtil.writeString(dout, val);
            InyoTracer.exiting(sourceClass, "sendErrParseResponse");
            return wrote += envLen;
        }
        catch (IOException e) {
            throw new InyoException(e);
        }
    }

    public static int sendResponse(DataOutputStream dout, DocParseResult pr) throws InyoException {
        InyoTracer.entering(sourceClass, "sendResponse");
        if (pr.hasErrorMesg()) {
            return InyoSocketUtil.sendErrParseResponse(dout, pr);
        }
        int wrote = 0;
        int status = 5;
        try {
            dout.writeShort(status);
            wrote += 2;
            String val = pr.getDocID();
            short envLen = (short)(PARSE_RECORD_LENGTH_NO_MESG + val.length());
            dout.writeShort(envLen);
            wrote += 2;
            InyoSocketUtil.writeString(dout, KEY_DOCUMENT_ID);
            InyoSocketUtil.writeString(dout, val);
            InyoTracer.exiting(sourceClass, "sendResponse");
            return wrote += envLen;
        }
        catch (IOException e) {
            throw new InyoException(new Message("D0028E.UNSUPORTED_ACTION"), (Throwable)e);
        }
    }

    public static int sendResult(DataOutputStream dout, ResultImpl res, boolean score) throws InyoException {
        InyoTracer.entering(sourceClass, "sendResult");
        int wrote = 0;
        int status = 1;
        if (score) {
            status = 5;
        }
        try {
            dout.writeShort(status);
            wrote += 2;
            String val = res.getDocumentURI();
            byte[] buf = val.getBytes("UTF-8");
            int envLen = buf.length;
            if (score) {
                envLen += 2;
            }
            dout.writeShort(envLen);
            wrote += 2;
            if (score) {
                dout.writeShort(1000);
            }
            dout.write(buf);
            InyoTracer.exiting(sourceClass, "sendResult");
            return wrote += envLen;
        }
        catch (IOException e) {
            throw new InyoException(new Message("D0028E.UNSUPORTED_ACTION"), (Throwable)e);
        }
    }

    public static int write(DataOutputStream dout, InyoResult res) throws InyoException {
        InyoTracer.entering(sourceClass, "write");
        try {
            dout.write(res.getResult(), 0, res.getResultLen());
        }
        catch (IOException e) {
            throw new InyoException(e);
        }
        InyoTracer.exiting(sourceClass, "write");
        return res.getResultLen();
    }

    public static int write(DataOutputStream dout, byte[] buf, int len) throws InyoException {
        InyoTracer.entering(sourceClass, "write");
        try {
            dout.write(buf, 0, len);
        }
        catch (IOException e) {
            throw new InyoException(new Message("D0028E.UNSUPORTED_ACTION"), (Throwable)e);
        }
        InyoTracer.exiting(sourceClass, "write");
        return len;
    }

    public static void sendPayLoad(DataOutputStream dout, byte[] buf, int len) throws InyoException {
        InyoTracer.entering(sourceClass, "sendPayLoad");
        int status = 7;
        try {
            dout.writeShort(status);
            dout.writeShort(len);
            dout.write(buf, 0, len);
            dout.flush();
        }
        catch (IOException e) {
            throw new InyoException(new Message("D0028E.UNSUPORTED_ACTION"), (Throwable)e);
        }
        InyoTracer.exiting(sourceClass, "sendPayLoad");
    }

    public static void sendTerminator(DataOutputStream dout) throws InyoException {
        InyoTracer.entering(sourceClass, "sendTerminator");
        try {
            int status = 1;
            dout.writeShort(status);
            status = 0;
            dout.writeShort(status);
            dout.flush();
        }
        catch (IOException e) {
            throw new InyoException(new Message("D0028E.UNSUPORTED_ACTION"), (Throwable)e);
        }
        InyoTracer.exiting(sourceClass, "sendTerminator");
    }

    public static void main(String[] args) {
        try {
            String test = "name:pradhan\n job:engineer\n company:ibm\n ";
            byte[] b = test.getBytes();
            int len = b.length;
            System.err.println(len);
            ByteArrayOutputStream barr = new ByteArrayOutputStream(4096);
            DataOutputStream dout = new DataOutputStream(barr);
            dout.writeInt(len);
            dout.write(b);
            byte[] buf = barr.toByteArray();
            InyoSocketUtil.dump(buf);
            ByteArrayInputStream bin = new ByteArrayInputStream(buf);
            DataInputStream din = new DataInputStream(bin);
            Hashtable<String, String> headers = new Hashtable<String, String>(10);
            int ret = InyoSocketUtil.getHeaders(din, headers);
            Enumeration<String> paramsEnum = headers.keys();
            while (paramsEnum.hasMoreElements()) {
                String name = paramsEnum.nextElement();
                System.err.println(name + ":" + headers.get(name));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        KEY_MSGID = "MsgId";
        KEY_MSGTEXT = "MsgText";
        KEY_DOCUMENT_ID = "Doc";
        BASE_RECORD_LENGTH = (short)(2 + KEY_MSGID.length() + 2 + 2 + KEY_MSGTEXT.length() + 2);
        PARSE_RECORD_LENGTH_NO_MESG = (short)(2 + KEY_DOCUMENT_ID.length() + 2);
        PARSE_RECORD_LENGTH_WITH_MESG = (short)(BASE_RECORD_LENGTH + PARSE_RECORD_LENGTH_NO_MESG);
    }
}

