/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.util;

import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoResult;
import com.ibm.es.nuvo.inyo.util.InyoSocketUtil;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.inyo.util.SelectivityInfo;
import com.ibm.es.nuvo.inyo.util.StatusStructure;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.search.ResultImpl;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;

public class InyoResultsWriter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = InyoResultsWriter.class.getName();
    private DataOutputStream out;
    private boolean toWriteHeader;
    private boolean err;
    private boolean toWriteScore;
    private boolean profile;
    private boolean debug;
    private long expired;
    private int written;
    private InyoResult result;

    public InyoResultsWriter(DataOutputStream out) {
        InyoTracer.entering(sourceClass, "InyoResultsWriter");
        this.out = out;
        this.toWriteHeader = true;
        this.err = false;
        this.toWriteScore = false;
        this.expired = 0L;
        this.written = 4;
        this.result = new InyoResult();
        InyoTracer.exiting(sourceClass, "InyoResultsWriter");
    }

    public void setProfileState(boolean val) {
        InyoTracer.entering(sourceClass, "setProfileState");
        this.profile = val;
        InyoTracer.exiting(sourceClass, "setProfileState");
    }

    public void setDebugState(boolean val) {
        InyoTracer.entering(sourceClass, "setDebugState");
        this.debug = val;
        InyoTracer.exiting(sourceClass, "setDebugState");
    }

    public long getProfileInfo() {
        InyoTracer.entering(sourceClass, "getProfileInfo");
        return this.expired;
    }

    public boolean write(byte[] buff, int len, short score) {
        InyoTracer.entering(sourceClass, "write");
        long t0 = 0L;
        if (this.profile) {
            t0 = System.currentTimeMillis();
        }
        if (this.err) {
            return false;
        }
        boolean status = true;
        try {
            if (this.toWriteHeader) {
                this.writeHeader();
            }
            this.result.buildResultEnvelope(buff, len, score);
            this.written += InyoSocketUtil.write(this.out, this.result);
            if (this.written > 1024) {
                this.out.flush();
                this.written = 0;
            }
        }
        catch (InyoException ex) {
            this.handleError(ex);
            status = false;
        }
        catch (IOException ex) {
            this.handleError(new InyoException(ex));
            status = false;
        }
        if (this.profile) {
            this.expired += System.currentTimeMillis() - t0;
        }
        InyoTracer.exiting(sourceClass, "write");
        return status;
    }

    public boolean write(ResultImpl result) {
        InyoTracer.entering(sourceClass, "write");
        long t0 = 0L;
        if (this.profile) {
            t0 = System.currentTimeMillis();
        }
        if (this.err) {
            return false;
        }
        boolean status = true;
        try {
            if (this.toWriteHeader) {
                this.writeHeader();
            }
            this.written += InyoSocketUtil.sendResult(this.out, result, this.toWriteScore);
            if (this.written > 1024) {
                this.out.flush();
                this.written = 0;
            }
        }
        catch (InyoException ex) {
            this.handleError(ex);
            status = false;
        }
        catch (IOException ex) {
            this.handleError(new InyoException(ex));
            status = false;
        }
        if (this.profile) {
            this.expired += System.currentTimeMillis() - t0;
        }
        InyoTracer.exiting(sourceClass, "write");
        return status;
    }

    public boolean write(SelectivityInfo selectivity) {
        InyoTracer.entering(sourceClass, "write");
        if (this.err) {
            return false;
        }
        boolean status = true;
        try {
            if (this.toWriteHeader) {
                this.writeHeader();
            }
            this.result.buildSelectivityEnvelope(selectivity);
            this.written += InyoSocketUtil.write(this.out, this.result);
        }
        catch (InyoException ex) {
            this.handleError(ex);
            status = false;
        }
        InyoTracer.exiting(sourceClass, "write");
        return status;
    }

    public boolean write(StatusStructure result) {
        InyoTracer.entering(sourceClass, "write");
        if (this.err) {
            return false;
        }
        boolean status = true;
        try {
            if (this.toWriteHeader) {
                this.writeHeader();
            }
        }
        catch (InyoException ex) {
            this.handleError(ex);
            status = false;
        }
        InyoTracer.exiting(sourceClass, "write");
        return status;
    }

    public void write(Exception ex) {
        InyoTracer.entering(sourceClass, "write");
        if (this.err) {
            return;
        }
        try {
            InyoSocketUtil.sendResponse(this.out, new InyoException(ex));
        }
        catch (InyoException e) {
            this.handleError(e);
        }
        InyoTracer.exiting(sourceClass, "write");
    }

    public void flush() {
        InyoTracer.entering(sourceClass, "flush");
        if (this.err) {
            return;
        }
        try {
            if (this.toWriteHeader) {
                this.writeHeader();
            }
            InyoSocketUtil.sendTerminator(this.out);
        }
        catch (InyoException ex) {
            this.handleError(ex);
        }
        InyoTracer.exiting(sourceClass, "flush");
    }

    public void writeScore(boolean val) {
        InyoTracer.entering(sourceClass, "writeScore");
        this.toWriteScore = val;
    }

    private void writeHeader() throws InyoException {
        InyoTracer.entering(sourceClass, "writeHeader");
        InyoSocketUtil.sendResponse(this.out);
        this.toWriteHeader = false;
        InyoTracer.exiting(sourceClass, "writeHeader");
    }

    private void handleError(InyoException ex) {
        InyoTracer.entering(sourceClass, "handleError");
        this.err = true;
        if (Loggers.logger.isLoggable(Level.SEVERE)) {
            Loggers.logger.log(Level.SEVERE, ex);
        }
        InyoTracer.exiting(sourceClass, "handleError");
    }
}

