/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.util;

import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.inyo.util.SelectivityInfo;
import java.io.UnsupportedEncodingException;

public class InyoResult {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = InyoResult.class.getName();
    private String docId;
    private static final short intialSize = 256;
    private int resEnvSize;
    private int length;
    private byte[] resEnvelope;

    public InyoResult() {
        InyoTracer.entering(sourceClass, "InyoResult");
        this.resEnvelope = new byte[256];
        this.resEnvSize = 256;
        InyoTracer.exiting(sourceClass, "InyoResult");
    }

    public void buildResultEnvelope(byte[] uri, int len, short score) {
        InyoTracer.entering(sourceClass, "buildResultEnvelope");
        if (len > this.resEnvSize - 6) {
            this.resEnvSize = len + 6;
            this.resEnvelope = new byte[this.resEnvSize];
        }
        int envLen = len;
        int status = 1;
        this.length = 4;
        if (score > 0) {
            this.length += 2;
            status = 5;
            envLen += 2;
        }
        this.length += len;
        int i = 0;
        this.resEnvelope[i++] = (byte)(status >> 8 & 0xFF);
        this.resEnvelope[i++] = (byte)(status & 0xFF);
        this.resEnvelope[i++] = (byte)(envLen >> 8 & 0xFF);
        this.resEnvelope[i++] = (byte)(envLen & 0xFF);
        if (score > 0) {
            this.resEnvelope[i++] = (byte)(score >> 8 & 0xFF);
            this.resEnvelope[i++] = (byte)(score & 0xFF);
        }
        System.arraycopy(uri, 0, this.resEnvelope, i, len);
        InyoTracer.exiting(sourceClass, "buildResultEnvelope");
    }

    public void buildResultEnvelope(String uri, short score) {
        InyoTracer.entering(sourceClass, "buildResultEnvelope");
        this.docId = uri;
        try {
            this.buildResultEnvelope(uri.getBytes("UTF-8"), uri.length(), score);
        }
        catch (UnsupportedEncodingException x) {
            this.length = 0;
        }
        InyoTracer.exiting(sourceClass, "buildResultEnvelope");
    }

    public void buildSelectivityEnvelope(SelectivityInfo sel) {
        InyoTracer.entering(sourceClass, "buildSelectivityEnvelope");
        int estimate = sel.getEstimatedResults();
        int totalDocs = sel.getTotalDocs();
        int cost = sel.getEstimatedCost();
        int envLen = 12;
        int status = 1;
        this.length = envLen + 2 + 2;
        int i = 0;
        this.resEnvelope[i++] = (byte)(status >> 8 & 0xFF);
        this.resEnvelope[i++] = (byte)(status & 0xFF);
        this.resEnvelope[i++] = (byte)(envLen >> 8 & 0xFF);
        this.resEnvelope[i++] = (byte)(envLen & 0xFF);
        this.resEnvelope[i++] = (byte)(estimate >> 24 & 0xFF);
        this.resEnvelope[i++] = (byte)(estimate >> 16 & 0xFF);
        this.resEnvelope[i++] = (byte)(estimate >> 8 & 0xFF);
        this.resEnvelope[i++] = (byte)(estimate & 0xFF);
        this.resEnvelope[i++] = (byte)(totalDocs >> 24 & 0xFF);
        this.resEnvelope[i++] = (byte)(totalDocs >> 16 & 0xFF);
        this.resEnvelope[i++] = (byte)(totalDocs >> 8 & 0xFF);
        this.resEnvelope[i++] = (byte)(totalDocs & 0xFF);
        this.resEnvelope[i++] = (byte)(cost >> 24 & 0xFF);
        this.resEnvelope[i++] = (byte)(cost >> 16 & 0xFF);
        this.resEnvelope[i++] = (byte)(cost >> 8 & 0xFF);
        this.resEnvelope[i++] = (byte)(cost & 0xFF);
        InyoTracer.exiting(sourceClass, "buildSelectivityEnvelope");
    }

    public String toString() {
        InyoTracer.entering(sourceClass, "toString");
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.length; ++i) {
            s.append(Byte.toString(this.resEnvelope[i]) + " ");
        }
        s.setLength(this.length);
        InyoTracer.exiting(sourceClass, "toString");
        return s.toString();
    }

    public String getDocID() {
        InyoTracer.entering(sourceClass, "getDocID");
        return this.docId;
    }

    public byte[] getResult() {
        InyoTracer.entering(sourceClass, "getResult");
        return this.resEnvelope;
    }

    public int getResultLen() {
        InyoTracer.entering(sourceClass, "getResultLen");
        return this.length;
    }
}

