/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.util;

import com.ibm.es.nuvo.inyo.util.InyoTracer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class InyoLogger {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = InyoLogger.class.getName();
    private static PrintStream fileStream = null;

    private static synchronized void initializeStream() {
        InyoTracer.entering(sourceClass, "initializeStream");
        if (System.getProperty("debugFile") != null) {
            try {
                fileStream = new PrintStream(new File(System.getProperty("debugFile")));
            }
            catch (FileNotFoundException ex) {
                fileStream = null;
            }
        }
        if (fileStream == null) {
            fileStream = new PrintStream(System.out);
        }
        InyoTracer.exiting(sourceClass, "initializeStream");
    }

    public static synchronized void println(String in) {
        InyoTracer.entering(sourceClass, "println");
        if (fileStream == null) {
            InyoLogger.initializeStream();
        }
        fileStream.println(in);
        fileStream.flush();
        InyoTracer.exiting(sourceClass, "println");
    }

    public static void main(String[] args) {
        InyoLogger.println("Hello World");
    }
}

