/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.util;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.inyo.util.InyoUtil;

public class DocParseResult {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = DocParseResult.class.getName();
    private String docID;
    private int statusCode;
    private Message errMesg;
    private String locale;

    public DocParseResult(String docID, int retCode) {
        InyoTracer.entering(sourceClass, "DocParseResult");
        this.docID = docID;
        this.statusCode = retCode;
        this.locale = "en_US";
        this.errMesg = null;
        InyoTracer.exiting(sourceClass, "DocParseResult");
    }

    public DocParseResult(String docID, int retCode, Message inMsg) {
        InyoTracer.entering(sourceClass, "DocParseResult");
        this.docID = docID;
        this.statusCode = retCode;
        this.errMesg = inMsg;
        this.locale = "en_US";
        InyoTracer.exiting(sourceClass, "DocParseResult");
    }

    public String getMessageID() {
        InyoTracer.entering(sourceClass, "getMessageID");
        return this.errMesg != null ? this.errMesg.getDisplayKey() : null;
    }

    public String getMessageText() {
        InyoTracer.entering(sourceClass, "getMessageText");
        return this.errMesg != null ? this.errMesg.getFormattedText(InyoUtil.getLocale(this.locale)) : null;
    }

    public String getDocID() {
        InyoTracer.entering(sourceClass, "getDocID");
        return this.docID;
    }

    public Message getMessage() {
        InyoTracer.entering(sourceClass, "getMessage");
        return this.errMesg;
    }

    public boolean hasErrorMesg() {
        InyoTracer.entering(sourceClass, "hasErrorMesg");
        return this.errMesg != null;
    }

    public int getStatusCode() {
        InyoTracer.entering(sourceClass, "getStatusCode");
        return this.statusCode;
    }

    public void setLocale(String locale) {
        InyoTracer.entering(sourceClass, "setLocale");
        this.locale = locale;
        InyoTracer.exiting(sourceClass, "setLocale");
    }
}

