/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.search;

import com.ibm.es.nuvo.common.Constants;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoLogger;
import com.ibm.es.nuvo.inyo.util.InyoResultsWriter;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.search.CustomHitCollector;
import com.ibm.es.nuvo.util.Base64;
import java.io.IOException;
import java.util.logging.Level;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.IndexSearcher;

public class StreamingHitCollector
extends CustomHitCollector {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = StreamingHitCollector.class.getName();
    private InyoResultsWriter writer;
    private String collectionId;
    private boolean err;
    private boolean debug;
    private boolean profile;
    private int resultLimits;
    private long timer;
    private byte[] resBuffer;
    private TermPositions positions;
    private boolean scoreWanted;
    private static double ALPHA = 4.4;

    public StreamingHitCollector(String colId, InyoResultsWriter writer) {
        InyoTracer.entering(sourceClass, "StreamingHitCollector");
        this.totalHits = 0;
        this.writer = writer;
        this.collectionId = colId;
        this.err = false;
        this.query = null;
        this.searcher = null;
        this.resultLimits = 0;
        this.timer = 0L;
        this.resBuffer = new byte[128];
        this.debug = false;
        InyoTracer.exiting(sourceClass, "StreamingHitCollector");
    }

    public void setDebugState(boolean val) {
        InyoTracer.entering(sourceClass, "setDebugState");
        this.debug = val;
        InyoTracer.exiting(sourceClass, "setDebugState");
    }

    public void setProfileState(boolean val) {
        InyoTracer.entering(sourceClass, "setProfileState");
        this.profile = val;
        InyoTracer.exiting(sourceClass, "setProfileState");
    }

    public void setResultLimit(int num) {
        InyoTracer.entering(sourceClass, "setResultLimit");
        this.resultLimits = num;
        InyoTracer.exiting(sourceClass, "setResultLimit");
    }

    public long getProfileInfo() {
        InyoTracer.entering(sourceClass, "getProfileInfo");
        return this.timer;
    }

    public void setScoreWanted(boolean val) {
        InyoTracer.entering(sourceClass, "setScoreWanted");
        this.scoreWanted = val;
        InyoTracer.exiting(sourceClass, "setScoreWanted");
    }

    public void setIndexSearcher(IndexSearcher searcher) {
        InyoTracer.entering(sourceClass, "setIndexSearcher");
        this.searcher = searcher;
        try {
            this.positions = this.searcher.getIndexReader().termPositions(Constants.BINARY_KEY_TERM);
        }
        catch (IOException ex) {
            Message msg = new Message("D0023E.SEARCH_IO_EXCEPTION");
            InyoException e = new InyoException(msg, (Throwable)ex);
            this.writer.write(e);
            if (Loggers.logger.isLoggable(Level.SEVERE)) {
                Loggers.logger.log(Level.SEVERE, e);
            }
            if (this.debug) {
                System.err.println("Exception in stream collector");
                ex.printStackTrace();
            }
            throw new RuntimeException("Abnormal end from runtime");
        }
        InyoTracer.exiting(sourceClass, "setIndexSearcher");
    }

    public void collect(int docId, float score) {
        InyoTracer.entering(sourceClass, "collect");
        ++this.totalHits;
        long t0 = 0L;
        try {
            if (this.profile) {
                t0 = System.currentTimeMillis();
            }
            if (this.positions.skipTo(docId) && this.positions.nextPosition() >= 0) {
                int len = this.positions.getPayloadLength();
                byte[] buff = this.positions.getPayload(this.resBuffer, 0);
                if (this.profile) {
                    this.timer += System.currentTimeMillis() - t0;
                }
                short outScore = 0;
                if (this.scoreWanted) {
                    outScore = this.computeTruncatedScore(score);
                }
                if (this.debug) {
                    InyoLogger.println("doc id " + docId);
                    byte[] uri = new byte[len];
                    System.arraycopy(buff, 0, uri, 0, len);
                    InyoLogger.println("len of uri arr" + uri.length);
                    InyoLogger.println("URI " + Base64.encode(uri) + " Score " + outScore);
                    for (int i = 0; i < len; ++i) {
                        InyoLogger.println(Integer.toString(uri[i]) + " ");
                    }
                }
                if (!this.writer.write(buff, len, outScore)) {
                    this.err = true;
                    throw new RuntimeException("Abnormal end from runtime");
                }
            }
        }
        catch (IOException ex) {
            this.err = true;
            Message msg = new Message("D0023E.SEARCH_IO_EXCEPTION");
            InyoException e = new InyoException(msg, (Throwable)ex);
            this.writer.write(e);
            if (Loggers.logger.isLoggable(Level.SEVERE)) {
                Loggers.logger.log(Level.SEVERE, e);
            }
            if (this.debug) {
                System.err.println("Exception in stream collector");
                ex.printStackTrace();
            }
            throw new RuntimeException("Abnormal end from runtime");
        }
        if (this.resultLimits > 0 && this.totalHits == this.resultLimits) {
            throw new RuntimeException("result_limit_reached");
        }
        InyoTracer.exiting(sourceClass, "collect");
    }

    private short computeTruncatedScore(float score) {
        InyoTracer.entering(sourceClass, "computeTruncatedScore");
        if ((double)score > 1.0) {
            return 1000;
        }
        return (short)(score * 1000.0f);
    }

    private short computeNormalizedScore(float score) {
        InyoTracer.entering(sourceClass, "computeNormalizedScore");
        return (short)(1000.0 * (1.0 - 1.0 / Math.pow(ALPHA, score)));
    }
}

