/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.search;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.inyo.search.SelectionHandler;
import com.ibm.es.nuvo.inyo.search.StreamingHitCollector;
import com.ibm.es.nuvo.inyo.util.DB2Logger;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoResultsWriter;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.Query;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Hashtable;
import java.util.logging.Level;

public class StreamingHandler
extends SelectionHandler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = StreamingHandler.class.getName();

    public void execute(Hashtable params, DataInputStream in, DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "execute");
        long t0 = 0L;
        if (this.debug) {
            DB2Logger.println("DEBUG: Begin StreamingHandler exececute()");
        }
        if (this.profile) {
            t0 = System.currentTimeMillis();
        }
        String queryString = (String)params.get("query");
        this.validateQuery(params);
        String colId = (String)params.get("index");
        String mode = (String)params.get("mode");
        InyoResultsWriter writer = new InyoResultsWriter(out);
        StreamingHitCollector collector = new StreamingHitCollector(colId, writer);
        if (this.profile) {
            writer.setProfileState(true);
            collector.setProfileState(true);
        }
        if (this.debug) {
            writer.setDebugState(true);
            collector.setDebugState(true);
        }
        try {
            String toReturnScore;
            Query query = this.searchBean.getSkeletonQuery(queryString);
            this.populateQuery(query, params);
            int resLen = Integer.parseInt((String)params.get("resultLimit"));
            if (resLen > 0) {
                collector.setResultLimit(resLen);
            }
            if (mode.equals("scalar")) {
                collector.setResultLimit(1);
            }
            if ((toReturnScore = (String)params.get("scoreWanted")) != null && toReturnScore.equals("true")) {
                collector.setScoreWanted(true);
            }
            this.searchBean.search(colId, query, collector);
            if (this.profile) {
                DB2Logger.println("PROFILE: Time taken by Search (before flush() in ms " + (System.currentTimeMillis() - t0));
            }
            writer.flush();
            if (this.debug) {
                DB2Logger.println("DEBUG: Hits count : " + collector.getHitCount());
            }
        }
        catch (SiapiException ex) {
            InyoException e = new InyoException(ex);
            Loggers.logger.log(Level.SEVERE, e);
            throw e;
        }
        catch (ExtendedException ex) {
            InyoException e = new InyoException(ex);
            Loggers.logger.log(Level.SEVERE, e);
            throw e;
        }
        if (this.profile) {
            t0 = System.currentTimeMillis() - t0;
            DB2Logger.println("PROFILE: Time taken by Search in ms " + t0);
            DB2Logger.println("PROFILE: Hits count : " + collector.getHitCount());
            DB2Logger.println("PROFILE: Time taken by writer in ms : " + writer.getProfileInfo());
            DB2Logger.println("PROFILE: Time taken by store look up in ms : " + collector.getProfileInfo());
        }
        if (this.debug) {
            DB2Logger.println("DEBUG: End StreamingHandler exececut()");
        }
        params.put("conPersist", "true");
        InyoTracer.exiting(sourceClass, "execute");
    }
}

