/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.search;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.inyo.search.SelectionHandler;
import com.ibm.es.nuvo.inyo.search.SelectivityCollector;
import com.ibm.es.nuvo.inyo.util.DB2Logger;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoResultsWriter;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.inyo.util.SelectivityInfo;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.Query;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.logging.Level;

public class SelectivityHandler
extends SelectionHandler {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = SelectivityHandler.class.getName();

    public void execute(Hashtable parameters, DataInputStream in, DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "execute");
        long t0 = 0L;
        this.setProfileState(true);
        this.setDebugState(true);
        if (this.debug) {
            DB2Logger.println("DEBUG: Begin StreamingHandler exececute()");
        }
        if (this.profile) {
            t0 = System.currentTimeMillis();
        }
        InyoResultsWriter writer = new InyoResultsWriter(out);
        SelectivityInfo selInfo = this.computeSelectivity(parameters);
        writer.write(selInfo);
        writer.flush();
        if (this.profile) {
            t0 = System.currentTimeMillis() - t0;
            DB2Logger.println("PROFILE: Time taken by Selectivity in ms " + t0);
        }
        if (this.debug) {
            DB2Logger.println("DEBUG: End StreamingHandler exececut()");
        }
        parameters.put("conPersist", "true");
        InyoTracer.exiting(sourceClass, "execute");
    }

    private int getSeed(String query) throws InyoException {
        InyoTracer.entering(sourceClass, "getSeed");
        int ret = -1;
        try {
            byte[] passBytes = query.getBytes();
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] outMesg = md.digest(passBytes);
            ret = outMesg[3] << 24 | outMesg[2] << 16 | outMesg[1] << 8 | outMesg[0];
            if (ret < 0) {
                ret = -ret;
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            InyoException ex = new InyoException(e);
            Loggers.logger.log(Level.SEVERE, ex);
            throw ex;
        }
        InyoTracer.exiting(sourceClass, "getSeed");
        return ret %= 10000;
    }

    private SelectivityInfo computeSelectivity(Hashtable parameters) throws InyoException {
        InyoTracer.entering(sourceClass, "computeSelectivity");
        String queryString = (String)parameters.get("query");
        String colId = (String)parameters.get("index");
        this.validateQuery(parameters);
        String newQuery = "_seed:" + this.getSeed(queryString) + " AND " + queryString;
        if (this.debug) {
            DB2Logger.println("New Query " + newQuery);
        }
        SelectivityInfo res = null;
        try {
            Query query = this.searchBean.getSkeletonQuery(newQuery);
            this.populateQuery(query, parameters);
            SelectivityCollector collector = new SelectivityCollector();
            this.searchBean.search(colId, query, collector);
            res = new SelectivityInfo(collector.getEstimate(), collector.getNumOfDocs(), collector.getCost());
            if (this.debug) {
                DB2Logger.println(" Estimate " + collector.getEstimate() + " ndocs " + collector.getNumOfDocs() + " cost  " + collector.getCost() + " timespent " + collector.getTimeSpent());
                DB2Logger.println("Hits count : " + collector.getHitCount());
            }
        }
        catch (SiapiException ex) {
            InyoException e = new InyoException(ex);
            Loggers.logger.log(Level.SEVERE, e);
            throw e;
        }
        catch (ExtendedException ex) {
            InyoException e = new InyoException(ex);
            Loggers.logger.log(Level.SEVERE, e);
            throw e;
        }
        InyoTracer.exiting(sourceClass, "computeSelectivity");
        return res;
    }
}

