/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.search;

import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.search.CustomHitCollector;

public class SelectivityCollector
extends CustomHitCollector {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = SelectivityCollector.class.getName();
    private int totalDocs;
    private int lastDocId;
    private long startTime;
    private static long duration = 10000L;
    private long timeSpent;
    private int estimate;
    private boolean timedOut;

    public SelectivityCollector() {
        InyoTracer.entering(sourceClass, "SelectivityCollector");
        this.totalHits = 0;
        this.totalDocs = -1;
        this.startTime = System.currentTimeMillis();
        this.lastDocId = -1;
        this.estimate = -1;
        this.timedOut = false;
        InyoTracer.exiting(sourceClass, "SelectivityCollector");
    }

    public void collect(int docId, float score) {
        InyoTracer.entering(sourceClass, "collect");
        ++this.totalHits;
        this.lastDocId = docId;
        this.timeSpent = System.currentTimeMillis() - this.startTime;
        if (this.timeSpent >= duration) {
            this.timedOut = true;
            throw new RuntimeException("timedout");
        }
        InyoTracer.exiting(sourceClass, "collect");
    }

    public int getNumOfDocs() {
        InyoTracer.entering(sourceClass, "getNumOfDocs");
        if (this.totalDocs < 0) {
            this.totalDocs = this.searcher.getIndexReader().numDocs();
        }
        return this.totalDocs;
    }

    public int getLastDocId() {
        InyoTracer.entering(sourceClass, "getLastDocId");
        return this.lastDocId;
    }

    public long getTimeSpent() {
        InyoTracer.entering(sourceClass, "getTimeSpent");
        return this.timeSpent;
    }

    public boolean toSearchForEstimate() {
        InyoTracer.entering(sourceClass, "toSearchForEstimate");
        return true;
    }

    public int getCost() {
        InyoTracer.entering(sourceClass, "getCost");
        return 1;
    }

    public int getEstimate() {
        InyoTracer.entering(sourceClass, "getEstimate");
        if (this.estimate < 0) {
            this.computeEstimate();
        }
        return this.estimate;
    }

    private void computeEstimate() {
        InyoTracer.entering(sourceClass, "computeEstimate");
        this.totalDocs = this.searcher.getIndexReader().numDocs();
        float prob = 1.0E-4f;
        float n = this.totalHits;
        if (n <= 0.0f) {
            this.estimate = 1;
        }
        if (n > 10000.0f) {
            this.estimate = this.totalDocs;
        } else if (!this.timedOut) {
            this.estimate = (int)(n * prob * (float)this.totalDocs);
        } else {
            float estHits = n / (float)this.lastDocId * (float)this.totalDocs;
            this.estimate = (int)(estHits * prob * (float)this.totalDocs);
        }
        if (this.estimate <= 0) {
            this.estimate = 1;
        }
        InyoTracer.exiting(sourceClass, "computeEstimate");
    }

    public static void main(String[] args) {
    }
}

