/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.search;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoHandler;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.inyo.util.StatusStructure;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.search.SearchBean;
import com.ibm.es.nuvo.search.SearchBeanInstantiationException;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.Query;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public abstract class SelectionHandler
implements InyoHandler {
    private static final String sourceClass = SelectionHandler.class.getName();
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected boolean debug;
    protected boolean profile;
    protected SearchBean searchBean;

    public SelectionHandler() {
        InyoTracer.entering(sourceClass, "SelectionHandler");
        try {
            this.searchBean = SearchBean.getInstance();
        }
        catch (SearchBeanInstantiationException e) {
            Loggers.logger.log(e);
        }
        InyoTracer.exiting(sourceClass, "SelectionHandler");
    }

    public abstract void execute(Hashtable var1, DataInputStream var2, DataOutputStream var3) throws InyoException;

    public StatusStructure getStatus() throws InyoException {
        InyoTracer.entering(sourceClass, "");
        return null;
    }

    public void shutdown(Hashtable headers, OutputStream out) throws InyoException {
    }

    public void shutdown() throws InyoException {
    }

    public void register(InyoHandler handler) {
    }

    public void setProfileState(boolean val) {
        InyoTracer.entering(sourceClass, "setProfileState");
        this.profile = val;
    }

    public void setDebugState(boolean val) {
        InyoTracer.entering(sourceClass, "setDebugState");
        this.debug = val;
    }

    public boolean done() {
        InyoTracer.entering(sourceClass, "done");
        return true;
    }

    public void validateQuery(Hashtable params) throws InyoException {
        InyoTracer.entering(sourceClass, "validateQuery");
        String locale = (String)params.get("locale");
        String queryString = (String)params.get("query");
        if (queryString == null) {
            throw new InyoException(new Message("D0021E.NULL_QUERY_STRING"), locale);
        }
        int len = queryString.length();
        if (len > 4096) {
            throw new InyoException(new Message("D0020E.MAX_QUERY_LENGTH"), locale);
        }
        int j = 0;
        for (int i = 0; i < len && Character.isWhitespace(queryString.charAt(i)); ++i) {
            ++j;
        }
        if (j == len) {
            throw new InyoException(new Message("D0022E.MALFORMED_QUERY_STRING"), locale);
        }
        InyoTracer.exiting(sourceClass, "validateQuery");
    }

    public void populateQuery(Query query, Hashtable params) throws SiapiException {
        InyoTracer.entering(sourceClass, "populateQuery");
        String queryLang = (String)params.get("queryLang");
        if (queryLang != null) {
            query.setQueryLanguage(queryLang);
        } else {
            query.setQueryLanguage("en");
        }
        String synonyms = (String)params.get("UseSynonym");
        if (synonyms != null && synonyms.equalsIgnoreCase("true")) {
            query.setProperty("synonymExpansion", Boolean.toString(true));
        } else {
            query.setProperty("synonymExpansion", Boolean.toString(false));
        }
        String proximity = (String)params.get("ProximityScoring");
        if (proximity != null && proximity.equalsIgnoreCase("true")) {
            query.setProperty("proximityScoring", Boolean.toString(true));
        } else {
            query.setProperty("proximityScoring", Boolean.toString(false));
        }
        query.setProperty("staticScoring", Boolean.toString(false));
        query.setReturnedAttribute(-10, true);
        query.setReturnedAttribute(-11, true);
        String mode = (String)params.get("mode");
        if (mode.equals("scalar")) {
            String docId = (String)params.get("docId");
            query.setProperty("scalarFilter", docId);
        }
        InyoTracer.exiting(sourceClass, "populateQuery");
    }

    public void setTimeOut(int timeinMillis) {
    }
}

