/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.search;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.inyo.search.SelectionHandler;
import com.ibm.es.nuvo.inyo.search.SelectivityHandler;
import com.ibm.es.nuvo.inyo.search.StreamingHandler;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoFactory;
import com.ibm.es.nuvo.inyo.util.InyoHandler;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import java.util.Hashtable;

public class InyoSearchFactory
extends InyoFactory {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = InyoSearchFactory.class.getName();

    public InyoHandler getHandler(Hashtable params) throws InyoException {
        InyoTracer.entering(sourceClass, "getHandler");
        String mode = (String)params.get("mode");
        SelectionHandler handle = null;
        String locale = (String)params.get("locale");
        if (mode.equals("selectivity")) {
            handle = new SelectivityHandler();
        } else if (mode.equals("streaming") || mode.equals("scalar")) {
            handle = new StreamingHandler();
        } else {
            throw new InyoException(new Message("D0027E.UNSUPORTED_ACTION", mode), locale);
        }
        if (this.debug) {
            handle.setDebugState(true);
        }
        if (this.profile) {
            handle.setProfileState(true);
        }
        InyoTracer.exiting(sourceClass, "getHandler");
        return handle;
    }

    public void removeHandler(Hashtable params) throws InyoException {
    }

    public void shutdown() throws InyoException {
    }
}

