/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.monitor;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.inyo.admin.InyoAdminFactory;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoFactory;
import com.ibm.es.nuvo.inyo.util.InyoHandler;
import com.ibm.es.nuvo.inyo.util.InyoSocketUtil;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.inyo.util.StatusStructure;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.status.JvmStatus;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.logging.Level;

public class InyoMonitor
implements InyoHandler {
    private static final String sourceClass = InyoMonitor.class.getName();
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String colID;
    private boolean debug;
    private boolean profile;

    public InyoMonitor(String col) {
        InyoTracer.entering(sourceClass, "InyoMonitor");
        this.colID = col;
        this.debug = false;
        this.profile = false;
        InyoTracer.exiting(sourceClass, "InyoMonitor");
    }

    public void execute(Hashtable headers, DataInputStream in, DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "execute");
        String act = (String)headers.get("action");
        String locale = (String)headers.get("locale");
        if (act.equals("getStatus")) {
            String scope = (String)headers.get("scope");
            if (scope != null && scope.equals("system")) {
                this.handleSystemStatus(headers, out);
            } else {
                this.handleCollectionStatus(headers, out);
            }
        } else if (act.equals("shutdown")) {
            this.handleShutdown(headers, out);
        } else if (act.equals("collectionStatus")) {
            this.handleColStatus(headers, out);
        } else if (act.equals("configureTrace")) {
            this.handleConfigureTrace(headers, out);
        } else if (act.equals("printTrace")) {
            this.handlePrintTrace(out);
        } else if (act.equals("getThreadStack")) {
            this.handleStackTrace(out);
        } else {
            throw new InyoException(new Message("D0027E.UNSUPORTED_ACTION", act), locale);
        }
        InyoTracer.exiting(sourceClass, "execute");
    }

    public StatusStructure getStatus() throws InyoException {
        InyoTracer.entering(sourceClass, "getStatus");
        return new StatusStructure(StatusStructure.StatusCode.DONE);
    }

    private void handleConfigureTrace(Hashtable headers, DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "handleConfigureTrace");
        String locale = (String)headers.get("locale");
        try {
            String trace = (String)headers.get("trace");
            if (trace.equals("on")) {
                Loggers.getWrappedTracer().setLevel(Level.FINEST);
            } else {
                Loggers.getWrappedTracer().setLevel(Level.OFF);
            }
            InyoSocketUtil.sendResponse(out, new StatusStructure(StatusStructure.StatusCode.DONE));
        }
        catch (ConfigurationManagerException e) {
            throw new InyoException(new Message(e.getMessage()), locale);
        }
        InyoTracer.exiting(sourceClass, "handleConfigureTrace");
    }

    private void handlePrintTrace(DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "handlePrintTrace");
        boolean off = Loggers.getWrappedTracer().getLevel().equals(Level.OFF);
        if (off) {
            InyoSocketUtil.sendResponse(out, new StatusStructure(StatusStructure.StatusCode.TRACEOFF));
        } else {
            InyoSocketUtil.sendResponse(out, new StatusStructure(StatusStructure.StatusCode.TRACEON));
        }
        InyoTracer.exiting(sourceClass, "handlePrintTrace");
    }

    private void handleColStatus(Hashtable headers, DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "handleColStatus");
        InyoFactory adminFactory = InyoAdminFactory.getInstance();
        StatusStructure stats = adminFactory.getHandler(headers).getStatus();
        InyoSocketUtil.sendResponse(out, stats);
        InyoTracer.exiting(sourceClass, "handleColStatus");
    }

    private void handleCollectionStatus(Hashtable headers, DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "handleCollectionStatus");
        String opcode = (String)headers.get("opcode");
        if (opcode.equals("16") || opcode.equals("17")) {
            InyoFactory adminFactory = InyoAdminFactory.getInstance();
            StatusStructure stats = adminFactory.getHandler(headers).getStatus();
            String locale = (String)headers.get("locale");
            InyoException ex = null;
            ex = stats.getError();
            if (ex != null) {
                ex.setLocale(locale);
            }
            InyoSocketUtil.sendResponse(out, stats);
        } else {
            InyoSocketUtil.sendResponse(out, this.getStatus());
        }
        InyoTracer.exiting(sourceClass, "handleCollectionStatus");
    }

    private void handleShutdown(Hashtable headers, DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "handleShutdown");
        String locale = (String)headers.get("locale");
        try {
            GlobalSystem.getSingleInstance().shutdown(true, true, null, Locale.getDefault(), true, true);
        }
        catch (InterruptedException e) {
            InyoException ex = new InyoException(new Message("D0053E.SHUTDOWN_FAILED"), locale);
            Loggers.logger.log(Level.SEVERE, ex);
            throw ex;
        }
        InyoSocketUtil.sendResponse(out);
        InyoTracer.exiting(sourceClass, "handleShutdown");
    }

    private void handleSystemStatus(Hashtable headers, DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "");
        InyoSocketUtil.sendResponse(out, this.getStatus());
        InyoTracer.exiting(sourceClass, "");
    }

    public void shutdown(Hashtable headers, OutputStream out) throws InyoException {
    }

    private void handleStackTrace(DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "handleStackTrace");
        XMLTagger tagger = new XMLTagger();
        JvmStatus.getStatus(tagger);
        byte[] buf = null;
        try {
            buf = tagger.getXML().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            buf = tagger.getXML().getBytes();
        }
        InyoSocketUtil.sendPayLoad(out, buf, buf.length);
        InyoTracer.exiting(sourceClass, "handleStackTrace");
    }

    public void shutdown() throws InyoException {
    }

    public void register(InyoHandler handler) {
    }

    public void setDebugState(boolean val) {
        this.debug = val;
    }

    public void setProfileState(boolean val) {
        InyoTracer.entering(sourceClass, "");
        this.profile = val;
    }

    public boolean done() {
        InyoTracer.entering(sourceClass, "");
        return true;
    }

    public void setTimeOut(int timeinMillis) {
    }
}

