/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.ingest;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.inyo.ingest.InyoAsyncDocHandler;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoFactory;
import com.ibm.es.nuvo.inyo.util.InyoHandler;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import java.util.Hashtable;

public class InyoDocIngestFactory
extends InyoFactory {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = InyoDocIngestFactory.class.getName();
    private Hashtable<String, InyoHandler> handlerTable;
    private static InyoDocIngestFactory ownInstance = null;

    public static InyoDocIngestFactory getInstance() {
        InyoTracer.entering(sourceClass, "getInstance");
        if (ownInstance == null) {
            ownInstance = new InyoDocIngestFactory();
        }
        InyoTracer.exiting(sourceClass, "getInstance");
        return ownInstance;
    }

    public synchronized InyoHandler getHandler(Hashtable params) throws InyoException {
        InyoTracer.entering(sourceClass, "getHandler");
        String colId = (String)params.get("index");
        String locale = (String)params.get("locale");
        InyoHandler handler = this.handlerTable.get(colId);
        if (handler == null) {
            ConfigurationManager config = ConfigurationManager.getConfigurationManager();
            if (!config.collectionExists(colId)) {
                InyoException ae = new InyoException(new Message("D0006E.NONEXISTANT_COLLECTION", colId), locale);
                throw ae;
            }
            handler = new InyoAsyncDocHandler(colId);
            if (this.debug) {
                handler.setDebugState(true);
            }
            if (this.profile) {
                handler.setProfileState(true);
            }
            this.handlerTable.put(colId, handler);
        }
        InyoTracer.exiting(sourceClass, "getHandler");
        return handler;
    }

    public synchronized void removeHandler(Hashtable params) {
        InyoTracer.entering(sourceClass, "removeHandler");
        String colId = (String)params.get("index");
        this.handlerTable.remove(colId);
        InyoTracer.exiting(sourceClass, "removeHandler");
    }

    public void shutdown() throws InyoException {
    }

    private InyoDocIngestFactory() {
        InyoTracer.entering(sourceClass, "InyoDocIngestFactory");
        this.handlerTable = new Hashtable(30);
        InyoTracer.exiting(sourceClass, "InyoDocIngestFactory");
    }
}

