/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.ingest;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.documentqueue.DeleteDocument;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.indexer.DocumentIndexer;
import com.ibm.es.nuvo.indexer.IndexerException;
import com.ibm.es.nuvo.inyo.ingest.InyoDocIngestFactory;
import com.ibm.es.nuvo.inyo.util.DocParseResult;
import com.ibm.es.nuvo.inyo.util.InyoDocument;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoHandler;
import com.ibm.es.nuvo.inyo.util.InyoLogger;
import com.ibm.es.nuvo.inyo.util.InyoSocketUtil;
import com.ibm.es.nuvo.inyo.util.InyoStreamUtil;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.inyo.util.StatusStructure;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;

public class InyoAsyncDocHandler
implements InyoHandler {
    private static final String sourceClass = InyoAsyncDocHandler.class.getName();
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String colID;
    private boolean colIDSet;
    private ArrayBlockingQueue<InyoDocument> inDocQue;
    private ArrayBlockingQueue<DocParseResult> outDocQue;
    private boolean debug;
    private boolean profile;
    private boolean docProcessorOn;
    private boolean toShutdown;
    private boolean useQueue;
    private boolean gotAllDocs;
    private DocProcessor docProcessor;
    Object syncLock;
    InyoDocIngestFactory factory;
    private static final int MaxParseRsultCount = 10;
    private long startTime;
    private long parseTime;
    private long idxTime;
    private long lastUsedTime;
    private long parseResTime;
    private int count;
    private String locale;
    private DocumentIndexer docIndexer;
    private int timeout;

    public InyoAsyncDocHandler(String id) {
        InyoTracer.entering(sourceClass, "InyoAsyncDocHandler");
        this.colID = id;
        this.colIDSet = true;
        this.inDocQue = new ArrayBlockingQueue(100, true);
        this.outDocQue = new ArrayBlockingQueue(100, true);
        this.docProcessor = null;
        this.docProcessorOn = false;
        this.toShutdown = false;
        this.gotAllDocs = false;
        this.syncLock = new Object();
        this.debug = false;
        this.profile = false;
        this.factory = null;
        this.startTime = 0L;
        this.lastUsedTime = 0L;
        this.parseTime = 0L;
        this.parseResTime = 0L;
        this.idxTime = 0L;
        this.count = 0;
        this.locale = null;
        this.docIndexer = this.getIndexer();
        InyoTracer.exiting(sourceClass, "InyoAsyncDocHandler");
    }

    private InyoAsyncDocHandler() {
    }

    private synchronized void startProcessorThread() throws InyoException {
        InyoTracer.entering(sourceClass, "startProcessorThread");
        this.outDocQue.clear();
        this.setLastDocRecvd(false);
        if (this.useQueue) {
            this.inDocQue.clear();
            this.docProcessor = new DocProcessor();
            this.docProcessor.start();
        }
        this.setDocProcessingState(true);
        this.updateTimer();
        InyoTracer.exiting(sourceClass, "startProcessorThread");
    }

    private synchronized void stopProcessorThread() {
        InyoTracer.entering(sourceClass, "stopProcessorThread");
        if (this.isDocProcessingOn()) {
            this.docProcessor.interrupt();
        }
        InyoTracer.exiting(sourceClass, "stopProcessorThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDocProcessingState(boolean flag) {
        InyoTracer.entering(sourceClass, "setDocProcessingState");
        Object object = this.syncLock;
        synchronized (object) {
            this.docProcessorOn = flag;
        }
        InyoTracer.exiting(sourceClass, "setDocProcessingState");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimer() {
        InyoTracer.entering(sourceClass, "updateTimer");
        Object object = this.syncLock;
        synchronized (object) {
            this.lastUsedTime = System.currentTimeMillis();
        }
        InyoTracer.exiting(sourceClass, "updateTimer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDocProcessingOn() {
        InyoTracer.entering(sourceClass, "isDocProcessingOn");
        Object object = this.syncLock;
        synchronized (object) {
            if (this.docProcessorOn && this.lastUsedTime + (long)this.timeout < System.currentTimeMillis()) {
                this.docProcessorOn = false;
            }
        }
        InyoTracer.exiting(sourceClass, "isDocProcessingOn");
        return this.docProcessorOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setShutdown(boolean flag) {
        InyoTracer.entering(sourceClass, "setShutdown");
        Object object = this.syncLock;
        synchronized (object) {
            this.toShutdown = flag;
        }
        InyoTracer.exiting(sourceClass, "setShutdown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShutdownOn() {
        InyoTracer.entering(sourceClass, "isShutdownOn");
        Object object = this.syncLock;
        synchronized (object) {
            return this.toShutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastDocRecvd(boolean flag) {
        InyoTracer.entering(sourceClass, "setLastDocRecvd");
        Object object = this.syncLock;
        synchronized (object) {
            this.gotAllDocs = flag;
        }
        InyoTracer.exiting(sourceClass, "setLastDocRecvd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lastDocRecvd() {
        InyoTracer.entering(sourceClass, "lastDocRecvd");
        Object object = this.syncLock;
        synchronized (object) {
            return this.gotAllDocs;
        }
    }

    private boolean toProcessDocs() {
        InyoTracer.entering(sourceClass, "toProcessDocs");
        return this.inDocQue.peek() != null || !this.lastDocRecvd();
    }

    private boolean toProcessResults() {
        InyoTracer.entering(sourceClass, "toProcessResults");
        return this.outDocQue.peek() != null || !this.lastDocRecvd();
    }

    private boolean put(InyoDocument doc) {
        InyoTracer.entering(sourceClass, "put");
        try {
            this.inDocQue.put(doc);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            return false;
        }
        InyoTracer.exiting(sourceClass, "put");
        return true;
    }

    private InyoDocument get() throws InterruptedException {
        InyoTracer.entering(sourceClass, "get");
        return this.inDocQue.poll(5L, DEFAULT_OUTDOCQUEUE_POLL_TIMEOUT_UNITS);
    }

    public void setTimeOut(int timeinMillis) {
        InyoTracer.entering(sourceClass, "setTimeOut");
        this.timeout = timeinMillis;
    }

    public void turnDebugging(boolean flag) {
        InyoTracer.entering(sourceClass, "turnDebugging");
        this.debug = flag;
    }

    private void resetTimer() {
        InyoTracer.entering(sourceClass, "resetTimer");
        this.startTime = 0L;
    }

    private void startTimer() {
        InyoTracer.entering(sourceClass, "startTimer");
        if (this.startTime > 0L) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        InyoTracer.exiting(sourceClass, "startTimer");
    }

    private void printTimeSnapshot(int count) {
        InyoTracer.entering(sourceClass, "printTimeSnapshot");
        if (!this.profile) {
            return;
        }
        long spTime = System.currentTimeMillis() - this.startTime;
        String toPrint = "Cummulative Time Spent in ms for " + count + " docs   " + spTime;
        InyoLogger.println(toPrint);
        InyoTracer.exiting(sourceClass, "printTimeSnapshot");
    }

    public static String constructAddDocKey(String collectionId, String documentURI) {
        InyoTracer.entering(sourceClass, "constructAddDocKey");
        return collectionId + ":" + documentURI;
    }

    private void setCollectionId(String id) {
        InyoTracer.entering(sourceClass, "setCollectionId");
        if (!this.colIDSet) {
            this.colID = id;
            this.colIDSet = true;
        }
        InyoTracer.exiting(sourceClass, "setCollectionId");
    }

    public void setHandlerFactory(InyoDocIngestFactory factory) {
        InyoTracer.entering(sourceClass, "setHandlerFactory");
        this.factory = factory;
    }

    public void execute(Hashtable headers, DataInputStream in, DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "execute");
        String action = (String)headers.get("action");
        if ((String)headers.get("useQueue") != null) {
            this.useQueue = true;
        }
        if (this.debug) {
            InyoLogger.println("DEBUG : in AsyncAddDoc and Action " + action + " on thread " + Thread.currentThread().getId());
        }
        if (action.equals("getParseResult")) {
            this.getDocParseResult(headers, out);
        } else if (action.equals("asyncAddDocument")) {
            this.addDocument(headers, in, out);
        } else if (action.equals("openCollection")) {
            this.locale = (String)headers.get("locale");
            this.openCollection(out);
            headers.put("conPersist", "true");
        } else if (action.equals("closeCollection")) {
            this.closeCollection();
            InyoSocketUtil.sendResponse(out);
        } else if (action.equals("deleteDocument")) {
            this.deleteDocument(headers);
            InyoSocketUtil.sendResponse(out);
        }
        InyoTracer.exiting(sourceClass, "execute");
    }

    public boolean done() {
        InyoTracer.entering(sourceClass, "done");
        return !this.isDocProcessingOn();
    }

    public void shutdown(Hashtable headers, OutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "shutdown");
        this.closeCollection();
    }

    public void shutdown() throws InyoException {
        InyoTracer.entering(sourceClass, "shutdown");
        this.closeCollection();
    }

    public void setDebugState(boolean val) {
        InyoTracer.entering(sourceClass, "setDebugState");
        this.debug = val;
    }

    public void setProfileState(boolean val) {
        InyoTracer.entering(sourceClass, "setProfileState");
        this.profile = val;
    }

    public void register(InyoHandler handler) {
    }

    public StatusStructure getStatus() throws InyoException {
        InyoTracer.entering(sourceClass, "getStatus");
        return new StatusStructure(StatusStructure.StatusCode.DONE);
    }

    private void openCollection(DataOutputStream dout) throws InyoException {
        InyoTracer.entering(sourceClass, "openCollection");
        if (this.debug) {
            InyoLogger.println("DEBUG : in openCollection thread id " + Thread.currentThread().getId());
        }
        if (this.isDocProcessingOn()) {
            InyoException ae = new InyoException(new Message("D0003W.COLLECTION_IS_ALREADY_OPEN"), this.locale);
            InyoSocketUtil.sendResponse(dout, ae);
        } else {
            if (this.profile) {
                this.startTimer();
            }
            this.startProcessorThread();
            InyoSocketUtil.sendResponse(dout);
        }
        if (this.debug) {
            InyoLogger.println("DEBUG : out openCollection ");
        }
        InyoTracer.exiting(sourceClass, "openCollection");
    }

    private void closeCollection() throws InyoException {
        block6: {
            InyoTracer.entering(sourceClass, "closeCollection");
            if (this.debug) {
                InyoLogger.println("DEBUG : in closeCollection thread id " + Thread.currentThread().getId());
            }
            if (this.profile) {
                InyoLogger.println("Time taken to index only " + this.idxTime);
            }
            this.setShutdown(true);
            if (this.isDocProcessingOn()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    if (!this.debug) break block6;
                    InyoLogger.println("Interrupted in closecollection.. continuing");
                }
            }
        }
        this.setDocProcessingState(false);
        if (this.debug) {
            InyoLogger.println("DEBUG : out closeCollection ");
        }
        InyoTracer.exiting(sourceClass, "closeCollection");
    }

    private void deleteDocument(Hashtable headers) throws InyoException {
        InyoTracer.entering(sourceClass, "deleteDocument");
        if (this.debug) {
            InyoLogger.println("Begin Delete Document");
        }
        if (!this.isDocProcessingOn()) {
            InyoException ae = new InyoException(new Message("D0005E.COLLECTION_IS_NOT_OPEN", this.colID), this.locale);
            throw ae;
        }
        String uri = (String)headers.get("docId");
        InyoDocument doc = new InyoDocument(uri, true);
        this.updateTimer();
        if (!this.useQueue) {
            try {
                DeleteDocument delDoc = new DeleteDocument(doc.getURI());
                this.docIndexer.processDocument(this.colID, delDoc, true);
            }
            catch (IndexerException ex) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Loggers.logger.log(Level.SEVERE, ex);
                }
                throw new InyoException(ex);
            }
            catch (ConfigurationManagerException ex) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Loggers.logger.log(Level.SEVERE, ex);
                }
                throw new InyoException(ex);
            }
            catch (Exception ex) {
                InyoException en = new InyoException(ex);
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Loggers.logger.log(Level.SEVERE, en);
                }
                throw en;
            }
        } else if (!this.put(doc)) {
            InyoLogger.println(" error in queueing doc " + uri);
            InyoException ae = new InyoException(new Message("R0004E.DOCUMENT_INSERT_ERROR", uri, this.colID), this.locale);
            throw ae;
        }
        this.updateTimer();
        headers.put("conPersist", "true");
        InyoTracer.exiting(sourceClass, "deleteDocument");
    }

    private DocumentIndexer getIndexer() {
        InyoTracer.entering(sourceClass, "getIndexer");
        return GlobalSystem.getSingleInstance().getDocumentIndexer();
    }

    private void addDocument(Hashtable headers, DataInputStream in, DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "addDocument");
        String collectionId = (String)headers.get("index");
        this.setCollectionId(collectionId);
        String documentURI = "UNKNOWN";
        headers.put("conPersist", "true");
        this.updateTimer();
        try {
            if (this.debug) {
                InyoLogger.println("DEBUG: InyoAsyncDocHandler.executeRequest()");
            }
            if (!this.isDocProcessingOn()) {
                InyoException ae = new InyoException(new Message("D0005E.COLLECTION_IS_NOT_OPEN", collectionId), this.locale);
                throw ae;
            }
            long t0 = 0L;
            if (this.profile) {
                t0 = System.currentTimeMillis();
            }
            InyoDocument document = InyoStreamUtil.getDocument(in);
            if (this.profile) {
                this.parseTime += System.currentTimeMillis() - t0;
            }
            if (this.debug) {
                InyoLogger.println("DEBUG: After deserialize(), document null?" + (null == document ? "yes" : "no"));
            }
            if (document == null) {
                this.setLastDocRecvd(true);
                if (this.debug) {
                    InyoLogger.println("DEBUG: LastDoc Recd set");
                }
                if (this.profile) {
                    InyoLogger.println("PROFILE: Time taken for reading docs " + this.count + " in ms " + this.parseTime);
                }
                return;
            }
            ++this.count;
            documentURI = document.getURI();
            if (this.debug) {
                InyoLogger.println("DEBUG: colid=" + collectionId + " uri " + documentURI);
            }
            if (!this.useQueue) {
                this.index(document);
            } else if (!this.put(document)) {
                InyoLogger.println(" error in queueing doc " + documentURI);
                InyoException ae = new InyoException(new Message("R0004E.DOCUMENT_INSERT_ERROR", documentURI, collectionId), this.locale);
                throw ae;
            }
            if (this.debug) {
                InyoLogger.println("DocumentAddAction for doc no. " + this.count + " URI " + documentURI);
            }
            this.updateTimer();
        }
        catch (InyoException e) {
            throw e;
        }
        catch (Exception e) {
            InyoException ae = new InyoException(new Message("R0004E.DOCUMENT_INSERT_ERROR", documentURI, collectionId), (Throwable)e);
            throw ae;
        }
        InyoTracer.exiting(sourceClass, "addDocument");
    }

    private void getDocParseResult(Hashtable headers, DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "getDocParseResult");
        int docs = 0;
        try {
            if (this.profile) {
                this.parseResTime = System.currentTimeMillis();
            }
            InyoSocketUtil.sendResponse(out);
            long t1 = 0L;
            long t0 = 0L;
            DocParseResult pr = null;
            int written = 2;
            int expired = 0;
            while (this.toProcessResults() && !this.isShutdownOn()) {
                pr = this.outDocQue.poll(5L, DEFAULT_OUTDOCQUEUE_POLL_TIMEOUT_UNITS);
                if (pr != null) {
                    ++docs;
                    if (this.profile) {
                        t0 = System.currentTimeMillis();
                    }
                    written += InyoSocketUtil.sendResponse(out, pr);
                    this.updateTimer();
                } else {
                    expired += 5;
                }
                if (this.debug) {
                    InyoLogger.println("waited in secs to flush " + expired + " in thread id " + Thread.currentThread().getId());
                }
                if (expired > 0 && written > 0 || written > 1024) {
                    out.flush();
                    written = 0;
                    expired = 0;
                }
                if (pr == null || !this.profile) continue;
                t1 += System.currentTimeMillis() - t0;
            }
            if (this.profile) {
                t0 = System.currentTimeMillis();
            }
            InyoSocketUtil.sendTerminator(out);
            if (this.debug) {
                InyoLogger.println("Sent erminator in parse result after sending " + docs);
            }
            this.setDocProcessingState(false);
            if (this.profile) {
                this.parseResTime = System.currentTimeMillis() - this.parseResTime;
                InyoLogger.println("Time taken in writing parse Result " + (t1 += System.currentTimeMillis() - t0));
                InyoLogger.println("Total Time taken in GetParse Result " + this.parseResTime);
            }
        }
        catch (Exception e) {
            throw new InyoException(new Message("D0002E.SERIALIZATION_ERROR", this.colID, "getParseResult"), (Throwable)e);
        }
        InyoTracer.exiting(sourceClass, "getDocParseResult");
    }

    public void indexNoParseResult(InyoDocument doc) {
        block8: {
            InyoTracer.entering(sourceClass, "index");
            long t0 = 0L;
            try {
                StreamedDocument aDoc = (StreamedDocument)doc.getDocument();
                if (this.profile) {
                    t0 = System.currentTimeMillis();
                }
                this.docIndexer.processDocument(this.colID, aDoc, true);
                if (this.profile) {
                    this.idxTime += System.currentTimeMillis() - t0;
                }
            }
            catch (IndexerException ex) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Loggers.logger.log(Level.SEVERE, ex);
                }
                this.processException(ex.getNonLocalizedMessage(), doc.getURI());
            }
            catch (ConfigurationManagerException ex) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Loggers.logger.log(Level.SEVERE, ex);
                }
                this.processException(ex.getNonLocalizedMessage(), doc.getURI());
            }
            catch (Exception ex) {
                InyoException en = new InyoException(ex);
                if (!Loggers.logger.isLoggable(Level.SEVERE)) break block8;
                Loggers.logger.log(Level.SEVERE, en);
            }
        }
        InyoTracer.exiting(sourceClass, "index");
    }

    private void index(InyoDocument doc) {
        block10: {
            InyoTracer.entering(sourceClass, "index");
            long t0 = 0L;
            try {
                StreamedDocument aDoc = (StreamedDocument)doc.getDocument();
                if (this.profile) {
                    t0 = System.currentTimeMillis();
                }
                this.docIndexer.processDocument(this.colID, aDoc, true);
                if (this.profile) {
                    this.idxTime += System.currentTimeMillis() - t0;
                }
                DocParseResult parseResult = new DocParseResult(doc.getURI(), 0);
                this.outDocQue.put(parseResult);
            }
            catch (InterruptedException ex) {
                InyoException en = new InyoException(ex);
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Loggers.logger.log(Level.SEVERE, en);
                }
            }
            catch (IndexerException ex) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Loggers.logger.log(Level.SEVERE, ex);
                }
                this.processException(ex.getNonLocalizedMessage(), doc.getURI());
            }
            catch (ConfigurationManagerException ex) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    Loggers.logger.log(Level.SEVERE, ex);
                }
                this.processException(ex.getNonLocalizedMessage(), doc.getURI());
            }
            catch (Exception ex) {
                InyoException en = new InyoException(ex);
                if (!Loggers.logger.isLoggable(Level.SEVERE)) break block10;
                Loggers.logger.log(Level.SEVERE, en);
            }
        }
        InyoTracer.exiting(sourceClass, "index");
    }

    private void processException(Message msg, String uri) {
        InyoTracer.entering(sourceClass, "processException");
        int retCode = 1;
        DocParseResult parseResult = new DocParseResult(uri, retCode, msg);
        try {
            this.outDocQue.put(parseResult);
        }
        catch (InterruptedException e) {
            InyoLogger.println("problem with doc indexing for doc  " + uri + " collection " + this.colID);
            e.printStackTrace();
            InyoException en = new InyoException(e);
            Loggers.logger.log(Level.SEVERE, en);
        }
        InyoTracer.exiting(sourceClass, "processException");
    }

    private class DocProcessor
    extends Thread {
        private DocProcessor() {
        }

        public void run() {
            int count = 0;
            while (!InyoAsyncDocHandler.this.isShutdownOn() && !this.isInterrupted()) {
                InyoDocument doc = null;
                try {
                    if (!InyoAsyncDocHandler.this.toProcessDocs()) break;
                    doc = InyoAsyncDocHandler.this.get();
                    if (doc == null) {
                        InyoLogger.println("No doc in the queue after processing doc no " + count);
                        continue;
                    }
                    InyoAsyncDocHandler.this.index(doc);
                    ++count;
                }
                catch (InterruptedException ex) {
                    InyoException en = new InyoException(ex);
                    if (Loggers.logger.isLoggable(Level.SEVERE)) {
                        Loggers.logger.log(Level.SEVERE, en);
                    }
                    InyoLogger.println("problem with doc indexing for doc no " + count);
                    ex.printStackTrace();
                }
                if (count % 10000 != 0) continue;
                InyoAsyncDocHandler.this.printTimeSnapshot(count);
            }
            if (InyoAsyncDocHandler.this.debug) {
                InyoLogger.println("done with doc prcessing");
            }
            InyoAsyncDocHandler.this.printTimeSnapshot(count);
            if (InyoAsyncDocHandler.this.profile) {
                InyoLogger.println("Time taken to index only " + InyoAsyncDocHandler.this.idxTime);
            }
            InyoAsyncDocHandler.this.setDocProcessingState(false);
        }
    }
}

