/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.common;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.inyo.common.InyoFactoryWrapper;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoHandler;
import com.ibm.es.nuvo.inyo.util.InyoLogger;
import com.ibm.es.nuvo.inyo.util.InyoSocketUtil;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.inyo.util.InyoUtil;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;

public final class InyoServer
extends Thread {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = InyoServer.class.getName();
    private final int port;
    private boolean debug;
    private boolean profile;
    private final ExecutorService servicePool;
    private static final int poolSize = 10;
    private int backlog;
    private ExtendedException except;
    private int timeout;

    public InyoServer(int port) {
        this.port = port;
        this.servicePool = Executors.newFixedThreadPool(10);
        this.debug = false;
        this.except = null;
        this.backlog = 0;
    }

    public InyoServer(int port, int threads, int timeout) {
        this.port = port;
        this.servicePool = Executors.newFixedThreadPool(threads);
        this.debug = false;
        this.except = null;
        this.timeout = timeout;
        this.backlog = 0;
    }

    public void setBackLogSize(int val) {
        this.backlog = val;
    }

    private void init() {
    }

    public boolean getStatus() throws ExtendedException {
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.except != null) {
            throw this.except;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        InyoTracer.entering(InyoServer.className, "run()");
        servSock = null;
        this.debug = InyoUtil.checkDebugOn();
        this.profile = InyoUtil.checkProfileOn();
        listenMesg = "listening on port " + this.port;
        reqMesg = "Got a request on port " + this.port;
        try {
            this.init();
            servSock = new ServerSocket(this.port, this.backlog);
            servSock.setReuseAddress(true);
            if (this.debug) {
                InyoLogger.println("Listening.. Inyo server on port " + this.port);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    while (true) {
                        InyoTracer.trace(listenMesg);
                        handler = new InyoListener(servSock.accept(), this.timeout);
                        if (this.debug) {
                            InyoLogger.println("Got a request on port " + this.port);
                        }
                        InyoTracer.trace(reqMesg);
                        this.servicePool.execute(handler);
                    }
                }
                catch (IOException ex) {
                    if (this.debug) {
                        ex.printStackTrace();
                    }
                    Loggers.logger.log(Level.SEVERE, ex.getMessage(), ex);
                    InyoTracer.trace(ex.getMessage());
                }
                catch (RejectedExecutionException ex) {
                    Loggers.logger.log(Level.SEVERE, ex.getMessage(), ex);
                    if (this.debug) {
                        ex.printStackTrace();
                    }
                    InyoTracer.trace(ex.getMessage());
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            this.except = new ExtendedException(new Message("D0056E.CONNECT_ERROR", new Object[]{this.port}), (Throwable)ex);
            Loggers.logger.log(Level.SEVERE, this.except);
            try {
                if (servSock != null) {
                    servSock.close();
                }
            }
            catch (Exception e) {
                if (this.debug) {
                    e.printStackTrace();
                }
                Loggers.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        catch (Exception ex) {
            try {
                if (this.debug) {
                    ex.printStackTrace();
                }
                this.except = new ExtendedException(new Message("D0056E.CONNECT_ERROR", new Object[]{this.port}), (Throwable)ex);
                Loggers.logger.log(Level.SEVERE, this.except);
            }
            catch (Throwable var5_11) {
                throw var5_11;
            }
            finally {
                try {
                    if (servSock != null) {
                        servSock.close();
                    }
                }
                catch (Exception e) {
                    if (this.debug) {
                        e.printStackTrace();
                    }
                    Loggers.logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        ** GOTO lbl-1000
        InyoTracer.exiting(InyoServer.className, "run()");
    }

    public void shutdown() throws ExtendedException {
        this.servicePool.shutdownNow();
    }

    public static void main(String[] args) {
    }

    class InyoListener
    extends Thread {
        private int timeOut;
        private Socket sock;

        InyoListener(Socket sock, int timeInMillis) {
            this.sock = sock;
            this.timeOut = timeInMillis;
            try {
                this.sock.setTcpNoDelay(true);
                this.sock.setSoTimeout(this.timeOut);
            }
            catch (SocketException ex) {
                // empty catch block
            }
        }

        public void run() {
            long t0 = 0L;
            if (InyoServer.this.profile) {
                t0 = System.currentTimeMillis();
            }
            InyoFactoryWrapper factory = InyoFactoryWrapper.getInstance();
            FilterOutputStream dout = null;
            DataInputStream din = null;
            Hashtable<String, String> params = null;
            boolean done = false;
            InyoHandler handler = null;
            try {
                String persistCon = null;
                BufferedInputStream bin = new BufferedInputStream(this.sock.getInputStream());
                din = new DataInputStream(bin);
                dout = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
                while (!done && !InyoListener.interrupted()) {
                    try {
                        Hashtable<String, String> headers = new Hashtable<String, String>(10);
                        int ret = 0;
                        ret = InyoSocketUtil.getHeaders(din, headers);
                        if (ret < 0) {
                            if (InyoServer.this.debug) {
                                if (ret == -1) {
                                    InyoLogger.println("current thread timedout id" + Thread.currentThread().getId());
                                } else {
                                    InyoLogger.println("current thread got FIN " + Thread.currentThread().getId());
                                }
                            }
                            done = true;
                            break;
                        }
                        params = headers;
                        if (InyoServer.this.profile) {
                            InyoLogger.println("time till header done avil" + (System.currentTimeMillis() - t0));
                        }
                        if (InyoServer.this.debug) {
                            InyoLogger.println(" Current Thread id " + Thread.currentThread().getId());
                            this.print(headers);
                        }
                        if (Loggers.tracer.isLoggable(Level.FINE)) {
                            this.trace(headers);
                        }
                        handler = factory.getHandler(headers);
                        handler.setTimeOut(this.timeOut);
                        handler.execute(headers, din, (DataOutputStream)dout);
                        persistCon = headers.get("conPersist");
                        if (persistCon == null) {
                            done = true;
                        }
                        if (!handler.done()) continue;
                        factory.removeHandler(headers);
                        handler = null;
                        if (!InyoServer.this.debug) continue;
                        InyoLogger.println("done with the request");
                    }
                    catch (InyoException ex) {
                        this.sendError((DataOutputStream)dout, ex);
                        Loggers.logger.log(Level.SEVERE, ex);
                        done = true;
                    }
                }
            }
            catch (IOException e) {
                ExtendedException excep = new ExtendedException(e);
                Loggers.logger.log(Level.SEVERE, excep);
                done = true;
            }
            if (done) {
                try {
                    dout.close();
                    din.close();
                    this.sock.close();
                    if (InyoServer.this.debug) {
                        InyoLogger.println("closed the socket in thred id " + Thread.currentThread().getId());
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (handler != null && handler.done()) {
                    if (InyoServer.this.debug) {
                        InyoLogger.println("calling shutdown since thread timedout id" + Thread.currentThread().getId() + " hashcode " + handler.hashCode());
                        this.print(params);
                    }
                    try {
                        handler.shutdown();
                        if (params != null && handler.hashCode() == factory.getHandler(params).hashCode()) {
                            factory.removeHandler(params);
                        }
                    }
                    catch (InyoException ex) {
                        // empty catch block
                    }
                }
            }
            if (InyoServer.this.profile) {
                t0 = System.currentTimeMillis() - t0;
                InyoLogger.println("Time spent in ms for this req" + t0);
            }
            if (InyoServer.this.debug) {
                InyoLogger.println("Exited thread run");
            }
        }

        private void print(Hashtable headers) {
            Enumeration paramsEnum = headers.keys();
            while (paramsEnum.hasMoreElements()) {
                String name = (String)paramsEnum.nextElement();
                InyoLogger.println(name + ":" + (String)headers.get(name));
            }
        }

        private void trace(Hashtable headers) {
            Enumeration paramsEnum = headers.keys();
            while (paramsEnum.hasMoreElements()) {
                String name = (String)paramsEnum.nextElement();
                InyoTracer.trace(name + ":" + (String)headers.get(name));
            }
        }

        private void sendResponse(Hashtable params, DataOutputStream dout) {
            try {
                InyoSocketUtil.sendResponse(dout);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void sendError(DataOutputStream dout, InyoException e) {
            try {
                InyoSocketUtil.sendResponse(dout, e);
            }
            catch (Exception ex) {
                ExtendedException excep = new ExtendedException(ex);
                Loggers.logger.log(Level.SEVERE, excep);
            }
        }
    }
}

