/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.common;

import com.ibm.es.nuvo.authentication.AuthenticationData;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;
import com.ibm.es.nuvo.inyo.admin.InyoAdminFactory;
import com.ibm.es.nuvo.inyo.ingest.InyoDocIngestFactory;
import com.ibm.es.nuvo.inyo.monitor.InyoMonitorFactory;
import com.ibm.es.nuvo.inyo.search.InyoSearchFactory;
import com.ibm.es.nuvo.inyo.util.InyoConstants;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoFactory;
import com.ibm.es.nuvo.inyo.util.InyoHandler;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.logging.Loggers;
import java.util.Hashtable;
import java.util.logging.Level;

public class InyoFactoryWrapper
implements InyoConstants {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = InyoFactoryWrapper.class.getName();
    private InyoFactory ingestFactory;
    private InyoFactory searchFactory;
    private InyoFactory adminFactory;
    private InyoFactory monitorFactory;
    private AuthenticationData authData;
    private static InyoFactoryWrapper myInstance;
    private boolean shutdownOn;
    private Object lockObj;

    private InyoFactoryWrapper() {
        InyoTracer.entering(sourceClass, "InyoFactoryWrapper");
        this.ingestFactory = InyoDocIngestFactory.getInstance();
        this.searchFactory = new InyoSearchFactory();
        this.adminFactory = InyoAdminFactory.getInstance();
        this.monitorFactory = InyoMonitorFactory.getInstance();
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        this.authData = (AuthenticationData)configMgr.getSettings(SettingsConfigurationManager.SettingsType.AuthenticationData);
        this.shutdownOn = false;
        this.lockObj = new Object();
        InyoTracer.exiting(sourceClass, "InyoFactoryWrapper");
    }

    public synchronized InyoHandler getHandler(Hashtable params) throws InyoException {
        InyoTracer.entering(sourceClass, "getHandler");
        InyoHandler handler = null;
        String actionType = (String)params.get("actionType");
        String locale = (String)params.get("locale");
        String pass = (String)params.get("Authorization");
        this.authenticate(pass, locale);
        if (actionType == null) {
            InyoException ae = new InyoException(new Message("G0008E.MISSING_ARGUMENT", "action"), locale);
            throw ae;
        }
        if (actionType.equals("update")) {
            handler = this.ingestFactory.getHandler(params);
        } else if (actionType.equals("select")) {
            handler = this.searchFactory.getHandler(params);
        } else if (actionType.equals("admin")) {
            handler = this.adminFactory.getHandler(params);
        } else if (actionType.equals("monitor")) {
            handler = this.monitorFactory.getHandler(params);
        } else {
            InyoException ae = new InyoException(new Message("D0027E.UNSUPORTED_ACTION", actionType), locale);
            throw ae;
        }
        String action = (String)params.get("action");
        if (action != null && action.equals("shutdown")) {
            this.checkAndSetShutdown(locale);
        }
        InyoTracer.exiting(sourceClass, "getHandler");
        return handler;
    }

    public synchronized void removeHandler(Hashtable params) throws InyoException {
        InyoTracer.entering(sourceClass, "removeHandler");
        String actionType = (String)params.get("actionType");
        String locale = (String)params.get("locale");
        if (actionType.equals("update")) {
            this.ingestFactory.removeHandler(params);
        } else if (actionType.equals("select")) {
            this.searchFactory.removeHandler(params);
        } else if (actionType.equals("admin")) {
            this.adminFactory.removeHandler(params);
        } else if (actionType.equals("monitor")) {
            this.monitorFactory.removeHandler(params);
        } else {
            InyoException ae = new InyoException(new Message("D0027E.UNSUPORTED_ACTION", "actionType"), locale);
            throw ae;
        }
        InyoTracer.exiting(sourceClass, "removeHandler");
    }

    public synchronized void shutdown() throws InyoException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndSetShutdown(String locale) throws InyoException {
        Object object = this.lockObj;
        synchronized (object) {
            InyoTracer.entering(sourceClass, "checkAndSetShutdown");
            if (this.shutdownOn) {
                throw new InyoException(new Message("D0052W.SHUTDOWN_PENDING"), locale);
            }
            this.shutdownOn = true;
        }
        InyoTracer.exiting(sourceClass, "checkAndSetShutdown");
    }

    private void authenticate(String pass, String locale) throws InyoException {
        InyoTracer.entering(sourceClass, "authenticate");
        boolean val = false;
        try {
            val = pass != null && pass.equals(this.authData.getApiPassword());
        }
        catch (ExtendedException e) {
            if (Loggers.logger.isLoggable(Level.SEVERE)) {
                Loggers.logger.log(Level.SEVERE, e);
            }
            InyoException ex = new InyoException(e);
            ex.setLocale(locale);
            throw ex;
        }
        if (!val) {
            throw new InyoException(new Message("D0040E.INVALID_AUTH_TOKEN"), locale);
        }
        InyoTracer.exiting(sourceClass, "authenticate");
    }

    public static synchronized InyoFactoryWrapper getInstance() {
        InyoTracer.entering(sourceClass, "getInstance");
        if (myInstance != null) {
            return myInstance;
        }
        myInstance = new InyoFactoryWrapper();
        return myInstance;
    }

    public static void main(String[] args) {
    }
}

