/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.common;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.JettyConfiguration;
import com.ibm.es.nuvo.inyo.common.InyoServer;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class CustomServiceManager {
    private static final String sourceClass = CustomServiceManager.class.getName();
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static CustomServiceManager instance;
    private InyoServer server;
    private int port;
    private int threads;

    private CustomServiceManager() {
        InyoTracer.entering(sourceClass, "CustomServiceManager");
        this.server = null;
    }

    public static CustomServiceManager getInstance() {
        InyoTracer.entering(sourceClass, "CustomServiceManager");
        if (instance == null) {
            instance = new CustomServiceManager();
        }
        InyoTracer.exiting(sourceClass, "CustomServiceManager");
        return instance;
    }

    public void startService() throws ExtendedException {
        InyoTracer.entering(sourceClass, "startService");
        if (Loggers.tracer.isLoggable(Level.FINE)) {
            Message msg = new Message("G0002I.TRACE_MESSAGE");
            msg.addArgument("D0063I.STARTING_SERVER");
            Loggers.tracer.log(Level.FINE, msg);
        }
        this.configureServer();
        this.server.start();
        boolean started = this.server.getStatus();
        Message msg = null;
        msg = started ? new Message("G0159I.ADMIN_SEARCH_COMBINED_STARTED_HTTP", this.port) : new Message();
        Loggers.logger.log(Level.INFO, msg);
        if (Loggers.tracer.isLoggable(Level.FINE)) {
            Loggers.tracer.log(Level.FINE, msg);
        }
        String formattedText = msg.getFormattedTextWithDisplayKey();
        System.out.println(formattedText);
        System.out.flush();
        InyoTracer.exiting(sourceClass, "startService");
    }

    public void stopService() throws ExtendedException {
        InyoTracer.entering(sourceClass, "stopService");
        if (this.server != null) {
            this.server.shutdown();
        }
        this.server = null;
        InyoTracer.exiting(sourceClass, "stopService");
    }

    private void configureServer() throws InyoException {
        InyoTracer.entering(sourceClass, "configureServer");
        String configDir = GlobalConfiguration.getConfiguration().getConfigPath();
        String fName = "jetty.xml";
        File jettyXml = new File(configDir, fName);
        try {
            JettyConfiguration jettyConfig = new JettyConfiguration(jettyXml);
            this.port = jettyConfig.getAdminHttpPort();
            this.threads = jettyConfig.getAdminHttpAcceptorThreads();
            int timeout = jettyConfig.getAdminHttpMaxIdleTimeMs();
            this.server = new InyoServer(this.port, this.threads, timeout);
        }
        catch (SAXException ex) {
            throw new InyoException(new Message("D0054E.PARSING_FAILURE", fName), (Throwable)ex);
        }
        catch (IOException e) {
            throw new InyoException(new Message("D0054E.PARSING_FAILURE", fName), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new InyoException(new Message("D0054E.PARSING_FAILURE", fName), (Throwable)e);
        }
        InyoTracer.exiting(sourceClass, "configureServer");
    }

    private boolean useCustomServer() throws InyoException {
        InyoTracer.entering(sourceClass, "useCustomServer");
        boolean use = false;
        try {
            ReleaseInfo relInfo = ReleaseInfo.getReleaseInfo();
            if (relInfo == null) {
                ReleaseInfo.initialize(null);
                relInfo = ReleaseInfo.getReleaseInfo();
            }
            use = relInfo.getValueAsBoolean("System", "UseCustomServer", true);
        }
        catch (ExtendedException e) {
            e.printStackTrace();
            throw new InyoException(e);
        }
        InyoTracer.exiting(sourceClass, "useCustomServer");
        return use;
    }

    public int getPort() {
        InyoTracer.entering(sourceClass, "");
        return this.port;
    }
}

