/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.client.test;

import com.ibm.es.nuvo.inyo.client.api.InyoSystem;
import com.ibm.es.nuvo.inyo.client.infra.Response;

public class SystemTest {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static void usage() {
        String use = "SystemTest [options] [command] \n  where options are  --host / -h  <hostname> \n                    --port / -p  <port>     \n                    --auth / -a  <authtoken> \n \n commands are getStatus \n               shutdown  \n              getStackTrace \n";
        System.err.println(use);
    }

    public static void main(String[] args) {
        String command = null;
        String host = null;
        int port = -1;
        boolean verbose = false;
        String token = null;
        if (args.length < 7) {
            SystemTest.usage();
            return;
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].equalsIgnoreCase("--host") || args[i].equalsIgnoreCase("-h")) {
                host = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("--port") || args[i].equalsIgnoreCase("-p")) {
                port = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (!args[i].equalsIgnoreCase("--auth") && !args[i].equalsIgnoreCase("-a")) continue;
            token = args[i + 1];
        }
        if (args[args.length - 1].equalsIgnoreCase("getStatus")) {
            command = "getStatus";
        } else if (args[args.length - 1].equalsIgnoreCase("shutdown")) {
            command = "shutdown";
        } else if (args[args.length - 1].equalsIgnoreCase("getStackTrace")) {
            command = "getStackTrace";
        } else {
            SystemTest.usage();
            return;
        }
        try {
            if (command.equals("getStatus")) {
                InyoSystem sys = new InyoSystem(host, port, token);
                Response.Status stat = sys.getStatus();
                if (stat == Response.Status.Done) {
                    System.out.println("System is available ");
                } else {
                    System.out.println("System is not available");
                }
            } else if (command.equals("shutdown")) {
                InyoSystem sys = new InyoSystem(host, port, token);
                sys.stop();
                System.out.println("System is shutting down");
            } else if (command.equals("getStackTrace")) {
                InyoSystem sys = new InyoSystem(host, port, token);
                System.out.println("Printing Server Stack Trace now");
                System.out.println(sys.getServerStack());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Message Text " + ex.getLocalizedMessage());
        }
    }
}

