/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.client.test;

import com.ibm.es.nuvo.inyo.client.api.Collection;
import com.ibm.es.nuvo.inyo.client.api.InyoSystem;
import com.ibm.es.nuvo.inyo.client.infra.Response;

public class CollectionTest {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static void usage() {
        String use = "CollectionTest [options] [command] \n  where options are  --host / -h  <hostname> \n                    --port / -p  <port>     \n                    --auth / -a  <authtoken> \n                    --col / -c  <collection id> \n                    --file/ -f  <file> \n                    --replace / -r  <replace> \n \n commands are getStatus \n               importSynonym  \n               deleteSynonym  \n";
        System.err.println(use);
    }

    public static void main(String[] args) {
        String command = null;
        String host = null;
        int port = -1;
        boolean verbose = false;
        String token = null;
        String col = null;
        String file = null;
        boolean replace = false;
        if (args.length < 7) {
            CollectionTest.usage();
            return;
        }
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].equalsIgnoreCase("--host") || args[i].equalsIgnoreCase("-h")) {
                host = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("--port") || args[i].equalsIgnoreCase("-p")) {
                port = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].equalsIgnoreCase("--auth") || args[i].equalsIgnoreCase("-a")) {
                token = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("--col") || args[i].equalsIgnoreCase("-c")) {
                col = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("--file") || args[i].equalsIgnoreCase("-f")) {
                file = args[i + 1];
                continue;
            }
            if (!args[i].equalsIgnoreCase("--replace") && !args[i].equalsIgnoreCase("-r")) continue;
            replace = Boolean.valueOf(args[i + 1]);
        }
        if (args[args.length - 1].equalsIgnoreCase("getStatus")) {
            command = "getStatus";
        } else if (args[args.length - 1].equalsIgnoreCase("importSynonym")) {
            command = "updateSyn";
        } else if (args[args.length - 1].equalsIgnoreCase("deleteSynonym")) {
            command = "removeSyn";
        } else {
            CollectionTest.usage();
            return;
        }
        try {
            if (command.equals("getStatus")) {
                InyoSystem sys = new InyoSystem(host, port, token);
                Response.Status stat = sys.getStatus();
                if (stat == Response.Status.Done) {
                    System.out.println("System is available ");
                } else {
                    System.out.println("System is not available");
                }
            } else if (command.equals("updateSyn")) {
                Collection collection = new Collection(host, port, token);
                collection.updateSynonym(col, file, replace);
                System.out.println("Synonym was updated");
            } else if (command.equals("removeSyn")) {
                Collection collection = new Collection(host, port, token);
                collection.removeSynonym(col);
                System.out.println("Synonym was removed");
            }
        }
        catch (Exception ex) {
            System.err.println("Message Text " + ex.getLocalizedMessage());
        }
    }
}

