/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.client.infra;

import com.ibm.es.nuvo.inyo.client.infra.Constants;
import com.ibm.es.nuvo.inyo.client.infra.InyoClient;
import com.ibm.es.nuvo.inyo.client.infra.InyoException;
import com.ibm.es.nuvo.inyo.client.infra.Result;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import java.io.IOException;

public class Response
implements Constants {
    private static final String sourceClass = Response.class.getName();
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int pos;
    private boolean toRead;
    private Status stat;
    private boolean ok;
    private byte[] buff;
    private String statusMessage;
    private InyoException exception;
    private static int MAX_BUFF_SIZE = 1024;
    private InyoClient channel;
    private Response_Type respType;
    public static short STATUS_OK = 1;
    public static short STATUS_OK_MESG = (short)5;
    public static short STATUS_ERR_MESG = (short)6;
    public static short COL_STATUS = (short)7;
    public static short STATUS_TRACE_ON = (short)2;
    public static short STATUS_TRACE_OFF = (short)3;

    public Response(InyoClient myClient) {
        InyoTracer.entering(sourceClass, "Response");
        this.buff = new byte[MAX_BUFF_SIZE];
        this.pos = 0;
        this.channel = myClient;
        this.toRead = true;
        this.respType = Response_Type.Single;
        this.statusMessage = null;
        InyoTracer.exiting(sourceClass, "Response");
    }

    public void setResponseType(Response_Type resp) {
        InyoTracer.entering(sourceClass, "setResponseType");
        this.respType = resp;
        InyoTracer.exiting(sourceClass, "setResponseType");
    }

    public boolean isOK() throws InyoException {
        InyoTracer.entering(sourceClass, "setResponseType");
        this.readAndParse();
        return this.ok;
    }

    public Status getStatusCode() throws InyoException {
        InyoTracer.entering(sourceClass, "setResponseType");
        if (this.toRead) {
            this.readAndParse();
        }
        return this.stat;
    }

    public String getStatusMessage() {
        InyoTracer.entering(sourceClass, "setResponseType");
        return this.statusMessage;
    }

    /*
     * Unable to fully structure code
     */
    private void readAndParse() throws InyoException {
        InyoTracer.entering(Response.sourceClass, "setResponseType");
        if (this.respType == Response_Type.Single) {
            try {
                status = this.channel.readShort();
                if (status == Response.STATUS_OK) {
                    this.stat = Status.Done;
                    this.ok = true;
                }
                if (status == Response.STATUS_TRACE_OFF) {
                    this.stat = Status.TRACEOFF;
                }
                if (status == Response.STATUS_TRACE_ON) {
                    this.stat = Status.TRACEON;
                }
                if (status != Response.STATUS_ERR_MESG) ** GOTO lbl49
                this.stat = Status.Failed;
                envlen = this.channel.readShort();
                keylen = this.channel.readShort();
                off = 0;
                this.channel.receiveFully(this.buff, this.pos, keylen);
                vallen = this.channel.readShort();
                this.channel.receiveFully(this.buff, this.pos, vallen);
                key = new String(this.buff, off, (int)vallen, "UTF-8");
                keylen = this.channel.readShort();
                this.channel.receiveFully(this.buff, this.pos, keylen);
                vallen = this.channel.readShort();
                this.channel.receiveFully(this.buff, this.pos, vallen);
                val = new String(this.buff, off, (int)vallen, "UTF-8");
                this.exception = new InyoException(new Throwable(), key, val);
            }
            catch (IOException x) {
                throw new InyoException(x);
            }
        } else if (this.respType != Response_Type.SearchStream && this.respType != Response_Type.IndexStream && this.respType == Response_Type.Stream) {
            try {
                status = this.channel.readShort();
                if (status == Response.COL_STATUS) {
                    this.stat = Status.Done;
                    this.ok = true;
                    msgLen = this.channel.readShort();
                    if (msgLen > Response.MAX_BUFF_SIZE) {
                        this.buff = new byte[msgLen];
                    }
                    this.channel.receiveFully(this.buff, this.pos, msgLen);
                    this.statusMessage = new String(this.buff, 0, (int)msgLen, "UTF-8");
                } else {
                    this.stat = Status.Failed;
                }
            }
            catch (IOException x) {
                throw new InyoException(x);
            }
        }
lbl49:
        // 9 sources

        InyoTracer.exiting(Response.sourceClass, "setResponseType");
    }

    public Exception getException() {
        InyoTracer.entering(sourceClass, "setResponseType");
        return this.exception;
    }

    public Result getNextResult() {
        InyoTracer.entering(sourceClass, "setResponseType");
        return null;
    }

    public boolean hasMoreResult() {
        InyoTracer.entering(sourceClass, "setResponseType");
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Response_Type {
        Single,
        Stream,
        IndexStream,
        SearchStream;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        Done,
        Working,
        Failed,
        TRACEON,
        TRACEOFF;

    }
}

