/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.client.infra;

import com.ibm.es.nuvo.inyo.client.infra.Constants;
import com.ibm.es.nuvo.inyo.client.infra.InyoClient;
import com.ibm.es.nuvo.inyo.client.infra.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import java.io.UnsupportedEncodingException;

public class Request
implements Constants {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String sourceClass = Request.class.getName();
    private String messg;
    private byte[] buff;
    private InyoClient channel;

    public Request(InyoClient client) {
        this.channel = client;
    }

    public void send() throws InyoException {
        InyoTracer.entering(sourceClass, "send");
        this.channel.send(this);
        InyoTracer.exiting(sourceClass, "send");
    }

    public void buildSearchRequest() {
    }

    public void buildDocIngestion() {
    }

    public void buildUpdateIndex() {
    }

    public void buildReorgIndex() {
    }

    public void buildSystemGetStatus(String token) {
        InyoTracer.entering(sourceClass, "buildSystemGetStatus");
        StringBuffer sb = new StringBuffer(1024);
        sb.append("action");
        sb.append(":");
        sb.append("getStatus");
        sb.append("\n");
        sb.append("actionType");
        sb.append(":");
        sb.append("monitor");
        sb.append("\n");
        sb.append("scope");
        sb.append(":");
        sb.append("system");
        sb.append("\n");
        sb.append("locale");
        sb.append(":");
        sb.append("en_US");
        sb.append("\n");
        sb.append("Authorization");
        sb.append(":");
        sb.append(token);
        sb.append("\n");
        try {
            this.messg = sb.toString();
            this.buff = this.messg.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        InyoTracer.exiting(sourceClass, "buildSystemGetStatus");
    }

    public void buildShutdownRequest(String token) {
        InyoTracer.entering(sourceClass, "buildShutdownRequest");
        StringBuffer sb = new StringBuffer(1024);
        sb.append("action");
        sb.append(":");
        sb.append("shutdown");
        sb.append("\n");
        sb.append("actionType");
        sb.append(":");
        sb.append("monitor");
        sb.append("\n");
        sb.append("locale");
        sb.append(":");
        sb.append("en_US");
        sb.append("\n");
        sb.append("Authorization");
        sb.append(":");
        sb.append(token);
        sb.append("\n");
        try {
            this.messg = sb.toString();
            this.buff = this.messg.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        InyoTracer.exiting(sourceClass, "buildShutdownRequest");
    }

    public void buildConfigureTrace(String token, boolean on) {
        InyoTracer.entering(sourceClass, "buildConfigureTrace");
        StringBuffer sb = new StringBuffer(1024);
        sb.append("action");
        sb.append(":");
        sb.append("configureTrace");
        sb.append("\n");
        sb.append("actionType");
        sb.append(":");
        sb.append("monitor");
        sb.append("\n");
        sb.append("locale");
        sb.append(":");
        sb.append("en_US");
        sb.append("\n");
        sb.append("Authorization");
        sb.append(":");
        sb.append(token);
        sb.append("\n");
        sb.append("trace");
        sb.append(":");
        if (on) {
            sb.append("on");
        } else {
            sb.append("off");
        }
        sb.append("\n");
        try {
            this.messg = sb.toString();
            this.buff = this.messg.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        InyoTracer.exiting(sourceClass, "buildConfigureTrace");
    }

    public void buildPrintTrace(String token) {
        InyoTracer.entering(sourceClass, "buildPrintTrace");
        StringBuffer sb = new StringBuffer(1024);
        sb.append("action");
        sb.append(":");
        sb.append("printTrace");
        sb.append("\n");
        sb.append("actionType");
        sb.append(":");
        sb.append("monitor");
        sb.append("\n");
        sb.append("locale");
        sb.append(":");
        sb.append("en_US");
        sb.append("\n");
        sb.append("Authorization");
        sb.append(":");
        sb.append(token);
        sb.append("\n");
        try {
            this.messg = sb.toString();
            this.buff = this.messg.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        InyoTracer.exiting(sourceClass, "buildPrintTrace");
    }

    public void buildGetServerStack(String token) {
        InyoTracer.entering(sourceClass, "buildGetServerStack");
        StringBuffer sb = new StringBuffer(1024);
        sb.append("action");
        sb.append(":");
        sb.append("getThreadStack");
        sb.append("\n");
        sb.append("actionType");
        sb.append(":");
        sb.append("monitor");
        sb.append("\n");
        sb.append("locale");
        sb.append(":");
        sb.append("en_US");
        sb.append("\n");
        sb.append("Authorization");
        sb.append(":");
        sb.append(token);
        sb.append("\n");
        try {
            this.messg = sb.toString();
            this.buff = this.messg.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        InyoTracer.exiting(sourceClass, "buildPrintTrace");
    }

    public void buildDeleteCollection(String colId, String token) {
        InyoTracer.entering(sourceClass, "buildDeleteCollection");
        StringBuffer sb = new StringBuffer(1024);
        sb.append("action");
        sb.append(":");
        sb.append("deleteCollection");
        sb.append("\n");
        sb.append("actionType");
        sb.append(":");
        sb.append("admin");
        sb.append("\n");
        sb.append("locale");
        sb.append(":");
        sb.append("en_US");
        sb.append("\n");
        sb.append("Authorization");
        sb.append(":");
        sb.append(token);
        sb.append("\n");
        sb.append("index");
        sb.append(":");
        sb.append(colId);
        sb.append("\n");
        try {
            this.messg = sb.toString();
            this.buff = this.messg.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        InyoTracer.exiting(sourceClass, "buildDeleteCollection");
    }

    public void buildCollectionStatus(String token) {
        InyoTracer.entering(sourceClass, "buildCollectionStatus");
        StringBuffer sb = new StringBuffer(1024);
        sb.append("action");
        sb.append(":");
        sb.append("collectionStatus");
        sb.append("\n");
        sb.append("actionType");
        sb.append(":");
        sb.append("monitor");
        sb.append("\n");
        sb.append("locale");
        sb.append(":");
        sb.append("en_US");
        sb.append("\n");
        sb.append("index");
        sb.append(":");
        sb.append("dummy");
        sb.append("\n");
        sb.append("Authorization");
        sb.append(":");
        sb.append(token);
        sb.append("\n");
        try {
            this.messg = sb.toString();
            this.buff = this.messg.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        InyoTracer.exiting(sourceClass, "buildCollectionStatus");
    }

    public void buildUpdateSynonym(String token, String colId, String fileName, boolean replace) {
        InyoTracer.entering(sourceClass, "buildUpdateSynonym");
        StringBuffer sb = new StringBuffer(1024);
        sb.append("action");
        sb.append(":");
        sb.append("importSynonym");
        sb.append("\n");
        sb.append("actionType");
        sb.append(":");
        sb.append("admin");
        sb.append("\n");
        sb.append("locale");
        sb.append(":");
        sb.append("en_US");
        sb.append("\n");
        sb.append("Authorization");
        sb.append(":");
        sb.append(token);
        sb.append("\n");
        sb.append("index");
        sb.append(":");
        sb.append(colId);
        sb.append("\n");
        sb.append("fileName");
        sb.append(":");
        sb.append(fileName);
        sb.append("\n");
        sb.append("replace");
        sb.append(":");
        sb.append(Boolean.toString(replace));
        sb.append("\n");
        try {
            this.messg = sb.toString();
            this.buff = this.messg.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        InyoTracer.exiting(sourceClass, "buildUpdateSynonym");
    }

    public void buildRemoveSynonym(String token, String colId) {
        InyoTracer.entering(sourceClass, "buildRemoveSynonym");
        StringBuffer sb = new StringBuffer(1024);
        sb.append("action");
        sb.append(":");
        sb.append("removeSynonym");
        sb.append("\n");
        sb.append("actionType");
        sb.append(":");
        sb.append("admin");
        sb.append("\n");
        sb.append("locale");
        sb.append(":");
        sb.append("en_US");
        sb.append("\n");
        sb.append("Authorization");
        sb.append(":");
        sb.append(token);
        sb.append("\n");
        sb.append("index");
        sb.append(":");
        sb.append(colId);
        sb.append("\n");
        try {
            this.messg = sb.toString();
            this.buff = this.messg.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        InyoTracer.exiting(sourceClass, "buildRemoveSynonym");
    }

    public byte[] getMessage() {
        InyoTracer.entering(sourceClass, "getMessage");
        return this.buff;
    }

    public int getMessageLength() {
        InyoTracer.entering(sourceClass, "getMessageLength");
        return this.buff.length;
    }
}

