/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.client.infra;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.inyo.client.infra.InyoException;
import com.ibm.es.nuvo.inyo.client.infra.Request;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class InyoClient {
    private static final String className = InyoClient.class.getName();
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int timeOut;
    private int conTimeOut;
    private String host;
    private int port;
    private Socket sock;
    private DataInputStream din;
    private DataOutputStream dout;
    private int sent;
    private int recved;
    private boolean flush;
    private boolean connected;

    public InyoClient(String hostname, int port) throws InyoException {
        this.host = hostname;
        this.port = port;
        this.sent = 0;
        this.recved = 0;
        this.conTimeOut = 60000;
        this.timeOut = 30000;
    }

    public void flushEverySend() {
        InyoTracer.entering(className, "flushEverySend");
        this.flush = true;
        InyoTracer.exiting(className, "flushEverySend");
    }

    public void setReadTimeout(int val) {
        this.timeOut = val;
    }

    public void setConnectTimeOut(int val) {
        this.conTimeOut = val;
    }

    public int send(byte[] buff, int off, int len) throws InyoException {
        InyoTracer.entering(className, "send");
        this.connect();
        try {
            this.dout.write(buff, off, len);
            if (this.flush) {
                this.dout.flush();
            }
            InyoTracer.exiting(className, "send");
            return len;
        }
        catch (IOException ex) {
            throw new InyoException(ex);
        }
    }

    public void send(Request mesg) throws InyoException {
        InyoTracer.entering(className, "send");
        this.connect();
        try {
            int len = mesg.getMessageLength();
            this.dout.writeShort(len);
            this.dout.write(mesg.getMessage());
            this.dout.flush();
        }
        catch (IOException ex) {
            this.connected = false;
            throw new InyoException(ex);
        }
        InyoTracer.exiting(className, "send");
    }

    public void receiveFully(byte[] buff, int off, int len) throws InyoException {
        InyoTracer.entering(className, "receiveFully");
        this.connect();
        try {
            this.din.readFully(buff, off, len);
        }
        catch (IOException ex) {
            this.connected = false;
            throw new InyoException(ex);
        }
        InyoTracer.exiting(className, "receiveFully");
    }

    public int receive(byte[] buff, int off, int len) throws InyoException {
        InyoTracer.entering(className, "receive");
        this.connect();
        try {
            InyoTracer.exiting(className, "receive");
            return this.din.read(buff, off, len);
        }
        catch (IOException ex) {
            this.connected = false;
            throw new InyoException(ex);
        }
    }

    public short readShort() throws InyoException {
        InyoTracer.entering(className, "readShort");
        try {
            InyoTracer.exiting(className, "readShort");
            return this.din.readShort();
        }
        catch (IOException ex) {
            this.connected = false;
            throw new InyoException(ex);
        }
    }

    private void connect() throws InyoException {
        InyoTracer.entering(className, "connect");
        if (this.connected) {
            return;
        }
        try {
            this.sock = new Socket();
            this.sock.connect(new InetSocketAddress(this.host, this.port), this.conTimeOut);
            this.sock.setSoTimeout(this.timeOut);
            this.connected = true;
            this.dout = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            this.din = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
        }
        catch (UnknownHostException ex) {
            throw new InyoException(new Message("D0064E.CONNECT_ERROR", this.host, this.port), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new InyoException(new Message("D0064E.CONNECT_ERROR", this.host, this.port), (Throwable)ex);
        }
        InyoTracer.exiting(className, "connect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        InyoTracer.entering(className, "close");
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.connected = false;
            this.sock = null;
            this.din = null;
            this.dout = null;
        }
        InyoTracer.exiting(className, "close");
    }
}

