/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.client.api;

import com.ibm.es.nuvo.inyo.client.infra.InyoClient;
import com.ibm.es.nuvo.inyo.client.infra.InyoException;
import com.ibm.es.nuvo.inyo.client.infra.Request;
import com.ibm.es.nuvo.inyo.client.infra.Response;
import com.ibm.es.nuvo.inyo.util.InyoTracer;

public class InyoSystem {
    private static final String className = InyoSystem.class.getName();
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String host;
    private int port;
    private String token;

    public InyoSystem(String host, int port, String token) {
        this.host = host;
        this.port = port;
        this.token = token;
    }

    public void start() throws InyoException {
    }

    public void stop() throws InyoException {
        InyoTracer.entering(className, "stop");
        InyoClient client = new InyoClient(this.host, this.port);
        Request req = new Request(client);
        req.buildShutdownRequest(this.token);
        req.send();
        Response resp = new Response(client);
        resp.setResponseType(Response.Response_Type.Single);
        Response.Status stats = resp.getStatusCode();
        client.close();
        if (stats == Response.Status.Failed) {
            Exception ex = resp.getException();
            throw new InyoException(ex);
        }
        InyoTracer.exiting(className, "stop");
    }

    public Response.Status getStatus() throws InyoException {
        InyoTracer.entering(className, "getStatus");
        InyoClient client = new InyoClient(this.host, this.port);
        Request req = new Request(client);
        req.buildSystemGetStatus(this.token);
        req.send();
        Response resp = new Response(client);
        resp.setResponseType(Response.Response_Type.Single);
        Response.Status stats = resp.getStatusCode();
        client.close();
        if (stats == Response.Status.Failed) {
            Exception ex = resp.getException();
            throw new InyoException(ex);
        }
        InyoTracer.exiting(className, "getStatus", (Object)stats);
        return stats;
    }

    public String getServerStack() throws InyoException {
        InyoTracer.entering(className, "getServerStack");
        InyoClient client = new InyoClient(this.host, this.port);
        Request req = new Request(client);
        req.buildGetServerStack(this.token);
        req.send();
        Response resp = new Response(client);
        resp.setResponseType(Response.Response_Type.Stream);
        Response.Status stats = resp.getStatusCode();
        client.close();
        if (stats == Response.Status.Failed) {
            Exception ex = resp.getException();
            throw new InyoException(ex);
        }
        InyoTracer.exiting(className, "getServerStack", (Object)stats);
        return resp.getStatusMessage();
    }
}

