/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.client.api;

import com.ibm.es.nuvo.inyo.client.api.CollectionExistsException;
import com.ibm.es.nuvo.inyo.client.api.CollectionNotFoundException;
import com.ibm.es.nuvo.inyo.client.infra.InyoClient;
import com.ibm.es.nuvo.inyo.client.infra.InyoException;
import com.ibm.es.nuvo.inyo.client.infra.Request;
import com.ibm.es.nuvo.inyo.client.infra.Response;
import com.ibm.es.nuvo.inyo.util.InyoTracer;

public class Collection {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = Collection.class.getName();
    private String host;
    private int port;
    private String token;

    public Collection(String host, int port, String token) {
        this.host = host;
        this.port = port;
        this.token = token;
    }

    public void create(String colId, String dataPath, String comments) throws CollectionExistsException, InyoException {
    }

    public void delete(String colId) throws CollectionNotFoundException, InyoException {
        InyoTracer.entering(className, "delete");
        InyoClient client = new InyoClient(this.host, this.port);
        Request request = new Request(client);
        request.buildDeleteCollection(colId, this.token);
        request.send();
        Response response = new Response(client);
        response.setResponseType(Response.Response_Type.Single);
        Response.Status status = response.getStatusCode();
        client.close();
        if (status == Response.Status.Failed) {
            throw new InyoException(response.getException().getMessage());
        }
        InyoTracer.exiting(className, "delete");
    }

    public void configureTrace(boolean on) throws InyoException {
        InyoTracer.entering(className, "configureTrace", on);
        InyoClient client = new InyoClient(this.host, this.port);
        Request request = new Request(client);
        request.buildConfigureTrace(this.token, on);
        request.send();
        Response response = new Response(client);
        response.setResponseType(Response.Response_Type.Single);
        Response.Status status = response.getStatusCode();
        client.close();
        if (status == Response.Status.Failed) {
            throw new InyoException(response.getException().getMessage());
        }
        InyoTracer.exiting(className, "configureTrace");
    }

    public boolean printTrace() throws InyoException {
        InyoTracer.entering(className, "printTrace");
        InyoClient client = new InyoClient(this.host, this.port);
        Request request = new Request(client);
        request.buildPrintTrace(this.token);
        request.send();
        Response response = new Response(client);
        response.setResponseType(Response.Response_Type.Single);
        Response.Status status = response.getStatusCode();
        client.close();
        if (status == Response.Status.Failed) {
            throw new InyoException(response.getException().getMessage());
        }
        InyoTracer.exiting(className, "printTrace", (Object)status);
        return status == Response.Status.TRACEON;
    }

    public String status() throws InyoException {
        InyoTracer.entering(className, "status");
        InyoClient client = new InyoClient(this.host, this.port);
        Request request = new Request(client);
        request.buildCollectionStatus(this.token);
        request.send();
        Response response = new Response(client);
        response.setResponseType(Response.Response_Type.Stream);
        Response.Status status = response.getStatusCode();
        client.close();
        if (status == Response.Status.Failed) {
            throw new InyoException(response.getException().getMessage());
        }
        InyoTracer.exiting(className, "status", response.getStatusMessage());
        return response.getStatusMessage();
    }

    public void updateSynonym(String colId, String file, boolean replace) throws CollectionNotFoundException, InyoException {
        InyoTracer.entering(className, "updateSynonym");
        InyoClient client = new InyoClient(this.host, this.port);
        Request req = new Request(client);
        req.buildUpdateSynonym(this.token, colId, file, replace);
        req.send();
        Response resp = new Response(client);
        resp.setResponseType(Response.Response_Type.Single);
        Response.Status stats = resp.getStatusCode();
        client.close();
        if (stats == Response.Status.Failed) {
            Exception ex = resp.getException();
            throw new InyoException(ex);
        }
        InyoTracer.exiting(className, "updateSynonym");
    }

    public void removeSynonym(String colId) throws CollectionNotFoundException, InyoException {
        InyoTracer.entering(className, "removeSynonym");
        InyoClient client = new InyoClient(this.host, this.port);
        Request req = new Request(client);
        req.buildRemoveSynonym(this.token, colId);
        req.send();
        Response resp = new Response(client);
        resp.setResponseType(Response.Response_Type.Single);
        Response.Status stats = resp.getStatusCode();
        client.close();
        if (stats == Response.Status.Failed) {
            Exception ex = resp.getException();
            throw new InyoException(ex);
        }
        InyoTracer.exiting(className, "removeSynonym");
    }
}

