/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.admin;

import com.ibm.es.nuvo.inyo.admin.CollectionAdmin;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoFactory;
import com.ibm.es.nuvo.inyo.util.InyoHandler;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import java.util.Hashtable;

public class InyoAdminFactory
extends InyoFactory {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = InyoAdminFactory.class.getName();
    private Hashtable<String, InyoHandler> handlerTable = new Hashtable(30);
    private static InyoAdminFactory ownInstance = null;

    public static synchronized InyoFactory getInstance() {
        InyoTracer.entering(className, "getInstance");
        if (ownInstance == null) {
            ownInstance = new InyoAdminFactory();
        }
        InyoTracer.exiting(className, "getInstance");
        return ownInstance;
    }

    public synchronized InyoHandler getHandler(Hashtable params) throws InyoException {
        InyoTracer.entering(className, "getHandler");
        String col = (String)params.get("index");
        InyoHandler handle = null;
        try {
            if (col != null) {
                handle = this.handlerTable.get(col);
            }
            if (handle == null) {
                String act = (String)params.get("action");
                handle = act.equals("collectionStatus") ? new CollectionAdmin(col, CollectionAdmin.AdminAction.COL_STATUS) : new CollectionAdmin(col);
                this.handlerTable.put(col, handle);
                if (this.debug) {
                    handle.setDebugState(true);
                }
                if (this.profile) {
                    handle.setProfileState(true);
                }
            }
        }
        catch (Exception x) {
            throw new InyoException(x);
        }
        InyoTracer.exiting(className, "getHandler");
        return handle;
    }

    public synchronized void removeHandler(Hashtable params) throws InyoException {
        InyoTracer.entering(className, "removeHandler");
        String colId = (String)params.get("index");
        this.handlerTable.remove(colId);
        InyoTracer.exiting(className, "removeHandler");
    }

    public void shutdown() throws InyoException {
    }

    private InyoAdminFactory() {
    }
}

