/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.inyo.admin;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.backup.BackupAgent;
import com.ibm.es.nuvo.backup.BackupConfiguration;
import com.ibm.es.nuvo.backup.BackupManager;
import com.ibm.es.nuvo.backup.TaskStatus;
import com.ibm.es.nuvo.backup.jdbc.JDBCBackupManager;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.ConfigurationObjectNotExistsException;
import com.ibm.es.nuvo.configuration.ConfigurationRequest;
import com.ibm.es.nuvo.indexer.IndexFactoryImpl;
import com.ibm.es.nuvo.indexer.IndexerMonitor;
import com.ibm.es.nuvo.inyo.util.InyoException;
import com.ibm.es.nuvo.inyo.util.InyoHandler;
import com.ibm.es.nuvo.inyo.util.InyoSocketUtil;
import com.ibm.es.nuvo.inyo.util.InyoTracer;
import com.ibm.es.nuvo.inyo.util.StatusStructure;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.synonym.request.ImportSynonymRequest;
import com.ibm.es.nuvo.synonym.request.RemoveAllSynonymRequest;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.index.Index;
import com.ibm.siapi.index.IndexService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionAdmin
implements InyoHandler {
    private static final String sourceClass = CollectionAdmin.class.getName();
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Object backupManagerLock = new Object();
    HashMap<String, TaskStatus> backupTaskStatus = new HashMap();
    private TaskStatus brStatus;
    private Object brStatusLock = new Object();
    private String colID;
    private boolean debug;
    private boolean profile;
    private AdminAction action;
    private static Hashtable<String, AdminAction> lastPreviousAction = new Hashtable();

    public CollectionAdmin(String col) {
        InyoTracer.entering(sourceClass, "CollectionAdmin");
        this.colID = col;
        this.debug = false;
        this.profile = false;
        this.action = AdminAction.NONE;
        InyoTracer.exiting(sourceClass, "CollectionAdmin");
    }

    public CollectionAdmin(String col, AdminAction act) {
        InyoTracer.entering(sourceClass, "CollectionAdmin");
        this.colID = col;
        this.debug = false;
        this.profile = false;
        this.action = act;
        InyoTracer.exiting(sourceClass, "CollectionAdmin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Hashtable headers, DataInputStream in, DataOutputStream out) throws InyoException {
        InyoTracer.entering(sourceClass, "execute");
        Object object = this.brStatusLock;
        synchronized (object) {
            if (this.brStatus != null && this.brStatus.getExecutionState() == TaskStatus.ExecutionState.Stopped) {
                this.brStatus = null;
                this.setAction(AdminAction.NONE);
            }
        }
        String locale = (String)headers.get("locale");
        if (this.getAction() != AdminAction.NONE) {
            Message m = new Message("D0060W.CONCURRENT_ADMIN_ACTION_NOT_ALLOWED");
            throw new InyoException(m, locale);
        }
        String act = (String)headers.get("action");
        if (act.equals("createCollection")) {
            this.createCollection(headers);
        } else if (act.equals("deleteCollection")) {
            this.deleteCollection(headers);
        } else if (act.equals("updateIndex")) {
            this.updateIndex(headers);
        } else if (act.equals("reorgIndex")) {
            this.reorgIndex(headers);
        } else if (act.equals("backup")) {
            this.backUpCollection(headers);
        } else if (act.equals("restore")) {
            this.restoreCollection(headers);
        } else if (act.equals("importSynonym") || act.equals("removeSynonym")) {
            this.updateSynonym(headers);
        } else {
            throw new InyoException(new Message("D0027E.UNSUPORTED_ACTION", act), locale);
        }
        InyoSocketUtil.sendResponse(out);
        InyoTracer.exiting(sourceClass, "execute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatusStructure getStatus() throws InyoException {
        InyoTracer.entering(sourceClass, "getStatus");
        if (this.action == AdminAction.NONE) {
            return new StatusStructure(StatusStructure.StatusCode.DONE);
        }
        if (this.action == AdminAction.BACKUP || this.action == AdminAction.RESTORE) {
            Object object = this.brStatusLock;
            synchronized (object) {
                if (this.brStatus == null) {
                    return new StatusStructure(StatusStructure.StatusCode.DONE);
                }
                if (this.brStatus.getExecutionState() != TaskStatus.ExecutionState.Stopped) {
                    return new StatusStructure(StatusStructure.StatusCode.WORKING);
                }
                if (this.brStatus.getThrowable() == null && !this.brStatus.isInterruptRequested()) {
                    this.brStatus = null;
                    this.setAction(AdminAction.NONE);
                    return new StatusStructure(StatusStructure.StatusCode.DONE);
                }
                StatusStructure stats = new StatusStructure(StatusStructure.StatusCode.FAILED);
                if (this.brStatus.getThrowable() != null) {
                    stats.setError(new InyoException(this.brStatus.getThrowable()));
                }
                return stats;
            }
        }
        if (this.action == AdminAction.COL_STATUS) {
            StringBuffer sb = new StringBuffer();
            try {
                ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
                IndexerMonitor mon = GlobalSystem.getSingleInstance().getIndexerMonitor();
                Vector<String> collIds = configurationManager.getCollectionIds();
                Iterator<String> iter = collIds.iterator();
                String collectionId = null;
                if (iter.hasNext()) {
                    sb.append("CollectionName\t");
                    sb.append("IndexSize\t");
                    sb.append("NumOfDocuments\n");
                }
                while (iter.hasNext()) {
                    collectionId = iter.next();
                    sb.append(collectionId + "\t");
                    if (collectionId.length() < 8) {
                        sb.append("\t");
                    }
                    this.format(sb, mon.getIndexSize(collectionId), true);
                    sb.append("\t\t");
                    this.format(sb, mon.getNumberOfDocuments(collectionId), false);
                    sb.append("\n");
                }
                return new StatusStructure(StatusStructure.StatusCode.DONEWITHMESSAGE, sb.toString());
            }
            catch (Exception ce) {
                InyoException e = new InyoException(new Message("R0002E.ADMIN_ACTION_ERROR"), (Throwable)ce);
                throw e;
            }
        }
        return null;
    }

    private void format(StringBuffer sb, double number, boolean isBytes) {
        InyoTracer.entering(sourceClass, "format");
        if (!isBytes) {
            sb.append(NumberFormat.getInstance().format(number));
            return;
        }
        if (number / 1024.0 > 1024.0) {
            if (number / 1048576.0 > 1024.0) {
                if (number / 1.073741824E9 > 1024.0) {
                    sb.append(NumberFormat.getInstance().format(number / 1.073741824E9) + "G");
                } else {
                    sb.append(NumberFormat.getInstance().format(number / 1048576.0) + "M");
                }
            } else {
                sb.append(NumberFormat.getInstance().format(number / 1024.0) + "K");
            }
        } else {
            sb.append(NumberFormat.getInstance().format(number) + "B");
        }
        InyoTracer.exiting(sourceClass, "format");
    }

    @Override
    public void shutdown(Hashtable headers, OutputStream out) throws InyoException {
    }

    @Override
    public void shutdown() throws InyoException {
    }

    @Override
    public void register(InyoHandler handler) {
    }

    @Override
    public void setDebugState(boolean val) {
        InyoTracer.entering(sourceClass, "setDebugState");
        this.debug = val;
    }

    @Override
    public void setProfileState(boolean val) {
        InyoTracer.entering(sourceClass, "setProfileState");
        this.profile = val;
    }

    @Override
    public boolean done() {
        InyoTracer.entering(sourceClass, "done");
        return this.getAction() == AdminAction.NONE;
    }

    private void createCollection(Hashtable params) throws InyoException {
        InyoTracer.entering(sourceClass, "createCollection");
        this.setAction(AdminAction.CREATE_COL);
        String collectionId = (String)params.get("index");
        String dataDir = (String)params.get("dataDir");
        String description = (String)params.get("desc");
        try {
            ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
            CollectionConfiguration collection = CollectionConfiguration.createDefault();
            collection.setId(collectionId);
            if (dataDir != null) {
                collection.setParentIndexDirectory(dataDir);
            }
            if (description != null && description.length() > 0) {
                collection.setDescription(description);
            }
            configurationManager.createCollection(collection, false);
        }
        catch (Exception ce) {
            InyoException e = new InyoException(new Message("R0007E.CREATE_COLLECTION_ERROR", collectionId), (Throwable)ce);
            throw e;
        }
        finally {
            this.setAction(AdminAction.NONE);
        }
        InyoTracer.exiting(sourceClass, "createCollection");
    }

    private void deleteCollection(Hashtable params) throws InyoException {
        InyoTracer.entering(sourceClass, "deleteCollection");
        this.setAction(AdminAction.DELETE_COL);
        String collectionId = (String)params.get("index");
        try {
            ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
            configurationManager.removeCollection(collectionId);
        }
        catch (ExtendedException e) {
            InyoException ae = new InyoException(new Message("R0008E.DELETE_COLLECTION_ERROR", collectionId), (Throwable)e);
            throw ae;
        }
        catch (InterruptedException e) {
            InyoException ae = new InyoException(new Message("R0008E.DELETE_COLLECTION_ERROR", collectionId), (Throwable)e);
            throw ae;
        }
        finally {
            this.setAction(AdminAction.NONE);
        }
        InyoTracer.exiting(sourceClass, "deleteCollection");
    }

    private void updateIndex(Hashtable params) throws InyoException {
        InyoTracer.entering(sourceClass, "updateIndex");
        String colId = (String)params.get("index");
        IndexService indexService = null;
        try {
            IndexFactoryImpl indexFactory = new IndexFactoryImpl();
            indexService = indexFactory.getIndexService(null);
        }
        catch (SiapiException e) {
            InyoException ae = new InyoException(new Message("R0003E.CANNOT_GET_INDEX_SERVICE"), (Throwable)e);
            throw ae;
        }
        this.setAction(AdminAction.UPDATE_INDEX);
        lastPreviousAction.put(colId, AdminAction.UPDATE_INDEX);
        try {
            Index index = indexService.getIndex(null, colId);
            index.build();
            ConfigurationManager.getConfigurationManager().getCollection(colId).incrementBackupGeneration();
        }
        catch (Exception e) {
            InyoException ae = new InyoException(new Message("R0005E.UPDATE_INDEX_ERROR", colId), (Throwable)e);
            throw ae;
        }
        finally {
            this.setAction(AdminAction.NONE);
        }
        InyoTracer.exiting(sourceClass, "updateIndex");
    }

    private void reorgIndex(Hashtable params) throws InyoException {
    }

    @Override
    public void setTimeOut(int timeinMillis) {
    }

    private void backUpCollection(Hashtable<String, String> params) throws InyoException {
        InyoTracer.entering(sourceClass, "backUpCollection");
        String collectionID = params.get("index");
        try {
            this.setAction(AdminAction.BACKUP);
            AdminAction lastPrevious = lastPreviousAction.put(collectionID, AdminAction.BACKUP);
            if (lastPrevious == null || lastPrevious != AdminAction.UPDATE_INDEX) {
                params.put("test_connection", "true");
            }
            this.executeTransfer(BackupManager.TransferDirection.Backup, params);
        }
        catch (Exception e) {
            throw new InyoException(new Message("X0044W.BNR", collectionID), (Throwable)e);
        }
        InyoTracer.exiting(sourceClass, "backUpCollection");
    }

    private void restoreCollection(Hashtable<String, String> params) throws InyoException {
        InyoTracer.entering(sourceClass, "restoreCollection");
        try {
            this.setAction(AdminAction.RESTORE);
            this.executeTransfer(BackupManager.TransferDirection.Restore, params);
        }
        catch (Exception e) {
            throw new InyoException(new Message("X0044W.BNR", params.get("index")), (Throwable)e);
        }
        InyoTracer.exiting(sourceClass, "restoreCollection");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTransfer(BackupManager.TransferDirection transferDirection, Hashtable<String, String> headers) {
        block15: {
            InyoTracer.entering(sourceClass, "executeTransfer");
            Object object = this.backupManagerLock;
            synchronized (object) {
                if (BackupManager.getInstance() == null) {
                    BackupManager.setInstance(new JDBCBackupManager());
                }
            }
            BackupManager bm = BackupManager.getInstance();
            if (headers.get("indexes") == null) {
                headers.put("indexes", "text,synonym");
            }
            String collectionID = headers.get("index");
            BackupConfiguration bc = new BackupConfiguration(headers);
            bc.setProperty("collection", collectionID);
            bm.storeBackupConfiguration(bc);
            BackupAgent backupAgent = null;
            try {
                backupAgent = bm.createBackupAgentForCollection(collectionID, transferDirection);
                Object object2 = this.brStatusLock;
                synchronized (object2) {
                    this.brStatus = backupAgent.getBackupAgentStatus();
                }
                if (!bc.isTestConnectionOnly()) {
                    backupAgent.startBackupAgent();
                }
            }
            catch (Exception e) {
                Object object3 = this.brStatusLock;
                synchronized (object3) {
                    if (this.brStatus == null) {
                        this.brStatus = new TaskStatus();
                        this.brStatus.setExecutionState(TaskStatus.ExecutionState.Stopped);
                    }
                    this.brStatus.recordFirstThrowable(e);
                }
                if (!Loggers.logger.isLoggable(Level.SEVERE)) break block15;
                Loggers.logger.log(Level.SEVERE, new ExtendedException(new Message("X0050E.BNR", collectionID), (Throwable)e));
            }
        }
        InyoTracer.exiting(sourceClass, "executeTransfer");
    }

    private void updateSynonym(Hashtable params) throws InyoException {
        InyoTracer.entering(sourceClass, "updateSynonym");
        this.setAction(AdminAction.UPDATE_SYNONYM);
        String act = (String)params.get("action");
        String colId = (String)params.get("index");
        String locale = (String)params.get("locale");
        try {
            if (act.equals("importSynonym")) {
                ConfigurationRequest request;
                String fileName = (String)params.get("fileName");
                String replaceStr = (String)params.get("replace");
                boolean replace = Boolean.parseBoolean(replaceStr);
                FileInputStream fis = new FileInputStream(new File(fileName));
                if (replace) {
                    request = new RemoveAllSynonymRequest();
                    ConfigurationManager.getConfigurationManager().updateCollection(colId, request);
                }
                request = new ImportSynonymRequest(fis);
                ConfigurationManager.getConfigurationManager().updateCollection(colId, request);
            } else if (act.equals("removeSynonym")) {
                RemoveAllSynonymRequest request = new RemoveAllSynonymRequest();
                ConfigurationManager.getConfigurationManager().updateCollection(colId, request);
            }
        }
        catch (ConfigurationManagerException e) {
            InyoException ex = new InyoException(e);
            ex.setLocale(locale);
            throw ex;
        }
        catch (ConfigurationObjectNotExistsException e) {
            InyoException ex = new InyoException(e);
            ex.setLocale(locale);
            throw ex;
        }
        catch (FileNotFoundException e) {
            InyoException ex = new InyoException(e);
            ex.setLocale(locale);
            throw ex;
        }
        finally {
            this.setAction(AdminAction.NONE);
        }
        InyoTracer.exiting(sourceClass, "updateSynonym");
    }

    private synchronized void setAction(AdminAction act) {
        this.action = act;
    }

    private synchronized AdminAction getAction() {
        return this.action;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AdminAction {
        NONE,
        CREATE_COL,
        DELETE_COL,
        UPDATE_INDEX,
        REORG_INDEX,
        BACKUP,
        RESTORE,
        UPDATE_SYNONYM,
        COL_STATUS;

    }
}

