/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.indexer;

import com.ibm.es.nuvo.network.remote.LocalIndexOutputService;
import com.ibm.es.nuvo.network.remote.Replicator;
import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.store.IndexOutput;

public class VIndexOutput
extends IndexOutput {
    private IndexOutput indexOutput;
    String name;
    Replicator replicator;

    public VIndexOutput(IndexOutput output, String name, Replicator replicator) {
        this.indexOutput = output;
        this.name = name;
        this.replicator = replicator;
    }

    public void close() throws IOException {
        this.indexOutput.close();
        if (this.replicator != null) {
            Properties sendProperties = new Properties();
            sendProperties.put(LocalIndexOutputService.ObjectIdKey, (Object)((Object)((Object)this)).hashCode());
            sendProperties.put(LocalIndexOutputService.ActionKey, LocalIndexOutputService.CloseKey);
            sendProperties.put(LocalIndexOutputService.ObjectIdKey, (Object)((Object)((Object)this)).hashCode());
            try {
                this.replicator.post("LocalIndexOutputService", null, sendProperties, null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void flush() throws IOException {
        this.indexOutput.flush();
        if (this.replicator != null) {
            Properties sendProperties = new Properties();
            sendProperties.put(LocalIndexOutputService.ObjectIdKey, (Object)((Object)((Object)this)).hashCode());
            sendProperties.put(LocalIndexOutputService.ActionKey, LocalIndexOutputService.FlushKey);
            sendProperties.put(LocalIndexOutputService.ObjectIdKey, (Object)((Object)((Object)this)).hashCode());
            try {
                this.replicator.post("LocalIndexOutputService", null, sendProperties, null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public long getFilePointer() {
        return this.indexOutput.getFilePointer();
    }

    public long length() throws IOException {
        return this.indexOutput.length();
    }

    private boolean filterOut() {
        return !this.name.startsWith("segments") && !this.name.endsWith(".cfs") && !this.name.endsWith(".del");
    }

    public void seek(long pos) throws IOException {
        this.indexOutput.seek(pos);
        if (this.filterOut()) {
            return;
        }
        if (this.replicator != null) {
            Properties sendProperties = new Properties();
            sendProperties.put(LocalIndexOutputService.ObjectIdKey, (Object)((Object)((Object)this)).hashCode());
            sendProperties.put(LocalIndexOutputService.ActionKey, LocalIndexOutputService.SeekKey);
            sendProperties.put(LocalIndexOutputService.PosKey, (Object)pos);
            try {
                this.replicator.post("LocalIndexOutputService", null, sendProperties, null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeByte(byte b) throws IOException {
        this.indexOutput.writeByte(b);
        if (this.filterOut()) {
            return;
        }
        if (this.replicator != null) {
            Properties sendProperties = new Properties();
            sendProperties.put(LocalIndexOutputService.ActionKey, LocalIndexOutputService.WriteByteKey);
            sendProperties.put(LocalIndexOutputService.ByteKey, (Object)b);
            sendProperties.put(LocalIndexOutputService.ObjectIdKey, (Object)((Object)((Object)this)).hashCode());
            try {
                this.replicator.post("LocalIndexOutputService", null, sendProperties, null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.indexOutput.writeBytes(b, offset, length);
        if (this.filterOut()) {
            return;
        }
        if (this.replicator != null) {
            Properties sendProperties = new Properties();
            sendProperties.put(LocalIndexOutputService.ActionKey, LocalIndexOutputService.WriteBytesKey);
            sendProperties.put(LocalIndexOutputService.OffsetKey, (Object)offset);
            sendProperties.put(LocalIndexOutputService.LengthKey, (Object)length);
            sendProperties.put(LocalIndexOutputService.ObjectIdKey, (Object)((Object)((Object)this)).hashCode());
            try {
                this.replicator.post("LocalIndexOutputService", null, sendProperties, b);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

