/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.indexer;

import com.ibm.es.nuvo.indexer.VIndexOutput;
import com.ibm.es.nuvo.network.remote.LocalIndexOutputService;
import com.ibm.es.nuvo.network.remote.Replicator;
import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class VFSDirectory
extends Directory {
    private Directory directory;
    int remoteHash;
    private String collectionId;
    private Replicator replicator;

    public static VFSDirectory getDirectory(String collectionId, String indexKey, String path, Replicator replicator) throws IOException {
        return new VFSDirectory(FSDirectory.getDirectory((String)path), collectionId, indexKey, replicator);
    }

    private VFSDirectory(FSDirectory directory, String collectionId, String indexKey, Replicator replicator) {
        this.collectionId = collectionId;
        this.directory = directory;
        this.replicator = replicator;
        this.setLockFactory(this.directory.getLockFactory());
        if (replicator != null) {
            Properties sendProperties = new Properties();
            sendProperties.put("action", "getDirectory");
            sendProperties.put("collectionId", this.collectionId);
            sendProperties.put("indexKey", indexKey);
            sendProperties.put("LocalFSDirectory.objectId", (Object)((Object)((Object)this)).hashCode());
            try {
                replicator.post("FSDirectoryService", null, sendProperties, null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() throws IOException {
        this.directory.close();
        if (this.replicator != null) {
            Properties sendProperties = new Properties();
            sendProperties.put("action", "close");
            sendProperties.put("LocalFSDirectory.objectId", (Object)((Object)((Object)this)).hashCode());
            try {
                this.replicator.post("FSDirectoryService", null, sendProperties, null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public IndexOutput createOutput(String name) throws IOException {
        VIndexOutput output = new VIndexOutput(this.directory.createOutput(name), name, this.replicator);
        if (this.replicator != null) {
            Properties sendProperties = new Properties();
            sendProperties.put("LocalFSDirectory.objectId", (Object)((Object)((Object)this)).hashCode());
            sendProperties.put("action", "createOutput");
            sendProperties.put("name", name);
            sendProperties.put(LocalIndexOutputService.ObjectIdKey, (Object)((Object)((Object)output)).hashCode());
            try {
                this.replicator.post("FSDirectoryService", null, sendProperties, null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return output;
    }

    public void deleteFile(String name) throws IOException {
        if (this.replicator != null) {
            Properties sendProperties = new Properties();
            sendProperties.put("LocalFSDirectory.objectId", (Object)((Object)((Object)this)).hashCode());
            sendProperties.put("action", "deleteFile");
            sendProperties.put("name", name);
            try {
                this.replicator.post("FSDirectoryService", null, sendProperties, null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.directory.deleteFile(name);
    }

    public boolean fileExists(String name) throws IOException {
        return this.directory.fileExists(name);
    }

    public long fileLength(String name) throws IOException {
        return this.directory.fileLength(name);
    }

    public long fileModified(String name) throws IOException {
        return this.directory.fileModified(name);
    }

    public String[] list() throws IOException {
        return this.directory.list();
    }

    public IndexInput openInput(String name) throws IOException {
        return this.directory.openInput(name);
    }

    public void renameFile(String from, String to) throws IOException {
        this.directory.renameFile(from, to);
    }

    public void touchFile(String name) throws IOException {
        this.directory.touchFile(name);
        if (this.replicator != null) {
            Properties sendProperties = new Properties();
            sendProperties.put("LocalFSDirectory.objectId", (Object)((Object)((Object)this)).hashCode());
            sendProperties.put("action", "touchFile");
            sendProperties.put("name", name);
            try {
                this.replicator.post("FSDirectoryService", null, sendProperties, null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

