/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.indexer;

import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SimilarityDelegator;

public class SpecialSimilarity
extends SimilarityDelegator {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int DEFAULT_SWEET_SPOT_LENGTH = 50;
    public static final float DEFAULT_SWEET_SPOT_MIN_VALUE = 0.02f;
    public static final float DEFAULT_SWEET_SPOT_MAX_VALUE = 0.5f;
    private int sweetSpotLength;
    private float sweetSpotMinValue;
    private float sweetSpotMaxValue;
    private static final long serialVersionUID = 1L;

    public SpecialSimilarity(Similarity delegee) {
        this(delegee, 50, 0.02f, 0.5f);
    }

    public SpecialSimilarity(Similarity delegee, int sweetSpotLength, float sweetSpotMinValue, float sweetSpotMaxValue) {
        super(delegee);
        this.sweetSpotLength = sweetSpotLength;
        this.sweetSpotMinValue = sweetSpotMinValue;
        this.sweetSpotMaxValue = sweetSpotMaxValue;
    }

    public float lengthNorm(String fieldName, int numTokens) {
        if ("_links".equals(fieldName) || "_urldepth".equals(fieldName) || "_plain".equals(fieldName)) {
            return 1.0f;
        }
        return super.lengthNorm(fieldName, numTokens);
    }

    public float sweetSpotLengthNorm(int numTokens) {
        if (numTokens < this.sweetSpotLength) {
            return this.sweetSpotMinValue;
        }
        return Math.min(this.sweetSpotMaxValue, 1.0f / (float)Math.sqrt(numTokens - this.sweetSpotLength + 1));
    }
}

