/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.indexer;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionBadStateException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.indexer.DocumentIndexer;
import com.ibm.es.nuvo.indexer.IndexRebuilder;
import com.ibm.es.nuvo.indexer.IndexStatistics;
import com.ibm.es.nuvo.indexer.IndexerException;
import com.ibm.es.nuvo.indexer.IndexerMonitoringInterface;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.XMLTagger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;
import org.apache.commons.io.FileSystemUtils;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class IndexerMonitor
implements IndexerMonitoringInterface,
PropertyChangeListener {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private DocumentIndexer indexer;
    private Hashtable<String, IndexStatistics> statistics;
    private static final long ExpirationTime = 15000L;

    public IndexerMonitor(DocumentIndexer indexer) {
        this.indexer = indexer;
        this.statistics = new Hashtable();
        ConfigurationManager.getConfigurationManager().addPropertyChangeListener(this);
    }

    public void getStatus(XMLTagger xmlTagger) {
        this.indexer.getStatus(xmlTagger);
    }

    public long getNumberOfDocuments(String collectionId) {
        IndexStatistics indexStatistics = this.getIndexStatsAndReloadIfNecessary(collectionId);
        return indexStatistics.numberOfDocuments;
    }

    public long getNumberOfDeletedDocuments(String collectionId) {
        IndexStatistics indexStatistics = this.getIndexStatsAndReloadIfNecessary(collectionId);
        return indexStatistics.numberOfDeletedDocuments;
    }

    public void flushStatisticsFor(String collectionId) {
        this.statistics.remove(collectionId);
    }

    public int getRebuildProgress(String collectionId) {
        ConfigurationManager configManager = ConfigurationManager.getConfigurationManager();
        try {
            CollectionConfiguration configuration = configManager.getCollection(collectionId);
            return IndexRebuilder.getRebuildProgress(configuration);
        }
        catch (ConfigurationManagerException e) {
            if (Loggers.logger.isLoggable(Level.INFO)) {
                IndexerException indexerException = new IndexerException(new Message("I0018I.CANNOT_RETRIEVE_INDEX_STATISTICS", collectionId), (Throwable)e);
                Loggers.logger.log(Level.INFO, indexerException);
            }
            return -1;
        }
        catch (IndexerException e) {
            Loggers.logger.log(e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IndexStatistics getIndexStatistics(String collectionId) {
        ConfigurationManager configManager = ConfigurationManager.getConfigurationManager();
        IndexStatistics stats = new IndexStatistics();
        IndexReader indexReader = null;
        try {
            CollectionConfiguration configuration = configManager.getCollection(collectionId);
            FSDirectory directory = FSDirectory.getDirectory((String)configuration.getIndexPath(IndexDescriptor.IndexType.Text));
            indexReader = IndexReader.open((Directory)directory);
            stats.numberOfDocuments = indexReader.numDocs();
            stats.numberOfDeletedDocuments = (long)indexReader.maxDoc() - stats.numberOfDocuments;
            String path = configuration.getCollectionDirectory();
            try {
                String defaultDataDirectory = GlobalConfiguration.getConfiguration().getDefaultDataDirectory();
                if (defaultDataDirectory != null && defaultDataDirectory.length() != 0) {
                    String dataPath = configuration.getDefaultDataDirectoryFor(IndexDescriptor.IndexType.Text);
                    path = new File(dataPath).getParent();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            stats.size = IndexerMonitor.getSpace(path);
            stats.freeSpace = IndexerMonitor.getFreespace(path, collectionId);
        }
        catch (IOException e) {
            if (Loggers.logger.isLoggable(Level.INFO)) {
                IndexerException indexerException = new IndexerException(new Message("I0018I.CANNOT_RETRIEVE_INDEX_STATISTICS", collectionId), (Throwable)e);
                Loggers.logger.log(Level.INFO, indexerException);
            }
        }
        catch (CollectionBadStateException e) {
            stats.indexState = e.getState();
        }
        catch (ConfigurationManagerException e) {
            if (Loggers.logger.isLoggable(Level.INFO)) {
                IndexerException indexerException = new IndexerException(new Message("I0018I.CANNOT_RETRIEVE_INDEX_STATISTICS", collectionId), (Throwable)e);
                Loggers.logger.log(Level.INFO, indexerException);
            }
        }
        finally {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return stats;
    }

    public synchronized void quiesceCollection(String collectionId) {
    }

    private static long getSpace(String path) throws IOException {
        File collectionPath = new File(path);
        return IndexerMonitor.getSpace(collectionPath);
    }

    private static long getFreespace(String path, String collectionId) throws IOException {
        try {
            return FileSystemUtils.freeSpaceKb((String)path);
        }
        catch (IllegalArgumentException e) {
            if (Loggers.logger.isLoggable(Level.INFO)) {
                IndexerException indexerException = new IndexerException(new Message("I0018I.CANNOT_RETRIEVE_INDEX_STATISTICS", collectionId), (Throwable)e);
                Loggers.logger.log(Level.INFO, indexerException);
            }
            return 0L;
        }
        catch (IllegalStateException e) {
            if (Loggers.logger.isLoggable(Level.INFO)) {
                IndexerException indexerException = new IndexerException(new Message("I0018I.CANNOT_RETRIEVE_INDEX_STATISTICS", collectionId), (Throwable)e);
                Loggers.logger.log(Level.INFO, indexerException);
            }
            return 0L;
        }
    }

    private static long getSpace(File file) throws IOException {
        String name = file.getName();
        long size = 0L;
        if (name.equals(".") || name.equals("..")) {
            return 0L;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                size += IndexerMonitor.getSpace(files[i]);
            }
        } else {
            return file.length();
        }
        return size;
    }

    public long getIndexSize(String collectionId) {
        IndexStatistics indexStatistics = this.getIndexStatsAndReloadIfNecessary(collectionId);
        return indexStatistics.size;
    }

    private IndexStatistics getIndexStatsAndReloadIfNecessary(String collectionId) {
        Date currentTime = new Date();
        IndexStatistics indexStatistics = this.statistics.get(collectionId);
        if (indexStatistics == null || currentTime.getTime() - indexStatistics.updateTime.getTime() > 15000L) {
            indexStatistics = this.getIndexStatistics(collectionId);
            indexStatistics.updateTime = currentTime;
            this.statistics.put(collectionId, indexStatistics);
        }
        return indexStatistics;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String collectionId;
        if ("ConfigurationObjectRemoved".equals(evt.getPropertyName()) && (collectionId = (String)evt.getNewValue()) != null) {
            this.statistics.remove(collectionId);
        }
    }
}

