/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.indexer;

import com.ibm.es.nuvo.anchortext.AnchorTextException;
import com.ibm.es.nuvo.anchortext.AnchorTextIndexer;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.configuration.CollectionBadStateException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.FieldMappingManager;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.configuration.IndexDescriptorProperties;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.DeleteCrawlerDocument;
import com.ibm.es.nuvo.documentqueue.DeleteDocument;
import com.ibm.es.nuvo.documentqueue.DeleteRemoteDocument;
import com.ibm.es.nuvo.documentqueue.DocumentStreamCreateException;
import com.ibm.es.nuvo.documentqueue.IndexerReadyDocument;
import com.ibm.es.nuvo.documentqueue.OptimizeIndexDocument;
import com.ibm.es.nuvo.documentqueue.RemoteDocument;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.documentqueue.UpdateIndexDocument;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexWriter;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import com.ibm.es.nuvo.indexer.DocumentIndexerListenerInterface;
import com.ibm.es.nuvo.indexer.DocumentStatus;
import com.ibm.es.nuvo.indexer.ExtendedIndexWriter;
import com.ibm.es.nuvo.indexer.IndexRebuilder;
import com.ibm.es.nuvo.indexer.IndexWriterContainer;
import com.ibm.es.nuvo.indexer.IndexerException;
import com.ibm.es.nuvo.indexer.IndexerRegistry;
import com.ibm.es.nuvo.indexer.IndexerStateFSM;
import com.ibm.es.nuvo.indexer.SpecialSimilarity;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.parser.ParserRegistry;
import com.ibm.es.nuvo.search.cache.CacheWriter;
import com.ibm.es.nuvo.search.cache.CacheWriterInstantiationException;
import com.ibm.es.nuvo.search.cache.CachedDocument;
import com.ibm.es.nuvo.tokenizer.PostTokenizeAnalyzer;
import com.ibm.es.nuvo.util.TimeUtils;
import com.ibm.es.nuvo.util.stream.DocumentFieldOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Indexer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String LogRecordFieldKey = "_logrecord";
    private static final int DefaultCacheBufferSize = 0x100000;
    private IndexWriterContainer indexWriter;
    private CacheWriter cacheWriter;
    private IndexRebuilder indexRebuilder;
    private ParserRegistry parserRegistry;
    private FieldMappingManager fieldMappingManager;
    private CollectionConfiguration collectionConfiguration;
    private LinkedList<DocumentIndexerListenerInterface> listeners;
    private PostTokenizeAnalyzer analyzer;
    private int useCount = 0;
    private AnchorTextIndexer anchorTextIndexer;
    private BaseDocument currentDocument;
    private boolean quiesceOnClose = false;
    private boolean indexWriterUsed = false;
    private volatile int sweepCount = 0;
    private SpecialSimilarity similarity;
    private boolean addSeed = false;
    private Random randGen = null;
    private volatile boolean shutdownPending = false;
    private TaxonomyIndexWriter taxiWriter;
    private IndexerStateFSM stateFSM;

    public synchronized boolean setState(IndexerStateFSM.IndexerState state) {
        return this.stateFSM.setState(state);
    }

    public AnchorTextIndexer getAnchorTextIndexer() {
        return this.anchorTextIndexer;
    }

    public static Indexer getIndexer(String collectionId) throws ConfigurationManagerException, IndexerException {
        ConfigurationManager configManager = ConfigurationManager.getConfigurationManager();
        return new Indexer(configManager.getCollection(collectionId));
    }

    public static void createIndex(CollectionConfiguration configuration) throws IndexerException {
        try {
            FSDirectory directory = FSDirectory.getDirectory((String)configuration.getIndexPath(IndexDescriptor.IndexType.Text));
            IndexWriter indexWriter = new IndexWriter((Directory)directory, null, true);
            indexWriter.close();
            IndexDescriptor anchorTextIndexDescriptor = configuration.getIndexDescriptorFor(IndexDescriptor.IndexType.Anchor);
            if (anchorTextIndexDescriptor != null && anchorTextIndexDescriptor.isEnabled()) {
                String anchorTextPath = configuration.getIndexPath(IndexDescriptor.IndexType.Anchor);
                directory = FSDirectory.getDirectory((String)anchorTextPath);
                indexWriter = new IndexWriter((Directory)directory, null, true);
                indexWriter.close();
            }
            Indexer.createCacheIndex(configuration);
            String crawlerIndexPath = configuration.getIndexPath(IndexDescriptor.IndexType.Crawl);
            if (crawlerIndexPath != null) {
                directory = FSDirectory.getDirectory((String)crawlerIndexPath);
                indexWriter = new IndexWriter((Directory)directory, null, true);
                indexWriter.close();
            }
        }
        catch (IOException e) {
            Message msg = new Message("I0004E.CANNOT_CREATE_INDEX");
            msg.addArgument(configuration.getId());
            throw new IndexerException(msg, (Throwable)e);
        }
    }

    public static void createCacheIndex(CollectionConfiguration configuration) throws IndexerException {
        IndexDescriptor cacheIndexDescriptor = configuration.getIndexDescriptorFor(IndexDescriptor.IndexType.Cache);
        if (cacheIndexDescriptor != null && cacheIndexDescriptor.isEnabled()) {
            try {
                String cacheIndexPath = configuration.getIndexPath(IndexDescriptor.IndexType.Cache);
                if (cacheIndexPath != null) {
                    CacheWriter cacheWriter = CacheWriter.open(configuration.getId(), cacheIndexPath, 0x100000, true, (HashMap<String, String>)configuration.getIndexDescriptorFor(IndexDescriptor.IndexType.Cache).getProperties());
                    cacheWriter.close();
                }
            }
            catch (IOException e) {
                Message msg = new Message("I0004E.CANNOT_CREATE_INDEX");
                msg.addArgument(configuration.getId());
                throw new IndexerException(msg, (Throwable)e);
            }
            catch (CacheWriterInstantiationException e) {
                Message msg = new Message("I0004E.CANNOT_CREATE_INDEX");
                msg.addArgument(configuration.getId());
                throw new IndexerException(msg, (Throwable)e);
            }
        }
    }

    private Indexer(CollectionConfiguration configuration) throws IndexerException {
        this.collectionConfiguration = configuration;
        this.listeners = new LinkedList();
        this.openIndex();
        this.indexRebuilder = new IndexRebuilder();
        this.parserRegistry = new ParserRegistry(configuration);
        this.fieldMappingManager = configuration.getFieldMappingManager();
        IndexDescriptor textIndexDescriptor = configuration.getIndexDescriptorFor(IndexDescriptor.IndexType.Text);
        String toSeed = textIndexDescriptor.getProperty("PutRandomSeed");
        if (toSeed != null && toSeed.equals("true")) {
            this.addSeed = true;
            this.randGen = new Random(System.currentTimeMillis());
        }
        this.stateFSM = new IndexerStateFSM();
    }

    public CollectionConfiguration getCollectionConfiguration() {
        return this.collectionConfiguration;
    }

    public synchronized void incUseCount() {
        ++this.useCount;
    }

    public synchronized void decUseCount() {
        --this.useCount;
    }

    public synchronized int getUseCount() {
        return this.useCount;
    }

    public int incrementSweepCount() {
        return ++this.sweepCount;
    }

    public void addListeners(LinkedList<DocumentIndexerListenerInterface> listenersToAdd) {
        this.listeners.addAll(listenersToAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DocumentIndexerListenerInterface listener) {
        LinkedList<DocumentIndexerListenerInterface> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DocumentIndexerListenerInterface listener) {
        LinkedList<DocumentIndexerListenerInterface> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * Exception decompiling
     */
    public void processUpsert(StreamedDocument sdoc, Metadata metadata, boolean throwException, boolean isRebuild) throws IndexerException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 9 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void upsertDocument(String uri, Document document, PostTokenizeAnalyzer postAnalyzer) throws IndexerException {
        try {
            Field uriField = document.getField("uri");
            if (uriField == null) {
                document.add((Fieldable)new Field("uri", uri, Field.Store.YES, Field.Index.UN_TOKENIZED));
            }
            Field crawlspaceField = document.getField("_crwsp");
            byte[] byteValue = new byte[]{crawlspaceField == null || crawlspaceField.stringValue().length() == 0 ? (byte)1 : 0};
            Field documentSourceTypeField = new Field("_documentSource", byteValue, Field.Store.YES);
            document.add((Fieldable)documentSourceTypeField);
            this.indexWriter.updateDocument(new Term("uri", uri), document, postAnalyzer);
        }
        catch (Exception e) {
            Message msg = new Message("I0005E.CANNOT_INDEX_DOCUMENT");
            msg.addArgument(uri);
            throw new IndexerException(msg, (Throwable)e);
        }
    }

    private void upsertErrorDocument(String uri, Metadata metadata, int status, Throwable cause, boolean throwException) throws IndexerException {
        if (throwException) {
            Message msg = new Message("I0005E.CANNOT_INDEX_DOCUMENT");
            msg.addArgument(uri);
            throw new IndexerException(msg, cause);
        }
        try {
            String crawlspace;
            Document doc = new Document();
            doc.add((Fieldable)new Field("uri", uri, Field.Store.YES, Field.Index.UN_TOKENIZED));
            String securityUri = metadata.get("securityuri");
            if (securityUri != null) {
                doc.add((Fieldable)new Field("securityuri", securityUri, Field.Store.YES, Field.Index.UN_TOKENIZED));
            }
            ObjectOutputStream oos = new ObjectOutputStream(new DeflaterOutputStream((OutputStream)new DocumentFieldOutputStream(doc, "_cause"), new Deflater(9)));
            oos.writeObject(cause);
            oos.close();
            doc.add((Fieldable)DocumentStatus.newStatusField(status));
            if (metadata != null && !metadata.isEmpty() && (crawlspace = metadata.get("CrawlSpaceID")) != null) {
                Field field = new Field("_crwsp", crawlspace, Field.Store.YES, Field.Index.NO_NORMS);
                doc.add((Fieldable)field);
            }
            this.indexWriter.updateDocument(new Term("uri", uri), doc, this.analyzer);
        }
        catch (IOException e) {
            Message msg = new Message("I0005E.CANNOT_INDEX_DOCUMENT");
            msg.addArgument(uri);
            throw new IndexerException(msg, (Throwable)e);
        }
    }

    private void removeDocument(String uri) throws IndexerException {
        block5: {
            try {
                this.indexWriter.deleteDocuments(new Term("uri", uri));
                if (this.anchorTextIndexer != null) {
                    this.anchorTextIndexer.deleteURL(uri);
                }
                if (this.cacheWriter != null) {
                    this.cacheWriter.deleteDocument(uri);
                }
            }
            catch (IOException ioe) {
                Message msg = new Message("I0007E.CANNOT_REMOVE_DOCUMENT");
                msg.addArgument(uri);
                throw new IndexerException(msg, (Throwable)ioe);
            }
            catch (AnchorTextException ate) {
                if (!Loggers.logger.isLoggable(Level.WARNING)) break block5;
                Loggers.logger.log(Level.WARNING, ate);
            }
        }
    }

    private void removeDocumentForCrawlspace(String crawlspace) throws IndexerException {
        try {
            this.indexWriter.deleteDocuments(new Term("_crwsp", crawlspace));
            if (this.cacheWriter != null) {
                this.cacheWriter.removeDocumentForCrawlspace(crawlspace);
            }
            this.updateIndex();
            if (this.anchorTextIndexer != null) {
                this.anchorTextIndexer.removeCrawlSpace(crawlspace);
            }
        }
        catch (IOException e) {
            throw new IndexerException(new Message("I0017W.CANNOT_REMOVE_DOCUMENTS_CRAWLED", this.collectionConfiguration.getId()));
        }
        catch (AnchorTextException e) {
            throw new IndexerException(new Message("I0017W.CANNOT_REMOVE_DOCUMENTS_CRAWLED", this.collectionConfiguration.getId()));
        }
    }

    public void getStatus(StringBuilder buffer) {
        if (this.currentDocument == null) {
            if (this.stateFSM.getState() == IndexerStateFSM.IndexerState.AnchorText) {
                buffer.append("<anchor text>");
            } else if (this.stateFSM.getState() == IndexerStateFSM.IndexerState.Idle) {
                buffer.append("<idle>");
            } else if (this.stateFSM.getState() == IndexerStateFSM.IndexerState.Text) {
                buffer.append("<text>");
            }
        } else {
            String uri = this.currentDocument.getUri();
            if (uri == null) {
                buffer.append("<no url info>");
            } else if (this.currentDocument instanceof DeleteDocument) {
                buffer.append("deleting <" + this.currentDocument.getUri() + ">");
            } else {
                buffer.append("upserting <" + this.currentDocument.getUri() + ">");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAnchorTextUpdates(long maxTime, TimeUnit maxTimeUnit) throws IndexerException {
        if (this.anchorTextIndexer == null) {
            return;
        }
        this.notifyAnchorText();
        try {
            if (this.indexWriterUsed) {
                this.updateIndex();
                if (this.anchorTextIndexer == null) {
                    return;
                }
            }
            this.anchorTextIndexer.doAsyncProcessing(this.indexWriter.getLocalIndexWriter(), maxTime, maxTimeUnit);
        }
        finally {
            this.sweepCount = 0;
        }
    }

    public void doIndexRebuild(long maxTime, TimeUnit maxTimeUnit) throws IndexerException {
        this.notifyIndexRebuild();
        long timeoutMillis = TimeUtils.timeInMillis(maxTime, maxTimeUnit);
        long stopNanoTime = System.nanoTime() + timeoutMillis * 1000000L;
        if (this.indexWriterUsed) {
            this.updateIndex();
        }
        this.indexRebuilder.doRebuild(stopNanoTime, this.collectionConfiguration, this, this.indexWriter);
    }

    public void initiateIndexRebuild() throws IndexerException {
        this.indexRebuilder.initiateRebuild(this.collectionConfiguration, this.indexWriter, this.analyzer);
    }

    public void processDocument(BaseDocument document) throws IndexerException {
        this.processDocument(document, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processDocument(BaseDocument document, boolean throwException) throws IndexerException {
        opType = null;
        this.currentDocument = document;
        docStartTime = System.currentTimeMillis();
        isRebuild = document instanceof CachedDocument;
        if (!isRebuild) {
            this.indexWriterUsed = true;
        }
        try {
            if (document instanceof DeleteDocument) {
                this.removeDocument(document.getUri());
                opType = DocumentIndexerListenerInterface.OperationType.Delete;
            } else if (document instanceof DeleteCrawlerDocument) {
                this.removeDocumentForCrawlspace(((DeleteCrawlerDocument)document).getCrawlspace());
                opType = DocumentIndexerListenerInterface.OperationType.Delete;
            } else if (document instanceof StreamedDocument) {
                opType = DocumentIndexerListenerInterface.OperationType.Upsert;
                cacheStream = null;
                doc = (StreamedDocument)document;
                try {
                    docMetadata = doc.getMetadata();
                    if (docMetadata != null && this.fieldMappingManager != null) {
                        docMetadata = this.fieldMappingManager.map(docMetadata);
                    }
                    this.processUpsert(doc, docMetadata, throwException, isRebuild);
                    if (isRebuild || (cacheStream = doc.getCacheStream()) == null && (docMetadata == null || docMetadata.getMetadataPart(Metadata.Type.CrawlerFields) == null) || this.cacheWriter == null) ** GOTO lbl63
                    this.cacheWriter.addDocument(document.getUri(), docMetadata, cacheStream, doc.getMetadata());
                }
                catch (DocumentStreamCreateException e) {
                }
                catch (IndexerException e) {
                    this.upsertErrorDocument(document.getUri(), doc.getMetadata(), 404, e, throwException);
                }
                finally {
                    if (cacheStream != null) {
                        cacheStream.close();
                    }
                }
            } else if (document instanceof UpdateIndexDocument) {
                this.updateIndex();
            } else if (document instanceof OptimizeIndexDocument) {
                this.optimizeIndex();
            } else if (document instanceof RemoteDocument) {
                if (document instanceof IndexerReadyDocument) {
                    doc = (IndexerReadyDocument)document;
                    System.out.println("Got the document for service: " + doc.getServiceName());
                    ic = IndexerRegistry.getIndexerRegistry().getIndexWriterContainer(doc.getServiceName());
                    if (ic == null) {
                        System.err.println("Ths service doesn't exist: " + doc.getServiceName());
                        return;
                    }
                    if (doc.getDocument() != null) {
                        if (doc.getTerm() != null) {
                            ic.updateDocument(doc.getTerm(), doc.getDocument());
                        } else {
                            ic.addDocument(doc.getDocument());
                        }
                    }
                } else if (document instanceof DeleteRemoteDocument) {
                    deldoc = (DeleteRemoteDocument)document;
                    ic = IndexerRegistry.getIndexerRegistry().getIndexWriterContainer(deldoc.getServiceName());
                    ic.deleteDocuments(new Term("uri", deldoc.getUri()));
                } else {
                    System.err.println("Invalid doc tyoe we shouldn't be here");
                }
            }
lbl63:
            // 14 sources

            if (opType != null) {
                this.notifyListener(document, opType, null);
            }
        }
        catch (IndexerException e) {
            if (opType != null) {
                this.notifyListener(document, opType, e);
            }
            throw e;
        }
        catch (Throwable t) {
            throw new IndexerException(new Message("I0001E.CANNOT_PARSE_DOCUMENT", new Object[]{document.getUri()}), t);
        }
        finally {
            this.currentDocument = null;
            this.sweepCount = 0;
            docEndTime = System.currentTimeMillis();
            if (System.getProperty("debugIndexTime") != null) {
                System.out.println("Document " + document.getUri() + " took " + (docEndTime - docStartTime) + " millis");
            }
        }
    }

    public void close() throws IndexerException {
        this.parserRegistry.dispose();
        this.closeIndex();
    }

    public synchronized void shutdown() throws IOException {
        this.shutdownPending = true;
        if (this.indexWriter != null) {
            this.indexWriter.shutdown();
            this.indexWriter = null;
        }
        if (this.cacheWriter != null) {
            this.cacheWriter.shutdown();
            this.cacheWriter = null;
        }
        if (this.anchorTextIndexer != null) {
            try {
                this.anchorTextIndexer.shutdown();
                this.anchorTextIndexer = null;
            }
            catch (AnchorTextException e) {
                return;
            }
        }
    }

    public void setQuiesceOnClose() {
        this.quiesceOnClose = true;
    }

    public boolean getQuiesceOnClose() {
        return this.quiesceOnClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAnchorText() {
        LinkedList<DocumentIndexerListenerInterface> linkedList = this.listeners;
        synchronized (linkedList) {
            ListIterator iterator = this.listeners.listIterator();
            while (iterator.hasNext()) {
                DocumentIndexerListenerInterface listener = (DocumentIndexerListenerInterface)iterator.next();
                listener.asyncAnchorTextStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIndexUpdated() {
        LinkedList<DocumentIndexerListenerInterface> linkedList = this.listeners;
        synchronized (linkedList) {
            ListIterator iterator = this.listeners.listIterator();
            while (iterator.hasNext()) {
                DocumentIndexerListenerInterface listener = (DocumentIndexerListenerInterface)iterator.next();
                listener.indexUpdated(this.collectionConfiguration.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIndexRebuild() {
        LinkedList<DocumentIndexerListenerInterface> linkedList = this.listeners;
        synchronized (linkedList) {
            ListIterator iterator = this.listeners.listIterator();
            while (iterator.hasNext()) {
                DocumentIndexerListenerInterface listener = (DocumentIndexerListenerInterface)iterator.next();
                listener.indexRebuild();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListener(BaseDocument document, DocumentIndexerListenerInterface.OperationType operation, ExtendedException exception) {
        LinkedList<DocumentIndexerListenerInterface> linkedList = this.listeners;
        synchronized (linkedList) {
            ListIterator iterator = this.listeners.listIterator();
            while (iterator.hasNext()) {
                DocumentIndexerListenerInterface listener = (DocumentIndexerListenerInterface)iterator.next();
                if (exception == null) {
                    listener.documentOperationSuccessful(this.collectionConfiguration.getId(), document, operation);
                    continue;
                }
                listener.documentOperationFailed(this.collectionConfiguration.getId(), document, operation, exception);
            }
        }
    }

    private void setTextIndexProperties(ExtendedIndexWriter writer) {
        IndexDescriptorProperties properties = this.collectionConfiguration.getIndexDescriptorFor(IndexDescriptor.IndexType.Text).getProperties();
        try {
            int docs = Integer.parseInt((String)properties.get("MaxBufferedDocs"));
            writer.setMaxBufferedDocs(docs);
            writer.setMaxBufferedDeleteTerms(docs);
        }
        catch (NumberFormatException e) {
            Loggers.logger.log(Level.WARNING, new Message("I0016W.CANNOT_SET_INDEX_DEFAULT_VALUE", properties.get("MaxBufferedDocs"), CollectionConfiguration.getDefaultCollectionFileName(), this.collectionConfiguration.getId()));
        }
        try {
            String value = (String)properties.get("MaxMergeDocs");
            if (value != null) {
                int docs = value.equals("Integer.MAX_VALUE") ? Integer.MAX_VALUE : Integer.parseInt(value);
                writer.setMaxMergeDocs(docs);
            }
        }
        catch (NumberFormatException e) {
            Loggers.logger.log(Level.WARNING, new Message("I0016W.CANNOT_SET_INDEX_DEFAULT_VALUE", properties.get("MaxMergeDocs"), CollectionConfiguration.getDefaultCollectionFileName(), this.collectionConfiguration.getId()));
        }
        try {
            String strBufferSize = (String)properties.get("BufferSize");
            long bufferSize = 0xA00000L;
            if (strBufferSize != null) {
                bufferSize = Integer.parseInt(strBufferSize) * 1024 * 1024;
            }
            writer.setMaxBufferSize(bufferSize);
        }
        catch (NumberFormatException e) {
            Loggers.logger.log(Level.WARNING, new Message("I0016W.CANNOT_SET_INDEX_DEFAULT_VALUE", properties.get("BufferSize"), CollectionConfiguration.getDefaultCollectionFileName(), this.collectionConfiguration.getId()));
        }
        try {
            writer.setMaxFieldLength(Integer.parseInt((String)properties.get("MaxFieldLength")));
        }
        catch (NumberFormatException e) {
            Loggers.logger.log(Level.WARNING, new Message("I0016W.CANNOT_SET_INDEX_DEFAULT_VALUE", properties.get("MaxFieldLength"), CollectionConfiguration.getDefaultCollectionFileName(), this.collectionConfiguration.getId()));
        }
        try {
            writer.setMergeFactor(Integer.parseInt((String)properties.get("MergeFactor")));
        }
        catch (NumberFormatException e) {
            Loggers.logger.log(Level.WARNING, new Message("I0016W.CANNOT_SET_INDEX_DEFAULT_VALUE", properties.get("MergeFactor"), CollectionConfiguration.getDefaultCollectionFileName(), this.collectionConfiguration.getId()));
        }
        writer.setUseCompoundFile("true".equals(properties.get("UseCompoundFile")));
    }

    private SpecialSimilarity createSpecialSimilarity() {
        String prop;
        IndexDescriptorProperties properties = this.collectionConfiguration.getIndexDescriptorFor(IndexDescriptor.IndexType.Text).getProperties();
        int sweetSpotLength = 50;
        float sweetSpotMinValue = 0.02f;
        float sweetSpotMaxValue = 0.5f;
        try {
            prop = (String)properties.get("SweetSpotLength");
            if (prop != null) {
                sweetSpotLength = Integer.parseInt(prop);
            }
        }
        catch (NumberFormatException e) {
            Loggers.logger.log(Level.WARNING, new Message("I0016W.CANNOT_SET_INDEX_DEFAULT_VALUE", properties.get("SweetSpotLength"), CollectionConfiguration.getDefaultCollectionFileName(), this.collectionConfiguration.getId()));
        }
        try {
            prop = (String)properties.get("SweetSpotMinValue");
            if (prop != null) {
                sweetSpotMinValue = Float.parseFloat(prop);
            }
        }
        catch (NumberFormatException e) {
            Loggers.logger.log(Level.WARNING, new Message("I0016W.CANNOT_SET_INDEX_DEFAULT_VALUE", properties.get("SweetSpotMinValue"), CollectionConfiguration.getDefaultCollectionFileName(), this.collectionConfiguration.getId()));
        }
        try {
            prop = (String)properties.get("SweetSpotMaxValue");
            if (prop != null) {
                sweetSpotMaxValue = Float.parseFloat(prop);
            }
        }
        catch (NumberFormatException e) {
            Loggers.logger.log(Level.WARNING, new Message("I0016W.CANNOT_SET_INDEX_DEFAULT_VALUE", properties.get("SweetSpotMaxValue"), CollectionConfiguration.getDefaultCollectionFileName(), this.collectionConfiguration.getId()));
        }
        return new SpecialSimilarity(this.indexWriter.getSimilarity(), sweetSpotLength, sweetSpotMinValue, sweetSpotMaxValue);
    }

    private synchronized void openIndex() throws IndexerException {
        IndexDescriptor descriptor;
        block9: {
            IndexDescriptor taxiDescriptor = this.collectionConfiguration.getIndexDescriptorFor(IndexDescriptor.IndexType.Facet);
            if (taxiDescriptor != null && taxiDescriptor.isEnabled()) {
                this.taxiWriter = new TaxonomyIndexWriter(this.collectionConfiguration);
            }
            this.analyzer = new PostTokenizeAnalyzer(this.taxiWriter);
            try {
                FSDirectory directory = FSDirectory.getDirectory((String)this.collectionConfiguration.getIndexPath(IndexDescriptor.IndexType.Text));
                this.indexWriter = new IndexWriterContainer((Directory)directory, (Analyzer)this.analyzer, false);
                this.similarity = this.createSpecialSimilarity();
                this.indexWriter.setSimilarity(this.similarity);
                this.indexWriter.setServiceName("index");
                this.setTextIndexProperties(this.indexWriter.getLocalIndexWriter());
            }
            catch (IOException e) {
                Message msg = new Message("I0003E.CANNOT_CREATE_INDEXER");
                msg.addArgument(this.collectionConfiguration.getId());
                throw new IndexerException(msg, (Throwable)e);
            }
            descriptor = this.collectionConfiguration.getIndexDescriptorFor(IndexDescriptor.IndexType.Anchor);
            if (descriptor != null && descriptor.isEnabled()) {
                try {
                    this.anchorTextIndexer = new AnchorTextIndexer(this.collectionConfiguration.getId(), this.analyzer);
                }
                catch (AnchorTextException ate) {
                    this.anchorTextIndexer = null;
                    if (!Loggers.logger.isLoggable(Level.WARNING) || ate.isACause(CollectionBadStateException.class)) break block9;
                    Loggers.logger.log(Level.WARNING, ate);
                }
            }
        }
        if ((descriptor = this.collectionConfiguration.getIndexDescriptorFor(IndexDescriptor.IndexType.Cache)) != null && descriptor.isEnabled()) {
            try {
                String cacheIndexPath = this.collectionConfiguration.getIndexPath(IndexDescriptor.IndexType.Cache);
                this.cacheWriter = cacheIndexPath != null ? CacheWriter.open(this.collectionConfiguration.getId(), cacheIndexPath, 0x100000, false, (HashMap<String, String>)this.collectionConfiguration.getIndexDescriptorFor(IndexDescriptor.IndexType.Cache).getProperties()) : null;
            }
            catch (CacheWriterInstantiationException e) {
                Message msg = new Message("I0003E.CANNOT_CREATE_INDEXER");
                msg.addArgument(this.collectionConfiguration.getId());
                throw new IndexerException(msg, (Throwable)e);
            }
        }
    }

    private synchronized void closeIndex() {
        block16: {
            block15: {
                Message msg;
                try {
                    if (this.indexWriter != null) {
                        this.indexWriter.close();
                    }
                }
                catch (IOException e) {
                    msg = new Message("I0006E.CANNOT_CLOSE_INDEX");
                    msg.addArgument(this.collectionConfiguration.getId());
                    Loggers.logger.log(Level.SEVERE, new IndexerException(msg, (Throwable)e));
                    try {
                        this.indexWriter.abort();
                    }
                    catch (IOException e1) {
                        msg = new Message("I0006E.CANNOT_CLOSE_INDEX");
                        msg.addArgument(this.collectionConfiguration.getId());
                        Loggers.logger.log(Level.SEVERE, new IndexerException(msg, (Throwable)e));
                    }
                }
                if (this.indexRebuilder != null) {
                    this.indexRebuilder.close();
                }
                this.indexWriterUsed = false;
                try {
                    if (this.cacheWriter != null) {
                        this.cacheWriter.close();
                    }
                }
                catch (IOException e) {
                    msg = new Message("I0006E.CANNOT_CLOSE_INDEX");
                    msg.addArgument(this.collectionConfiguration.getId());
                    Loggers.logger.log(Level.SEVERE, new IndexerException(msg, (Throwable)e));
                }
                try {
                    if (this.anchorTextIndexer != null) {
                        AnchorTextIndexer ati = this.anchorTextIndexer;
                        this.anchorTextIndexer = null;
                        ati.shutdown();
                    }
                }
                catch (AnchorTextException e) {
                    if (!Loggers.logger.isLoggable(Level.WARNING)) break block15;
                    Loggers.logger.log(Level.WARNING, e);
                }
            }
            try {
                if (this.taxiWriter != null) {
                    TaxonomyIndexWriter tw = this.taxiWriter;
                    this.taxiWriter = null;
                    tw.close();
                }
            }
            catch (TaxonomyIndexerException e) {
                if (!Loggers.logger.isLoggable(Level.WARNING)) break block16;
                Loggers.logger.log(Level.WARNING, e);
            }
        }
    }

    private synchronized void optimizeIndex() {
        Message msg;
        try {
            this.indexWriter.optimize();
        }
        catch (IOException e) {
            msg = new Message("I0048E.CANNOT_OPTIMIZE_INDEX");
            msg.addArgument(this.collectionConfiguration.getId());
            Loggers.logger.log(Level.SEVERE, new IndexerException(msg, (Throwable)e));
        }
        try {
            if (this.cacheWriter != null) {
                this.cacheWriter.optimize();
            }
        }
        catch (IOException e) {
            msg = new Message("I0048E.CANNOT_OPTIMIZE_INDEX");
            msg.addArgument(this.collectionConfiguration.getId());
            Loggers.logger.log(Level.SEVERE, new IndexerException(msg, (Throwable)e));
        }
    }

    protected void updateIndex() throws IndexerException {
        this.closeIndex();
        this.openIndex();
        this.notifyIndexUpdated();
    }

    protected boolean isIndexWriterUsed() {
        return this.indexWriterUsed;
    }

    private String getSeed() {
        int j = this.randGen.nextInt();
        if (j < 0) {
            j = -j;
        }
        return new Integer(j % 10000).toString();
    }
}

