/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.indexer;

import com.ibm.es.nuvo.documentqueue.DocumentQueueXmitServices;
import com.ibm.es.nuvo.documentqueue.IndexerReadyDocument;
import com.ibm.es.nuvo.documentqueue.SerializableDocument;
import com.ibm.es.nuvo.indexer.ExtendedIndexWriter;
import com.ibm.es.nuvo.indexer.IndexerRegistry;
import com.ibm.es.nuvo.indexer.SpecialSimilarity;
import com.ibm.es.nuvo.network.NodeManager;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;

public class IndexWriterContainer {
    private String serviceName = null;
    private ExtendedIndexWriter localIndexWriter = null;
    private String collectionName = "Default";

    public IndexWriterContainer(Directory d, Analyzer a) throws IOException {
        this.localIndexWriter = new ExtendedIndexWriter(d, a);
    }

    public IndexWriterContainer(Directory d, Analyzer a, boolean create) throws IOException {
        this.localIndexWriter = new ExtendedIndexWriter(d, a, create);
    }

    public IndexWriterContainer(File path, Analyzer a, boolean create) throws IOException {
        this.localIndexWriter = new ExtendedIndexWriter(path, a, create);
    }

    public IndexWriterContainer(File path, Analyzer a) throws IOException {
        this.localIndexWriter = new ExtendedIndexWriter(path, a);
    }

    public IndexWriterContainer(String path, Analyzer a, boolean create) throws IOException {
        this.localIndexWriter = new ExtendedIndexWriter(path, a, create);
    }

    public IndexWriterContainer(String path, Analyzer a) throws IOException {
        this.localIndexWriter = new ExtendedIndexWriter(path, a);
    }

    public void addDocument(Document d) throws IOException {
        this.localIndexWriter.addDocument(d);
        this.processDocument(d);
    }

    public void addDocument(Document d, Analyzer a) throws IOException {
        this.localIndexWriter.addDocument(d, a);
        this.processDocument(d);
    }

    public void updateDocument(Term t, Document d) throws IOException {
        this.localIndexWriter.updateDocument(t, d);
        this.processDocument(d, t);
    }

    public void updateDocument(Term t, Document d, Analyzer a) throws IOException {
        this.localIndexWriter.updateDocument(t, d, a);
        this.processDocument(d, t);
    }

    public void deleteDocuments(Term term) throws IOException {
        this.localIndexWriter.deleteDocuments(term);
        this.processDocument(term);
    }

    public void deleteDocuments(Term[] terms) throws IOException {
        this.localIndexWriter.deleteDocuments(terms);
        this.processDocument(terms);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
        IndexerRegistry ir = IndexerRegistry.getIndexerRegistry();
        ir.addIndexWriterContainer(this.serviceName, this);
    }

    public ExtendedIndexWriter getLocalIndexWriter() {
        return this.localIndexWriter;
    }

    private void processDocument(Term[] terms) {
        if (this.isReplication()) {
            IndexerReadyDocument doc = new IndexerReadyDocument(this.serviceName);
            doc.setTerms(terms);
            this.sendDocument(doc);
        }
    }

    private void processDocument(Document d) {
        if (this.isReplication()) {
            IndexerReadyDocument doc = new IndexerReadyDocument(this.serviceName, d);
            this.sendDocument(doc);
        }
    }

    private void processDocument(Document d, Term t) {
        if (this.isReplication()) {
            IndexerReadyDocument doc = new IndexerReadyDocument(this.serviceName, d);
            doc.setTerm(t);
            this.sendDocument(doc);
        }
    }

    private void processDocument(Term term) {
        if (this.isReplication()) {
            IndexerReadyDocument doc = new IndexerReadyDocument(this.serviceName);
            doc.setTerm(term);
            this.sendDocument(doc);
        }
    }

    private int sendDocument(SerializableDocument doc) {
        int rc = 0;
        try {
            Vector<SerializableDocument> docs = new Vector<SerializableDocument>();
            docs.add(doc);
            System.out.println("sending the document");
            rc = DocumentQueueXmitServices.send(this.collectionName, docs);
            System.out.println("Back from send: " + rc);
            if (rc != 200) {
                System.err.println("Error inserting document to remote queue " + rc);
                System.err.println("Not Implemented!!!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error in inserting the document ");
        }
        return rc;
    }

    private boolean isReplication() {
        return NodeManager.getInstance().isDistributingNode();
    }

    public void shutdown() throws IOException {
        this.localIndexWriter.shutdown();
    }

    public Similarity getSimilarity() {
        return this.localIndexWriter.getSimilarity();
    }

    public void setSimilarity(SpecialSimilarity similarity) {
        this.localIndexWriter.setSimilarity((Similarity)similarity);
    }

    public void close() throws IOException {
        this.localIndexWriter.close();
    }

    public void optimize() throws IOException {
        this.localIndexWriter.optimize();
    }

    public void abort() throws IOException {
        this.localIndexWriter.abort();
    }
}

